package com.yy.pushsvc.thirdparty;

import android.text.TextUtils;
import android.util.Log;

import com.huawei.hms.push.HmsMessageService;
import com.huawei.hms.push.RemoteMessage;
import com.yy.pushsvc.receiver.YYPushCallBackManager;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.report.TokenRegisterState;
import com.yy.pushsvc.report.YYPushDeviceInfoHttp;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import java.util.Arrays;

/**
 * Created by GuanYuFeng
 * on 2020/7/14
 */
public class PushHuaweiMessageService extends HmsMessageService {
    private static final String TAG = "PushHuaweiPushReceiver";
    public void onNewToken(String token) {
        //上报token状态到鹰眼系统
        try {
            if (token == null) {
                //上报华为注册失败到鹰眼海度
                TokenRegisterState.getInstance().addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_HUAWEI,
                        false, YYPushConsts.RES_FAIL, "onToken is null");
                PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN_FAILURE, "onToken " +
                        "is null");
                KLogW.i(YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN_FAILURE,"onToken " +
                        "is null");
                PushLog.inst().log("PushHuaweiPushReceiver.onToken token is null");
                return;
            }
            PushLog.inst().log("PushHuaweiPushReceiver.onToken huawei token:" + token);
            //上报华为注册成功到鹰眼海度
            TokenRegisterState.getInstance().addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_HUAWEI,
                    true, null, null);

            TokenStore.getInstance().dispatchToken(this, ThirdPartyPushType.PUSH_TYPE_HUAWEI,
                    token);
            YYPushDeviceInfoHttp.getInstance().addThirdpartyToken(ThirdPartyPushType.PUSH_TYPE_HUAWEI, token);
            PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN_SUCCESS);
            KLogW.i(YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN_SUCCESS,token);

            String newHuaweiToken = "huawei:" + token;
            if (YYPushCallBackManager.getInstance().getPushTokenCallBack() != null) {
                PushLog.inst().log("PushHuaweiPushReceiver.onToken , call IYYPushTokenCallback.onSuccess, token = " +
                        newHuaweiToken);
                YYPushCallBackManager.getInstance().getPushTokenCallBack().onSuccess(newHuaweiToken);
            }
        } catch (Exception e) {
            //上报华为注册失败到鹰眼海度
            TokenRegisterState.getInstance().addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_HUAWEI,
                    false, YYPushConsts.RES_FAIL, e.getMessage());
            PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN_FAILURE, e.getMessage());
            KLogW.i(YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN_FAILURE,e.getMessage());
            PushLog.inst().log("PushHuaweiPushReceiver.onToken error: " + StringUtil.exception2String(e));
        }
    }

    public void onSendError(String var1, Exception var2) {
        PushLog.inst().log(TAG +
                ".onSendError =" +
                var1);
    }

    public void onTokenError(Exception var1) {
        PushLog.inst().log(TAG +
                ".asyncinitAllPush HuaweiApiClient连接失败，错误码：" +
                var1);
        PushReporter.getInstance()
                .newReportFailEvtToHiido(YYPushConsts
                                .HIIDO_HUAWEI_TOKEN_RES_EVENT_ID,
                        String.valueOf(100),
                        "HuaweiApiClient连接失败");
        PushReporter.getInstance()
                .reportEvent(
                        YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN_FAILURE,
                        "HuaweiApiClient连接失败,code:" + 100);
    }


    public void onMessageReceived(RemoteMessage message) {
        if (message == null) {
            Log.e(TAG, "Received message entity is null!");
            return;
        }
        String msgString = message.getData();
        if(TextUtils.isEmpty(msgString)){
            return ;
        }
        PushLog.inst().log(TAG +
                ".onMessageReceived =" +
                msgString);
        TokenStore.getInstance().dispacthMsg(this, ThirdPartyPushType.PUSH_TYPE_HUAWEI,
                msgString);
    }
}
