package com.yy.pushsvc.thirdparty;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Base64;
import android.util.Log;

import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by DW on 2018/3/20.
 * Description 华为点击通知回调
 */

public class PushHuaweiActivity extends Activity {
    private static final String TAG = "PushHuaweiActivity";

    @Override
    protected void onStart() {
        super.onStart();
        if (!isFinishing()) {
            finish();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            AppPushInfo.getYYPushVersion(this.getApplicationContext());
            PushLog.inst().init(this.getApplicationContext());
            PushLog.inst().log(TAG + ".onCreate:StartPushHuaweiActivity");
            PushReporter.getInstance().init(this.getApplicationContext());
            parseIntent(getIntent());
            finish();
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".onCreate, exception:" + StringUtil.exception2String(e));
            e.printStackTrace();
        }
        Log.e(TAG, "onCreate: ");
    }

    private void parseIntent(Intent intent) {
        long msgid;
        long pushid;
        String payload;
        String content;
        if (intent.getData() != null) {
            content = intent.getData().getQuery();
        } else {
            return;
        }
        String subContent;
        String newSubContent;
        if (content.startsWith("msgid")) {
            msgid = Long.parseLong(intent.getData().getQueryParameter("msgid"));
            subContent = content.substring(content.indexOf("&") + 1);
            if (subContent.startsWith("pushid")) {
                pushid = Long.parseLong(intent.getData().getQueryParameter("pushid"));
                newSubContent = subContent.substring(subContent.indexOf("&") + 1);
                if (newSubContent.startsWith("payload")) {
                    payload = newSubContent.substring(newSubContent.indexOf("=") + 1);
                    if (payload.equals("")) {
                        PushLog.inst().log("PushHuaweiActivity.parseIntent payload is empty");
                    } else {
                        JSONObject jsonObject = new JSONObject();
                        try {
                            jsonObject.put("msgid", msgid);
                            jsonObject.put("payload", new String(Base64.decode(payload, Base64.DEFAULT)));
                            jsonObject.put("pushid", pushid);
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                        TokenStore.getInstance().init(this);
                        TokenStore.getInstance().dispatchNotification(this.getApplicationContext(),
                                YYPushConsts.PUSH_BROADCAST_NOTIFICATION_CLICKED,
                                ThirdPartyPushType.PUSH_TYPE_HUAWEI, jsonObject);
                    }
                } else {
                    PushLog.inst().log("PushHuaweiActivity.parseIntent newSubContent.startsWith not payload");
                }
            } else {
                PushLog.inst().log("PushHuaweiActivity.parseIntent content has no pushid");
            }
        } else {
            PushLog.inst().log("PushHuaweiActivity.parseIntent content.startsWith not msgid");
        }
    }
}
