package com.yy.pushsvc.thirdparty;

import android.content.Context;
import android.util.Log;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.yy.pushsvc.receiver.YYPushCallBackManager;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.report.TokenRegisterState;
import com.yy.pushsvc.report.YYPushDeviceInfoHttp;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by DW on 2018/3/14.
 * Description
 */

public class PushFirebaseMessagingService extends FirebaseMessagingService {
    private static final String TAG = "PushFirebaseMessagingSe";
    Context context = null;

    /**
     * Called when message is received,app is only in foreground.
     *
     * @param remoteMessage Object representing the message received from Firebase Cloud Messaging.
     */
    // [START receive_message]
    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        // [START_EXCLUDE]
        // There are two types of messages data messages and notification messages. Data messages are handled
        // here in onMessageReceived whether the app is in the foreground or background. Data messages are the type
        // traditionally used with GCM. Notification messages are only received here in onMessageReceived when the app
        // is in the foreground. When the app is in the background an automatically generated notification is displayed.
        // When the user taps on the notification they are returned to the app. Messages containing both notification
        // and data payloads are treated as notification messages. The Firebase console always sends notification
        // messages. For more see: https://firebase.google.com/docs/cloud-messaging/concept-options
        // [END_EXCLUDE]

        try {
            // Not getting messages here? See why this may be: https://goo.gl/39bRNJ
            PushLog.inst().log("PushFirebaseMessagingService.onMessageReceived receive msg");
            // Check if message contains a data payload.
            String payload = "";
            long msgid = 0;
            long pushid = 0;
            if (remoteMessage.getData().size() > 0) {
                Log.d(TAG, "Message data payload: " + remoteMessage.getData());

                if (remoteMessage.getData().containsKey("payload")) {
                    payload = remoteMessage.getData().get("payload");
                }
                if (remoteMessage.getData().containsKey("msgid")) {
                    msgid = Long.parseLong(remoteMessage.getData().get("msgid"));
                }
                if (remoteMessage.getData().containsKey("pushid")) {
                    pushid = Long.parseLong(remoteMessage.getData().get("pushid"));
                }
                if (msgid == 0) {
                    PushLog.inst().log(TAG + ".onMessageReceived msgid is 0 filter the msg");
                    return;
                }
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("payload", payload);
                    jsonObject.put("msgid", msgid);
                    jsonObject.put("pushid", pushid);
                    jsonObject.put(YYPushConsts.YY_PUSH_KEY_MSGDATA, remoteMessage.getData());
                    KLogW.i(TAG, jsonObject.toString());
                    TokenStore.getInstance()
                            .dispacthMsg(this, ThirdPartyPushType.PUSH_TYPE_FCM, jsonObject);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            // Check if message contains a notification payload.
            if (remoteMessage.getNotification() != null) {
                Log.d(TAG,
                        "Message Notification Body: " + remoteMessage.getNotification().getBody());
            }

            // Also if you intend on generating your own notifications as a result of a received FCM
            // message, here is where that should be initiated. See sendNotification method below.
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }
    // [END receive_message]

    // [START on_new_token]

    /**
     * Called if InstanceID token is updated. This may occur if the security of
     * the previous token had been compromised. Note that this is called when the InstanceID token
     * is initially generated so this is where you would retrieve the token.
     */
    @Override
    public void onNewToken(final String token) {
        try {
            PushReporter.getInstance().init(getApplicationContext());
            String newRefreshedToken = token;
            if (isJsonObject(token)) {
                PushReporter.getInstance().newReportSucEvtToHiido(YYPushConsts.HIIDO_FCM_TOKEN_CALLBACK_ISJSONOBJECT);
                JSONObject jsonObject = new JSONObject(token);
                newRefreshedToken = jsonObject.getString("token");
            }
            Log.d(TAG, "token: " + newRefreshedToken);
            PushLog.inst().log(TAG + ".onNewToken NewToken:" + newRefreshedToken);
            context = this.getApplicationContext();
            YYPushDeviceInfoHttp.getInstance().addThirdpartyToken(ThirdPartyPushType.PUSH_TYPE_FCM, newRefreshedToken);
            PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REGISTER_FCM_TOKEN_SUCCESS);
            KLogW.i(YYPushStatisticEvent.REGISTER_FCM_TOKEN_SUCCESS, newRefreshedToken);

            PushThreadPool.getPool().execute(new Runnable() {
                @Override
                public void run() {
                    if (!AppPushInfo.isDealFcmToken()) {
                        AppPushInfo.setIsDealFcmToken();
                        TokenRegisterState.getInstance().addRegisterTokenState(ThirdPartyPushType.PUSH_TYPE_FCM,
                                true, null, null);
                        if (isJsonObject(token)) {
                            try {
                                PushReporter.getInstance()
                                        .newReportSucEvtToHiido(YYPushConsts.HIIDO_FCM_TOKEN_CALLBACK_ISJSONOBJECT);
                                JSONObject jsonObject = new JSONObject(token);
                                TokenStore.getInstance().dispatchToken(context, ThirdPartyPushType.PUSH_TYPE_FCM,
                                        jsonObject.getString("token"));
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        } else {
                            TokenStore.getInstance().dispatchToken(context, ThirdPartyPushType.PUSH_TYPE_FCM, token);
                        }
                    }
                }
            });
            String newFcmToken = "fcm:" + newRefreshedToken;
            if (YYPushCallBackManager.getInstance().getPushTokenCallBack() != null) {
                YYPushCallBackManager.getInstance().getPushTokenCallBack().onSuccess(newFcmToken);
                PushLog.inst().log(TAG + ".onNewToken, call IYYPushTokenCallback.onSuccess, " +
                        "token = " + newFcmToken);
                YYPushCallBackManager.getInstance().getPushTokenCallBack()
                        .onUpdateServerUninstallFcmToken(newRefreshedToken);
            } else {
                Log.e(TAG, "onNewToken callback is null");
                AppPushInfo.saveFcmToken(newFcmToken);
            }
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".onNewToken exception:" + e);
        }

    }
    // [END on_new_token]

    @Override
    public void onDeletedMessages() {
        try{
            PushReporter.getInstance().newReportSucEvtToHiido(YYPushConsts.HIIDO_FCM_DELETE_MESSAGE_EVENT_ID);
            super.onDeletedMessages();
        }catch (Throwable t){
            t.printStackTrace();
        }
    }


    @Override
    public void onMessageSent(String s) {
        try {
            super.onMessageSent(s);
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void onSendError(String s, Exception e) {
        try {
            super.onSendError(s, e);
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean isJsonObject(String content) {
        try {
            JSONObject jsonObject = new JSONObject(content);
            if (jsonObject.has("token")) {
                PushLog.inst().log(TAG + ".isJsonObject getToken from fcm , token:" + jsonObject.getString("token"));
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".isJsonObject exception:" + e);
            return false;
        }
    }
}
