package com.yy.pushsvc.template.jumps;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;

import com.yy.pushsvc.NotificationCounter;
import com.yy.pushsvc.grouping.GroupingManager;
import com.yy.pushsvc.repush.RepushManager;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.template.ClickIntentUtil;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.YYPushConsts;

import org.json.JSONObject;

/**
 * Created by GuanYuFeng
 * on 2019/11/7
 */
public class NotificationClickReceiver1 extends BroadcastReceiver {
    private static final String TAG = "NotificationClickRec";

    @Override
    public void onReceive(Context context, Intent intent) {
        try {
            if (intent.hasExtra(ClickIntentUtil.PAYLOAD)) {
                long msgId = intent.getLongExtra(ClickIntentUtil.MSG_ID, 0);
                String pushId = intent.getStringExtra(ClickIntentUtil.PUSHI_D);
                String channelType = intent.getStringExtra(ClickIntentUtil.CHANNEL_TYPE);
                int notificationId = intent.getIntExtra(ClickIntentUtil.NOTIFICATION_ID, 0);
                String payload = intent.getStringExtra(ClickIntentUtil.PAYLOAD);
                long pushid = YYPushConsts.PUSH_TYPE_FCM;
                NotificationUtil.cancleNotification(context, notificationId);
                RepushManager.getInstance().removeAll();
                GroupingManager.removePush(notificationId + "");
                if (!TextUtils.isEmpty(pushId)) {
                    try {
                        pushid = Long.valueOf(pushId);
                    } catch (Throwable t) {
                        PushLog.inst().log(TAG + ".onCreate, exception:" + t);
                    }
                }
                NotificationCounter.getInstance().onCancelNotification(NotificationUtil.createNotificationId(msgId));
                NotificationUtil.collapseStatusBar(context);
                JSONObject json = new JSONObject();
                json.put("payload", payload);
                json.put("msgid", msgId);
                json.put("pushid", pushid);
                TokenStore.getInstance().dispatchNotification(context,
                        YYPushConsts.PUSH_BROADCAST_NOTIFICATION_CLICKED, channelType, json);
            } else {
                Log.e(TAG, "onReceive: no payload!");
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ".onCreate, exception:" + e);
        }
    }
}

