package com.yy.pushsvc.template.jumps;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.yy.pushsvc.NotificationCounter;
import com.yy.pushsvc.grouping.GroupingManager;
import com.yy.pushsvc.repush.RepushManager;
import com.yy.pushsvc.template.TemplateManager;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;

/**
 * Created by GuanYuFeng
 * on 2019/11/18
 */
public class NotificationCancleReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        try {
            long msgId = intent.getLongExtra("msgId", 0);
            GroupingManager.removePush(NotificationUtil.createNotificationId(msgId)+"");
            NotificationCounter.getInstance().onCancelNotification(NotificationUtil.createNotificationId(msgId));
            RepushManager.getInstance().removeAll();
            PushLog.inst().log("NotificationCancleReceiver");
        } catch (Throwable t) {
            PushLog.inst().log("NotificationCancleReceiver,erro = " + t);
        }
    }
}
