package com.yy.pushsvc.template;

import android.app.Activity;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import android.widget.TextView;

import com.yy.pushglide.IPushGlideListener;
import com.yy.pushglide.NotificationTarget;
import com.yy.pushsvc.IImgFailCallback;
import com.yy.pushsvc.R;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import androidx.core.app.NotificationManagerCompat;

import static android.util.TypedValue.COMPLEX_UNIT_DIP;

public class YYPushCustomViewUtil {
    private static final String TAG = "YYPushCustomViewUtil";
    private static final String NULL_TXT = "";
    private static int screenWidth;
    private static LayoutInflater inflater;
    private List<YYPushImageTarget> imageTargetList = new ArrayList<>();
    private String mpushId;
    private long msgId;
    private String channelType;
    private boolean isLarge;
    private IImgFailCallback imgFailCallback;
    private boolean isDark;
    private Context context;
    private JSONObject payload;
    //yycustompushdata 或 yycustompushlargedata
    private JSONObject yycustompushdata;
    private String templateData;
    private boolean isRemoteViews;
    private int notificationId;
    private OnViewClickListener mViewListener;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private IPushGlideListener glideListener;

    public void init(String pushId,
                     long msgId,
                     String channelType,
                     JSONObject payload,
                     Context context,
                     boolean large,
                     String templateData,
                     IImgFailCallback imgFailCallback) {
        try {
            this.mpushId = pushId;
            this.msgId = msgId;
            this.channelType = channelType;
            this.imgFailCallback = imgFailCallback;
            this.context = context;
            this.payload = payload;
            this.templateData = templateData;
            isDark = new NoficationBar().isDarkNotificationBar(context);
            isLarge = large;
            notificationId = NotificationUtil.createNotificationId(msgId);
            glideListener = TemplateManager.getInstance().getConfig().getGlideListener();
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",init,erro =" + t);
        }
    }

    /**
     * 返回remoteview
     *
     * @return
     */
    public ViewEntity parsePushCustomContent() {
        return parsePushCustomContent(true, null, null);
    }

    /**
     * 返回view
     *
     * @param isRemoteViews
     * @param notificationView
     * @param viewListener
     * @return
     */
    public ViewEntity parsePushCustomContent(boolean isRemoteViews, LinearLayout notificationView,
                                             OnViewClickListener viewListener) {
        mViewListener = viewListener;
        View view = null;
        RemoteViews mainRV = null;
        ViewEntity viewEntity = null;
        int height = 0;
        this.isRemoteViews = isRemoteViews;
        try {
            initScreen(context);
            if (isLarge) {
                yycustompushdata =
                        payload.optJSONObject(TemplateManager.PUSH_NOTIFICATION_LARGE_DATA);
                if (isRemoteViews) {
                    mainRV = new RemoteViews(context.getPackageName(),
                            R.layout.notification_framelayout_256dp);
                } else {
                    view = inflater.inflate(R.layout.notification_framelayout_256dp,
                            notificationView, false);
                }
                height = 256;
            } else {
                yycustompushdata = payload.optJSONObject(TemplateManager.PUSH_NOTIFICATION_DATA);
                if (isRemoteViews) {
                    mainRV = new RemoteViews(context.getPackageName(),
                            R.layout.notification_framelayout_64dp);
                } else {
                    view = inflater.inflate(R.layout.notification_framelayout_64dp,
                            notificationView, false);
                }
                height = 64;
            }
            PushLog.inst().log("width=" + screenWidth + ",height=" + height);
            JSONObject jsonObject = new JSONObject(templateData);
            JSONArray jsonArray = jsonObject.optJSONArray("childs");
            JSONObject intentmap = jsonObject.optJSONObject("intent");
            if (intentmap != null) {
                String skiplinkkey = intentmap.optString("skiplinkkey", NULL_TXT);
                JSONObject skiplinkmap = yycustompushdata.optJSONObject("skiplinkmap");

                String skiplinkvalue = "";
                if (skiplinkmap != null && !skiplinkkey.equals("")) {
                    skiplinkvalue =
                            skiplinkmap.has(skiplinkkey) ? skiplinkmap.getString(skiplinkkey) : "";
                }

                Intent notifyIntent = ClickIntentUtil
                        .getLuluboxIntent(context,
                                payload.toString(),
                                skiplinkvalue,
                                mpushId,
                                notificationId,
                                msgId,
                                channelType);
                PendingIntent pendingIntent = null;

                if (isRemoteViews) {
                    pendingIntent = PendingIntent.getBroadcast(context, notificationId,
                            notifyIntent, PendingIntent.FLAG_UPDATE_CURRENT);
                    mainRV.setOnClickPendingIntent(R.id.notification_main, pendingIntent);
                } else {
                    view.setOnClickListener(new ViewClickListener(notifyIntent));
                }
            }
            viewEntity = new ViewEntity(mainRV, view, isRemoteViews);
            if (jsonArray.length() > 0) {
                JSONArray array = jsonArray.getJSONArray(0);
                if (array.length() > 0) {
                    parseChildViews(screenWidth, height, viewEntity, R.id.notification_main, array);
                }
            }
        } catch (Throwable e) {
            PushLog.inst().log("parsePushCustomContent failed:" + Log.getStackTraceString(e));
        }
        return viewEntity;
    }

    private static void initScreen(Context context) {
        try {
            if (screenWidth == 0) {
                if (context != null) {
                    WindowManager wm =
                            (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
                    DisplayMetrics dm = new DisplayMetrics();
                    wm.getDefaultDisplay().getMetrics(dm);
                    float density = dm.density;
                    screenWidth = (int) (dm.widthPixels / density);
                    inflater = LayoutInflater.from(context);
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ".erro= " + t.toString());
        }
    }

    public void handlePushImages() {
        try {
            if (imageTargetList.size() > 0) {
                for (final YYPushImageTarget imageTarget : imageTargetList) {
                    switch (imageTarget.type) {
                        case "image":
                            mainHandler.post(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        if (context == null) {
                                            return;
                                        }
                                        if (context instanceof Activity) {
                                            Activity act = (Activity) context;
                                            if (act.isDestroyed()) {
                                                return;
                                            }
                                        }
                                        if (glideListener != null) {
                                            glideListener.onImageLoad(context, imageTarget.imageUrl,
                                                    getRadius(imageTarget.cornerradius),
                                                    dpToPx(imageTarget.width <= 0 ?
                                                            Integer.MIN_VALUE : imageTarget.width),
                                                    dpToPx(imageTarget.height <= 0 ?
                                                            Integer.MIN_VALUE
                                                            : imageTarget.height),
                                                    (ImageView) imageTarget.mViewEntity.mView);
                                        }
                                    } catch (Throwable t) {
                                        PushLog.inst().log(TAG + ".erro= " + t.toString());
                                    }
                                }
                            });
                            break;
                        default:
                        case "color":

                            final Bitmap bitmap =
                                    Bitmap.createBitmap(dpToPx(imageTarget.width),
                                            dpToPx(imageTarget.height),
                                            Bitmap.Config.ARGB_8888);
                            bitmap.eraseColor(imageTarget.colorvalue);
                            mainHandler.post(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        if (context == null) {
                                            return;
                                        }
                                        if (context instanceof Activity) {
                                            Activity act = (Activity) context;
                                            if (act.isDestroyed()) {
                                                return;
                                            }
                                        }

                                        if (glideListener != null) {
                                            glideListener.onImageLoad(context, bitmap2Bytes(bitmap),
                                                    getRadius(imageTarget.cornerradius),
                                                    dpToPx(imageTarget.width <= 0 ?
                                                            Integer.MIN_VALUE : imageTarget.width),
                                                    dpToPx(imageTarget.height <= 0 ?
                                                            Integer.MIN_VALUE
                                                            : imageTarget.height),
                                                    (ImageView) imageTarget.mViewEntity.mView);
                                        }
                                    } catch (Throwable t) {
                                        PushLog.inst().log(TAG + ".erro= " + t.toString());
                                    }
                                }
                            });
                            break;
                    }
                }
            }
            imageTargetList.clear();
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ".erro= " + t.toString());
        }
    }

    private int getRadius( int dp){
       return (int) (Resources.getSystem().getDisplayMetrics().density * dp);
    }

    public void handlePushImages(Notification notification,
                                 int notificationId) {
        try {
            if (imageTargetList.size() > 0) {
                NotificationHandler nhandler =
                        new NotificationHandler(context, imageTargetList.size(), notificationId,
                                notification);
                for (final YYPushImageTarget imageTarget : imageTargetList) {
                    final NotificationTarget notificationTarget = new NotificationTarget(context,
                            imageTarget.mViewEntity, imageTarget.id, notification, notificationId,
                            imageTarget.width, imageTarget.height, imageTarget.cornerradius,
                            mpushId,
                            nhandler);
                    notificationTarget.url = imageTarget.imageUrl;
                    notificationTarget.pushId = mpushId;
                    switch (imageTarget.type) {
                        case "image":
                            mainHandler.post(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        if (context == null) {
                                            return;
                                        }
                                        if (context instanceof Activity) {
                                            Activity act = (Activity) context;
                                            if (act.isDestroyed()) {
                                                return;
                                            }
                                        }

                                        if (glideListener != null) {
                                            glideListener.onImageLoad(context, imageTarget.imageUrl,
                                                    getRadius(imageTarget.cornerradius),
                                                    dpToPx(imageTarget.width <= 0 ?
                                                            Integer.MIN_VALUE : imageTarget.width),
                                                    dpToPx(imageTarget.height <= 0 ?
                                                            Integer.MIN_VALUE
                                                            : imageTarget.height),
                                                    notificationTarget);
                                        }
                                    } catch (Throwable t) {
                                        PushLog.inst().log(TAG + ".erro= " + t.toString());
                                    }
                                }
                            });
                            break;
                        default:
                        case "color":
                            final Bitmap bitmap = Bitmap.createBitmap(dpToPx(imageTarget.width),
                                    dpToPx(imageTarget.height), Bitmap.Config.ARGB_8888);
                            bitmap.eraseColor(imageTarget.colorvalue);
                            mainHandler.post(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        if (context == null) {
                                            return;
                                        }
                                        if (context instanceof Activity) {
                                            Activity act = (Activity) context;
                                            if (act.isDestroyed()) {
                                                return;
                                            }
                                        }

                                        if (glideListener != null) {
                                            glideListener.onImageLoad(context, bitmap2Bytes(bitmap),
                                                    getRadius(imageTarget.cornerradius),
                                                    dpToPx(imageTarget.width <= 0 ?
                                                            Integer.MIN_VALUE : imageTarget.width),
                                                    dpToPx(imageTarget.height <= 0 ?
                                                            Integer.MIN_VALUE
                                                            : imageTarget.height),
                                                    notificationTarget);
                                        }
                                    } catch (Throwable t) {
                                        PushLog.inst().log(TAG + ".erro= " + t.toString());
                                    }
                                }
                            });
                            break;
                    }
                }
            } else {
                NotificationManagerCompat.from(context).notify(notificationId, notification);
            }
            imageTargetList.clear();

        } catch (Throwable t) {
            PushLog.inst().log(TAG + ".erro= " + t.toString());
        }
    }

    private byte[] bitmap2Bytes(Bitmap bm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 100, baos);
        return baos.toByteArray();
    }

    private void parseChildViews(int parentWidth,
                                 int parentHeight,
                                 ViewEntity parentViews,
                                 int parentid,
                                 JSONArray jsonArray) {
        try {
            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String viewType =
                        jsonObject.has("viewtype") ? jsonObject.getString("viewtype") : "";
                int width = jsonObject.optInt("width");
                int height = jsonObject.optInt("height");
                if (width <= 0) {
                    width = parentWidth;
                }

                if (height <= 0) {
                    height = parentHeight;
                }
                if (jsonObject.has("scaletype")) {
                    String scaletype = jsonObject.getString("scaletype");
                    if (scaletype.equals("fill")) {
                        width = parentWidth;
                        height = parentHeight;
                    }
                }
                PushLog.inst().log("parseChildViews,viewType=" + viewType + ",width=" + width +
                        ", height = " +
                        height);
                switch (viewType) {
                    case "layout":
                        parseLayoutViews(width,
                                height,
                                parentViews,
                                parentid,
                                jsonObject);
                        break;
                    case "image":
                        parseImageViews(width,
                                height,
                                parentViews,
                                parentid,
                                jsonObject);
                        break;
                    case "text":
                        parseTextViews(width,
                                height,
                                parentViews,
                                parentid,
                                jsonObject);
                        break;
                    default:
                        PushLog.inst().log("parseChildViews default:");
                }
            }

        } catch (Throwable e) {
            PushLog.inst().log("parseChildViews failed:" + Log.getStackTraceString(e));
        }
    }

    private void parseLayoutViews(int parentWidth, int parentHeight,
                                  ViewEntity parentViews,
                                  int parentid,
                                  JSONObject jsonObject) {
        try {
            String type = jsonObject.optString("type");
            switch (type) {
                case "linear":
                    parseLinearLayoutViews(parentWidth, parentHeight, parentViews,
                            parentid, jsonObject);
                    break;
                case "relative":
                    parseRelativeLayoutViews(parentWidth, parentHeight, parentViews,
                            parentid, jsonObject);
                    break;
                default:
                    PushLog.inst().log("parseLayoutViews default:");
            }
        } catch (Throwable e) {
            PushLog.inst().log("parseLayoutViews failed:" + Log.getStackTraceString(e));
        }
    }

    private void parseRelativeLayoutViews(int parentWidth,
                                          int parentHeight,
                                          ViewEntity parentViews,
                                          int parentid,
                                          JSONObject jsonObject) {
        try {
            PushLog.inst().log("parseRelativeLayoutViews start:" + notificationId);
            RemoteViews remoteViews = null;
            View view = null;
            ViewEntity viewEntity = null;
            String align = jsonObject.optString("align", NULL_TXT);
            int width = jsonObject.optInt("width", 0);
            int height = jsonObject.optInt("height", 0);
            if (width > 260) {
                width = 260;
            }

            if (height > 260) {
                height = 260;
            }
            JSONObject padding = jsonObject.optJSONObject("padding");
            JSONObject intentmap = jsonObject.optJSONObject("intent");

            int layout = R.layout.notification_framelayout;
            int id = R.id.notification_main;
            switch (align) {
                case "right":
                    Map<Integer, Integer[]> r = new HashMap<Integer, Integer[]>() {
                        {
                            put(3, new Integer[]{R.layout.notification_relativelayout_right_width_3,
                                    R.id.notification_layout_right_width_3});
                            put(5, new Integer[]{R.layout.notification_relativelayout_right_width_5,
                                    R.id.notification_layout_right_width_5});
                            put(10, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_10,
                                    R.id.notification_layout_right_width_10});
                            put(20, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_20,
                                    R.id.notification_layout_right_width_20});
                            put(30, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_30,
                                    R.id.notification_layout_right_width_30});
                            put(40, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_40,
                                    R.id.notification_layout_right_width_40});
                            put(50, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_50,
                                    R.id.notification_layout_right_width_50});
                            put(60, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_60,
                                    R.id.notification_layout_right_width_60});
                            put(64, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_64,
                                    R.id.notification_layout_right_width_60});
                            put(70, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_70,
                                    R.id.notification_layout_right_width_70});
                            put(80, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_80,
                                    R.id.notification_layout_right_width_80});
                            put(90, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_90,
                                    R.id.notification_layout_right_width_90});
                            put(100, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_100,
                                    R.id.notification_layout_right_width_100});
                            put(110, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_110,
                                    R.id.notification_layout_right_width_100});
                            put(120, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_120,
                                    R.id.notification_layout_right_width_100});
                            put(130, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_130,
                                    R.id.notification_layout_right_width_100});
                            put(140, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_140,
                                    R.id.notification_layout_right_width_100});
                            put(150, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_150,
                                    R.id.notification_layout_right_width_100});
                            put(160, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_160,
                                    R.id.notification_layout_right_width_100});
                            put(170, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_170,
                                    R.id.notification_layout_right_width_100});
                            put(180, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_180,
                                    R.id.notification_layout_right_width_100});
                            put(190, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_190,
                                    R.id.notification_layout_right_width_100});
                            put(200, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_200,
                                    R.id.notification_layout_right_width_100});
                            put(210, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_210,
                                    R.id.notification_layout_right_width_100});
                            put(220, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_220,
                                    R.id.notification_layout_right_width_100});
                            put(230, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_230,
                                    R.id.notification_layout_right_width_100});
                            put(240, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_240,
                                    R.id.notification_layout_right_width_100});
                            put(250, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_250,
                                    R.id.notification_layout_right_width_100});
                            put(260, new Integer[]{
                                    R.layout.notification_relativelayout_right_width_260,
                                    R.id.notification_layout_right_width_100});

                        }
                    };
                    Integer[] vr = r.get(width);
                    if (vr != null) {
                        layout = vr[0];
                        id = vr[1];
                    }
                    break;
                case "bottom":
                    Map<Integer, Integer[]> b = new HashMap<Integer, Integer[]>() {
                        {
                            put(3, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_3,
                                    R.id.notification_layout_bottom_height_3});
                            put(5, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_5,
                                    R.id.notification_layout_bottom_height_5});
                            put(10, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_10,
                                    R.id.notification_layout_bottom_height_10});
                            put(20, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_20,
                                    R.id.notification_layout_bottom_height_20});
                            put(30, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_30,
                                    R.id.notification_layout_bottom_height_30});
                            put(40, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_40,
                                    R.id.notification_layout_bottom_height_40});
                            put(50, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_50,
                                    R.id.notification_layout_bottom_height_50});
                            put(60, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_60,
                                    R.id.notification_layout_bottom_height_60});
                            put(64, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_64,
                                    R.id.notification_layout_bottom_height_60});
                            put(70, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_70,
                                    R.id.notification_layout_bottom_height_70});
                            put(80, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_80,
                                    R.id.notification_layout_bottom_height_80});
                            put(90, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_90,
                                    R.id.notification_layout_bottom_height_90});
                            put(100, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_100,
                                    R.id.notification_layout_bottom_height_100});
                            put(110, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_110,
                                    R.id.notification_layout_bottom_height_100});
                            put(120, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_120,
                                    R.id.notification_layout_bottom_height_100});
                            put(130, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_130,
                                    R.id.notification_layout_bottom_height_100});
                            put(140, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_140,
                                    R.id.notification_layout_bottom_height_100});
                            put(150, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_150,
                                    R.id.notification_layout_bottom_height_100});
                            put(160, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_160,
                                    R.id.notification_layout_bottom_height_100});
                            put(170, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_170,
                                    R.id.notification_layout_bottom_height_100});
                            put(180, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_180,
                                    R.id.notification_layout_bottom_height_100});
                            put(190, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_190,
                                    R.id.notification_layout_bottom_height_100});
                            put(200, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_200,
                                    R.id.notification_layout_bottom_height_100});
                            put(210, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_210,
                                    R.id.notification_layout_bottom_height_100});
                            put(220, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_220,
                                    R.id.notification_layout_bottom_height_100});
                            put(230, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_230,
                                    R.id.notification_layout_bottom_height_100});
                            put(240, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_240,
                                    R.id.notification_layout_bottom_height_100});
                            put(250, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_250,
                                    R.id.notification_layout_bottom_height_100});
                            put(260, new Integer[]{
                                    R.layout.notification_relativelayout_bottom_height_260,
                                    R.id.notification_layout_bottom_height_100});

                        }
                    };
                    Integer[] vb = b.get(height);
                    if (vb != null) {
                        layout = vb[0];
                        id = vb[1];
                    }
                    break;
                case "left":
                    Map<Integer, Integer[]> l = new HashMap<Integer, Integer[]>() {
                        {
                            put(3, new Integer[]{R.layout.notification_relativelayout_width_3,
                                    R.id.notification_layout_width_3});
                            put(5, new Integer[]{R.layout.notification_relativelayout_width_5,
                                    R.id.notification_layout_width_5});
                            put(10, new Integer[]{R.layout.notification_relativelayout_width_10,
                                    R.id.notification_layout_width_10});
                            put(20, new Integer[]{R.layout.notification_relativelayout_width_20,
                                    R.id.notification_layout_width_20});
                            put(30, new Integer[]{R.layout.notification_relativelayout_width_30,
                                    R.id.notification_layout_width_30});
                            put(40, new Integer[]{R.layout.notification_relativelayout_width_40,
                                    R.id.notification_layout_width_40});
                            put(50, new Integer[]{R.layout.notification_relativelayout_width_50,
                                    R.id.notification_layout_width_50});
                            put(60, new Integer[]{R.layout.notification_relativelayout_width_60,
                                    R.id.notification_layout_width_60});
                            put(64, new Integer[]{R.layout.notification_relativelayout_width_64,
                                    R.id.notification_layout_width_60});
                            put(70, new Integer[]{R.layout.notification_relativelayout_width_70,
                                    R.id.notification_layout_width_70});
                            put(80, new Integer[]{R.layout.notification_relativelayout_width_80,
                                    R.id.notification_layout_width_80});
                            put(90, new Integer[]{R.layout.notification_relativelayout_width_90,
                                    R.id.notification_layout_width_90});
                            put(100, new Integer[]{R.layout.notification_relativelayout_width_100,
                                    R.id.notification_layout_width_100});
                            put(110, new Integer[]{R.layout.notification_relativelayout_width_110,
                                    R.id.notification_layout_width_100});
                            put(120, new Integer[]{R.layout.notification_relativelayout_width_120,
                                    R.id.notification_layout_width_100});
                            put(130, new Integer[]{R.layout.notification_relativelayout_width_130,
                                    R.id.notification_layout_width_100});
                            put(140, new Integer[]{R.layout.notification_relativelayout_width_140,
                                    R.id.notification_layout_width_100});
                            put(150, new Integer[]{R.layout.notification_relativelayout_width_150,
                                    R.id.notification_layout_width_100});
                            put(160, new Integer[]{R.layout.notification_relativelayout_width_160,
                                    R.id.notification_layout_width_100});
                            put(170, new Integer[]{R.layout.notification_relativelayout_width_170,
                                    R.id.notification_layout_width_100});
                            put(180, new Integer[]{R.layout.notification_relativelayout_width_180,
                                    R.id.notification_layout_width_100});
                            put(190, new Integer[]{R.layout.notification_relativelayout_width_190,
                                    R.id.notification_layout_width_100});
                            put(200, new Integer[]{R.layout.notification_relativelayout_width_200,
                                    R.id.notification_layout_width_100});
                            put(210, new Integer[]{R.layout.notification_relativelayout_width_210,
                                    R.id.notification_layout_width_100});
                            put(220, new Integer[]{R.layout.notification_relativelayout_width_220,
                                    R.id.notification_layout_width_100});
                            put(230, new Integer[]{R.layout.notification_relativelayout_width_230,
                                    R.id.notification_layout_width_100});
                            put(240, new Integer[]{R.layout.notification_relativelayout_width_240,
                                    R.id.notification_layout_width_100});
                            put(250, new Integer[]{R.layout.notification_relativelayout_width_250,
                                    R.id.notification_layout_width_100});
                            put(260, new Integer[]{R.layout.notification_relativelayout_width_260,
                                    R.id.notification_layout_width_100});

                        }
                    };

                    Integer[] vl = l.get(width);
                    if (vl != null) {
                        layout = vl[0];
                        id = vl[1];
                    }
                    break;
                case "top":
                    Map<Integer, Integer[]> t = new HashMap<Integer, Integer[]>() {
                        {
                            put(3, new Integer[]{R.layout.notification_relativelayout_height_3,
                                    R.id.notification_layout_height_3});
                            put(5, new Integer[]{R.layout.notification_relativelayout_height_5,
                                    R.id.notification_layout_height_5});
                            put(10, new Integer[]{R.layout.notification_relativelayout_height_10,
                                    R.id.notification_layout_height_10});
                            put(20, new Integer[]{R.layout.notification_relativelayout_height_20,
                                    R.id.notification_layout_height_20});
                            put(30, new Integer[]{R.layout.notification_relativelayout_height_30,
                                    R.id.notification_layout_height_30});
                            put(40, new Integer[]{R.layout.notification_relativelayout_height_40,
                                    R.id.notification_layout_height_40});
                            put(50, new Integer[]{R.layout.notification_relativelayout_height_50,
                                    R.id.notification_layout_height_50});
                            put(60, new Integer[]{R.layout.notification_relativelayout_height_60,
                                    R.id.notification_layout_height_60});
                            put(64, new Integer[]{R.layout.notification_relativelayout_height_64,
                                    R.id.notification_layout_height_60});
                            put(70, new Integer[]{R.layout.notification_relativelayout_height_70,
                                    R.id.notification_layout_height_70});
                            put(80, new Integer[]{R.layout.notification_relativelayout_height_80,
                                    R.id.notification_layout_height_80});
                            put(90, new Integer[]{R.layout.notification_relativelayout_height_90,
                                    R.id.notification_layout_height_90});
                            put(100, new Integer[]{R.layout.notification_relativelayout_height_100,
                                    R.id.notification_layout_height_100});
                            put(110, new Integer[]{R.layout.notification_relativelayout_height_110,
                                    R.id.notification_layout_height_100});
                            put(120, new Integer[]{R.layout.notification_relativelayout_height_120,
                                    R.id.notification_layout_height_100});
                            put(130, new Integer[]{R.layout.notification_relativelayout_height_130,
                                    R.id.notification_layout_height_100});
                            put(140, new Integer[]{R.layout.notification_relativelayout_height_140,
                                    R.id.notification_layout_height_100});
                            put(150, new Integer[]{R.layout.notification_relativelayout_height_150,
                                    R.id.notification_layout_height_100});
                            put(160, new Integer[]{R.layout.notification_relativelayout_height_160,
                                    R.id.notification_layout_height_100});
                            put(170, new Integer[]{R.layout.notification_relativelayout_height_170,
                                    R.id.notification_layout_height_100});
                            put(180, new Integer[]{R.layout.notification_relativelayout_height_180,
                                    R.id.notification_layout_height_100});
                            put(190, new Integer[]{R.layout.notification_relativelayout_height_190,
                                    R.id.notification_layout_height_100});
                            put(200, new Integer[]{R.layout.notification_relativelayout_height_200,
                                    R.id.notification_layout_height_100});
                            put(210, new Integer[]{R.layout.notification_relativelayout_height_210,
                                    R.id.notification_layout_height_100});
                            put(220, new Integer[]{R.layout.notification_relativelayout_height_220,
                                    R.id.notification_layout_height_100});
                            put(230, new Integer[]{R.layout.notification_relativelayout_height_230,
                                    R.id.notification_layout_height_100});
                            put(240, new Integer[]{R.layout.notification_relativelayout_height_240,
                                    R.id.notification_layout_height_100});
                            put(250, new Integer[]{R.layout.notification_relativelayout_height_250,
                                    R.id.notification_layout_height_100});
                            put(260, new Integer[]{R.layout.notification_relativelayout_height_260,
                                    R.id.notification_layout_height_100});
                        }
                    };
                    Integer[] vt = t.get(height);
                    if (vt != null) {
                        layout = vt[0];
                        id = vt[1];
                    }
                    break;
                default:
                    if (width == 0 && height == 0) {
                        id = R.id.notification_main;
                        layout = R.layout.notification_framelayout;
                    }
            }
            if (isRemoteViews) {
                remoteViews = new RemoteViews(context.getPackageName(), layout);
            } else {
                view = inflater.inflate(layout,
                        (ViewGroup) parentViews.mView, false);
            }
            viewEntity = new ViewEntity(remoteViews, view, isRemoteViews);
            JSONArray jsonArray = jsonObject.optJSONArray("childs");
            if (jsonArray != null) {
                JSONArray array = jsonArray.getJSONArray(0);
                if (array.length() > 0) {
                    Rect rect = getPadding(padding);
                    parseChildViews(parentWidth - rect.left - rect.right,
                            parentHeight - rect.top - rect.bottom,
                            viewEntity,
                            id,
                            array);
                }
            }
            parsePadding(viewEntity, id, padding);
            parseClick(viewEntity, intentmap, id);
            parentViews.addView(parentid, viewEntity);
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ",parseRelativeLayoutViews,erro= " + e);
            e.printStackTrace();
        }
    }

    private Rect getPadding(JSONObject padding) {

        if (padding != null) {
            try {
                int left = padding.has("left") ? padding.getInt("left") : 0;
                int right = padding.has("right") ? padding.getInt("right") : 0;
                int top = padding.has("top") ? padding.getInt("top") : 0;
                int bottom = padding.has("bottom") ? padding.getInt("bottom") : 0;
                Rect rect = new Rect(left, top, right, bottom);
                return rect;
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return new Rect();
    }

    private void parseLinearLayoutViews(int parentWidth,
                                        int parentHeight,
                                        ViewEntity parentViews,
                                        int parentid,
                                        JSONObject jsonObject) {
        try {
            RemoteViews remoteViews = null;
            View view = null;
            ViewEntity viewEntity = null;
            String direction = jsonObject.optString("direction");
            int size = jsonObject.optInt("size");
            JSONObject padding = jsonObject.optJSONObject("padding");
            JSONObject intentmap = jsonObject.optJSONObject("intent");
            Rect rect = getPadding(padding);
            parentWidth = parentWidth - rect.left - rect.right;
            parentHeight = parentHeight - rect.top - rect.bottom;
            int layout = 0;
            int id = 0;

            int[] idArray = new int[3];
            JSONArray jsonArray;

            switch (direction) {
                case "horizontal":
                    if (size == 2) {
                        layout = R.layout.notification_linearlayout_horizontal2;
                        id = R.id.notification_horizontal2;
                        if (isRemoteViews) {
                            remoteViews = new RemoteViews(context.getPackageName(), layout);
                        } else {
                            view = inflater.inflate(layout,
                                    (ViewGroup) parentViews.mView, false);
                        }

                        viewEntity = new ViewEntity(remoteViews, view, isRemoteViews);

                        idArray[0] = R.id.notification_horizontal2_0;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 0) {
                            JSONArray array = jsonArray.getJSONArray(0);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth / 2, parentHeight, viewEntity,
                                        idArray[0], array);
                            }
                        }
                        idArray[1] = R.id.notification_horizontal2_1;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 1) {
                            JSONArray array = jsonArray.getJSONArray(1);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth / 2, parentHeight, viewEntity,
                                        idArray[1], array);
                            }
                        }
                    } else if (size == 3) {
                        layout = R.layout.notification_linearlayout_horizontal3;
                        id = R.id.notification_horizontal3;
                        if (isRemoteViews) {
                            remoteViews = new RemoteViews(context.getPackageName(), layout);
                        } else {
                            view = inflater.inflate(layout,
                                    (ViewGroup) parentViews.mView, false);
                        }
                        viewEntity = new ViewEntity(remoteViews, view, isRemoteViews);

                        idArray[0] = R.id.notification_horizontal3_0;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 0) {
                            JSONArray array = jsonArray.getJSONArray(0);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth / 3, parentHeight, viewEntity,
                                        idArray[0], array);
                            }
                        }
                        idArray[1] = R.id.notification_horizontal3_1;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 1) {
                            JSONArray array = jsonArray.getJSONArray(1);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth / 3, parentHeight, viewEntity,
                                        idArray[1], array);
                            }
                        }
                        idArray[2] = R.id.notification_horizontal3_2;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 2) {
                            JSONArray array = jsonArray.getJSONArray(2);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth / 3, parentHeight, viewEntity,
                                        idArray[2], array);
                            }
                        }
                    } else {
                        if (isRemoteViews) {
                            remoteViews = new RemoteViews(context.getPackageName(),
                                    R.layout.notification_framelayout);
                        } else {
                            view = inflater.inflate(R.layout.notification_framelayout,
                                    (ViewGroup) parentViews.mView, false);
                        }
                        viewEntity = new ViewEntity(remoteViews, view, isRemoteViews);
                    }

                    break;
                case "vertical":
                    if (size == 2) {
                        if (isLarge) {
                            layout = R.layout.notification_linearlayout_large_vertical2;
                        } else {
                            layout = R.layout.notification_linearlayout_vertical2;
                        }
                        id = R.id.notification_vertical2;
                        if (isRemoteViews) {
                            remoteViews = new RemoteViews(context.getPackageName(), layout);
                        } else {
                            view = inflater.inflate(layout,
                                    (ViewGroup) parentViews.mView, false);
                        }
                        viewEntity = new ViewEntity(remoteViews, view, isRemoteViews);
                        idArray[0] = R.id.notification_vertical2_0;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 0) {
                            JSONArray array = jsonArray.getJSONArray(0);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth, parentHeight / 2, viewEntity,
                                        idArray[0], array);
                            }
                        }
                        idArray[1] = R.id.notification_vertical2_1;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 1) {
                            JSONArray array = jsonArray.getJSONArray(1);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth, parentHeight / 2, viewEntity,
                                        idArray[1], array);
                            }
                        }
                    } else if (size == 3) {
                        layout = R.layout.notification_linearlayout_vertical3;
                        id = R.id.notification_vertical3;
                        if (isRemoteViews) {
                            remoteViews = new RemoteViews(context.getPackageName(), layout);
                        } else {
                            view = inflater.inflate(layout,
                                    (ViewGroup) parentViews.mView, false);
                        }
                        viewEntity = new ViewEntity(remoteViews, view, isRemoteViews);
                        idArray[0] = R.id.notification_vertical3_0;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 0) {
                            JSONArray array = jsonArray.getJSONArray(0);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth, parentHeight / 3, viewEntity,
                                        idArray[0], array);
                            }
                        }
                        idArray[1] = R.id.notification_vertical3_1;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 1) {
                            JSONArray array = jsonArray.getJSONArray(1);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth, parentHeight / 3, viewEntity,
                                        idArray[1], array);
                            }
                        }
                        idArray[2] = R.id.notification_vertical3_2;
                        jsonArray = jsonObject.has("childs") ? jsonObject.getJSONArray("childs") :
                                new JSONArray();
                        if (jsonArray.length() > 2) {
                            JSONArray array = jsonArray.getJSONArray(2);
                            if (array.length() > 0) {
                                parseChildViews(parentWidth, parentHeight / 3, viewEntity,
                                        idArray[2], array);
                            }
                        }
                    } else {
                        if (isRemoteViews) {
                            remoteViews = new RemoteViews(context.getPackageName(),
                                    R.layout.notification_framelayout);
                        } else {
                            view = inflater.inflate(R.layout.notification_framelayout,
                                    (ViewGroup) parentViews.mView, false);
                        }
                        viewEntity = new ViewEntity(remoteViews, view, isRemoteViews);
                    }

                    break;
                default:
                    id = R.id.notification_main;
                    if (isRemoteViews) {
                        remoteViews = new RemoteViews(context.getPackageName(),
                                R.layout.notification_framelayout);
                    } else {
                        view = inflater.inflate(R.layout.notification_framelayout,
                                (ViewGroup) parentViews.mView, false);
                    }
                    viewEntity = new ViewEntity(remoteViews, view, isRemoteViews);
            }
            if (viewEntity == null) {
                viewEntity = new ViewEntity(remoteViews, view, isRemoteViews);
            }
            parsePadding(viewEntity, id, padding);
            parseClick(viewEntity, intentmap, id);
            parentViews.addView(parentid, viewEntity);
        } catch (Throwable e) {
            PushLog.inst().log("parseLinearLayoutViews failed:" + Log.getStackTraceString(e));
        }
    }

    private void parseImageViews(int parentWidth,
                                 int parentHeight,
                                 ViewEntity parentViews,
                                 int parentid,
                                 JSONObject jsonObject) {
        try {
            RemoteViews remoteViews = null;
            View view = null;
            ViewEntity viewEntity = null;
            JSONObject padding = jsonObject.optJSONObject("padding");
            JSONObject intentmap = jsonObject.optJSONObject("intent");
            YYPushImageTarget imageTarget = new YYPushImageTarget();
            imageTarget.type = jsonObject.optString("type");
            String imagekey = jsonObject.optString("imagekey");
            String colorkey;
            if (isDark) {
                colorkey = jsonObject.optString("darkcolorkey");
            } else {
                colorkey = jsonObject.optString("defaultcolorkey");
            }
            JSONObject imageMap = yycustompushdata.optJSONObject("imagemap");
            JSONObject colormap = yycustompushdata.optJSONObject("colormap");
            if (imageMap != null && !imagekey.equals("")) {
                imageTarget.imageUrl = imageMap.optString(imagekey);
            }
            if (colormap != null && !colorkey.equals("")) {
                String colorstr = colormap.optString(colorkey, "0xFF000000");
                imageTarget.colorvalue = Color.parseColor(colorstr);
            }
            imageTarget.width = jsonObject.optInt("width");
            imageTarget.height = jsonObject.optInt("height");
            imageTarget.cornerradius = jsonObject.optInt("cornerradius");

            String scaletype = jsonObject.optString("scaletype");
            switch (scaletype) {
                case "centerinside":
                    if (parentViews.isRemoteViews) {
                        remoteViews = new RemoteViews(context.getPackageName(),
                                R.layout.notification_imageview_center);
                    } else {
                        view = inflater.inflate(R.layout.notification_imageview_center,
                                (ViewGroup) parentViews.mView, false);
                    }
                    imageTarget.id = R.id.notification_image_center;
                    break;
                default:
                case "fill":
                    if (parentViews.isRemoteViews) {
                        remoteViews = new RemoteViews(context.getPackageName(),
                                R.layout.notification_imageview_fill);
                    } else {
                        view = inflater.inflate(R.layout.notification_imageview_fill,
                                (ViewGroup) parentViews.mView, false);
                    }
                    imageTarget.id = R.id.notification_image_fill;
                    //默认是50的
                    if (imageTarget.width <= 0 || imageTarget.width == 50) {
                        imageTarget.width = parentWidth;
                    }
                    if (imageTarget.height <= 0 || imageTarget.height == 50) {
                        imageTarget.height = parentHeight;
                    }
                    break;
            }

            viewEntity = new ViewEntity(remoteViews, view, parentViews.isRemoteViews);
            imageTarget.mViewEntity = viewEntity;
            Rect rect = parsePadding(viewEntity, imageTarget.id, padding);
            if (rect != null) {
                imageTarget.width = imageTarget.width - (rect.left + rect.right);
                imageTarget.height = imageTarget.height - (rect.top + rect.bottom);
            }
            parseClick(viewEntity, intentmap, imageTarget.id);
            int imgId =
                    TemplateManager.getInstance().getConfig().getLargeIconResourceId();
            if (imgFailCallback != null) {
                imgId = imgFailCallback.getFailImgId(imageTarget.width, imageTarget.height);
            }
            if (parentViews.isRemoteViews) {
                // Bitmap b = reSizeDefaultImg(context, imgId, imageTarget.width, imageTarget.height);
                Bitmap b = null;
                if (b != null) {
                    remoteViews.setImageViewBitmap(imageTarget.id, b);
                } else {
                    remoteViews.setImageViewResource(imageTarget.id, imgId);
                }
            } else {
                ((ImageView) view).setImageResource(imgId);
            }
            parentViews.addView(parentid, viewEntity);
            imageTargetList.add(imageTarget);
        } catch (Throwable e) {
            PushLog.inst().log("parseImageViews failed:" + Log.getStackTraceString(e));
        }
    }

    private Bitmap reSizeDefaultImg(Context ctx, int resid, int targetW, int targetH) {
        try {
            Bitmap origin = getBitmap(ctx, resid);
            if (origin.getWidth() > targetW || origin.getHeight() > targetH) {
                Matrix matrix = new Matrix();
                matrix.preScale(targetW, targetH);
                Bitmap newBM = Bitmap.createBitmap(origin, 0, 0, targetW, targetH, matrix, false);
                if (!origin.isRecycled()) {
                    origin.recycle();
                }
                return newBM;
            } else {
                return origin;
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + "- reSizeDefaultImg: " + Log.getStackTraceString(e));
            return null;
        }
    }

    private static Bitmap getBitmap(Context context, int vectorDrawableId) {
        Bitmap bitmap = null;
        try {
            if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP) {
                Drawable vectorDrawable = context.getDrawable(vectorDrawableId);
                bitmap = Bitmap.createBitmap(vectorDrawable.getIntrinsicWidth(),
                        vectorDrawable.getIntrinsicHeight(),
                        Bitmap.Config.ARGB_4444);
                Canvas canvas = new Canvas(bitmap);
                vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                vectorDrawable.draw(canvas);
            } else {
                bitmap = BitmapFactory.decodeResource(context.getResources(), vectorDrawableId);
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + "- getBitmap: " + Log.getStackTraceString(t));
        }
        return bitmap;
    }

    private void parseTextViews(int parentWidth,
                                int parentHeight,
                                ViewEntity parentViews,
                                int parentid,
                                JSONObject jsonObject) {
        try {
            RemoteViews remoteViews = null;
            View view = null;
            int id = 0;
            int layoutId = R.layout.notification_textview_start;
            JSONObject padding = jsonObject.optJSONObject("padding");
            JSONObject intentmap = jsonObject.optJSONObject("intent");
            int singgleLine = jsonObject.optInt("singleline", 1);
            //0多行，1单行
            String colorkey;
            if (isDark) {
                colorkey = jsonObject.optString("darkcolorkey");
            } else {
                colorkey = jsonObject.optString("defaultcolorkey");
            }
            int colorvalue = 0;
            String textkey = jsonObject.optString("textkey");
            String textvalue = "";

            JSONObject textmap = yycustompushdata.optJSONObject("textmap");
            JSONObject colormap = yycustompushdata.optJSONObject("colormap");
            if (textmap != null && !textkey.equals("")) {
                textvalue = textmap.optString(textkey);
            }
            if (colormap != null && !colorkey.equals("")) {
                String colorstr = colormap.optString(colorkey, "#FF000000");
                colorvalue = Color.parseColor(colorstr);
            }
            String textstyle = jsonObject.optString("textstyle");
            int fontsize = jsonObject.optInt("fontsize", 10);
            String align = jsonObject.optString("align");
            switch (align) {
                case "end":
                    if (singgleLine == 0) {
                        layoutId = R.layout.notification_textview_end;
                    } else {
                        layoutId = R.layout.notification_textview_end_singgleline;
                    }
                    id = R.id.notification_text_end;
                    break;
                case "center":
                    if (singgleLine == 0) {
                        layoutId = R.layout.notification_textview_center;
                    } else {
                        layoutId = R.layout.notification_textview_center_singleline;
                    }
                    id = R.id.notification_text_center;
                    break;
                case "marquee":
                    layoutId = R.layout.notification_textview_marquee;
                    id = R.id.notification_marquee_text;
                    break;
                default:
                case "start":
                    if (singgleLine == 0) {
                        layoutId = R.layout.notification_textview_start;
                    } else {
                        layoutId = R.layout.notification_textview_start_singgleline;
                    }
                    id = R.id.notification_text_start;
                    break;
                case "leftTop":
                    if (singgleLine == 0) {
                        layoutId = R.layout.notification_textview_left_top;
                    } else {
                        layoutId = R.layout.notification_textview_left_top_singgleline;
                    }
                    id = R.id.notification_text_left_top;
                    break;
                case "rightTop":
                    if (singgleLine == 0) {
                        layoutId = R.layout.notification_textview_right_top;
                    } else {
                        layoutId = R.layout.notification_textview_right_top_singgleline;
                    }
                    id = R.id.notification_text_right_top;
                    break;
            }
            SpannableString s = new SpannableString(textvalue);
            switch (textstyle) {
                case "bold":
                    s.setSpan(new StyleSpan(Typeface.BOLD), 0, s.length(), 0);
                    break;
                case "italic":
                    s.setSpan(new StyleSpan(Typeface.ITALIC), 0, s.length(), 0);
                    break;
                case "bold_italic":
                    s.setSpan(new StyleSpan(Typeface.BOLD_ITALIC), 0, s.length(), 0);
                    break;
                default:
                case "normal":
                    s.setSpan(new StyleSpan(Typeface.NORMAL), 0, s.length(), 0);
                    break;
            }

            if (parentViews.isRemoteViews) {
                remoteViews = new RemoteViews(context.getPackageName(), layoutId);
                remoteViews.setTextColor(id, colorvalue);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                    remoteViews.setTextViewTextSize(id, COMPLEX_UNIT_DIP, fontsize);
                }
                remoteViews.setTextViewText(id, s);
            } else {
                view = inflater.inflate(layoutId,
                        (ViewGroup) parentViews.mView, false);
                TextView tv = view.findViewById(id);
                tv.setTextColor(colorvalue);
                tv.setTextSize(fontsize);
                tv.setText(s);
            }
            ViewEntity viewEntity = new ViewEntity(remoteViews, view, parentViews.isRemoteViews);
            parsePadding(viewEntity, id, padding);
            parseClick(viewEntity, intentmap, id);
            parentViews.addView(parentid, viewEntity);
        } catch (Throwable e) {
            PushLog.inst().log("parseTextViews failed:" + Log.getStackTraceString(e));
        }
    }

    private Rect parsePadding(ViewEntity viewEntity, int viewId, JSONObject padding) {
        Rect rect = new Rect();
        if (padding != null) {
            try {
                int left = padding.has("left") ? padding.getInt("left") : 0;
                int right = padding.has("right") ? padding.getInt("right") : 0;
                int top = padding.has("top") ? padding.getInt("top") : 0;
                int bottom = padding.has("bottom") ? padding.getInt("bottom") : 0;
                rect = new Rect(left, top, right, bottom);
                if (viewEntity.isRemoteViews) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                        viewEntity.mRemoteView.setViewPadding(viewId,
                                dpToPx(left),
                                dpToPx(top),
                                dpToPx(right),
                                dpToPx(bottom));
                    }
                } else {
                    viewEntity.mView.setPadding(dpToPx(left),
                            dpToPx(top),
                            dpToPx(right),
                            dpToPx(bottom));
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return rect;
    }

    private void parseClick(ViewEntity viewEntity,
                            JSONObject intentmap, int viewId) {
        try {
            if (intentmap != null) {
                String skiplinkkey = intentmap.optString("skiplinkkey", NULL_TXT);
                JSONObject skiplinkmap = yycustompushdata.optJSONObject("skiplinkmap");
                String skiplinkvalue = "";
                if (skiplinkmap != null && !skiplinkkey.equals("")) {
                    skiplinkvalue = skiplinkmap.optString(skiplinkkey);
                }
                Intent notifyIntent = ClickIntentUtil.getLuluboxIntent(
                        context,
                        payload.toString(),
                        skiplinkvalue,
                        mpushId,
                        notificationId,
                        msgId,
                        channelType);

                PendingIntent pendingIntent = null;
                if (viewEntity.isRemoteViews) {
                    pendingIntent =
                            PendingIntent.getBroadcast(context, notificationId,
                                    notifyIntent, PendingIntent.FLAG_UPDATE_CURRENT);
                    viewEntity.mRemoteView.setOnClickPendingIntent(viewId, pendingIntent);
                } else {
                    viewEntity.mView.setOnClickListener(new ViewClickListener(notifyIntent));
                }
            }
        } catch (Throwable e) {
            PushLog.inst().log("parseClick failed:" + Log.getStackTraceString(e));
        }
    }

    private int dpToPx(float dipValue) {
        final float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int) (dipValue * scale + 0.5f);
    }

    class ViewClickListener implements View.OnClickListener {
        Intent mNotifyIntent;

        public ViewClickListener(Intent notifyIntent) {
            mNotifyIntent = notifyIntent;
        }

        @Override
        public void onClick(View v) {
            try {
                if (mViewListener != null) {
                    mViewListener.onViewClick(mNotifyIntent);
                }
            } catch (Throwable t) {
                PushLog.inst().log("parseClick failed:" + Log.getStackTraceString(t));
            }
        }
    }
}
