package com.yy.pushsvc.template;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import android.util.Log;

import com.yy.pushsvc.IAcquireAppState;
import com.yy.pushsvc.IMsgArriveCallback;
import com.yy.pushsvc.NotificationCounter;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.grouping.GroupingEntity;
import com.yy.pushsvc.grouping.GroupingManager;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.template.jumps.NotificationCancleReceiver;
import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.undisturb.UndisturbManager;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;

/**
 * Created by GuanYuFeng
 * on 2019/5/17
 */
public class TemplateManager {
    private static final String TAG = "TemplateManager";
    private static final String DEFAULT_TITLE = "Hi ~";
    private static final String DEFAULT_DESC = "You got one message";
    private static final String PUSH_NOTIFICATION_TITLE = "title";
    private static final String PUSH_NOTIFICATION_DESC = "desc";
    public static final String PUSH_NOTIFICATION_TYPE = "yycustompushtype";
    public static final String PUSH_NOTIFICATION_DATA = "yycustompushdata";
    public static final String PUSH_NOTIFICATION_LARGE_TYPE = "yycustompushlargetype";
    public static final String PUSH_NOTIFICATION_LARGE_DATA = "yycustompushlargedata";
    private static final String TEMPLATE_SKIPLINKMAP = "skiplinkmap";
    private static final String TOP_MARK_KEY = "top";
    private static final String PUSH_SHOW_TYPE = "show_type";
    private static final int TOP_MARK_TRUE = 1;
    private static final int TOP_MARK_FALSE = 0;
    private static volatile TemplateManager instance;
    private Context context;
    private TemplateConfig config = new TemplateConfig();
    private Handler mainHandler = new Handler(Looper.getMainLooper());


    public static TemplateManager getInstance() {
        if (instance == null) {
            synchronized (TemplateManager.class) {
                if (instance == null) {
                    instance = new TemplateManager();
                }
            }
        }
        return instance;
    }

    private TemplateManager() {
        YYPushMsgDispacher.getInstance().addFirst(new TemplateIntercept());
    }

    public TemplateConfig getConfig() {
        return config;
    }

    public void setConfig(TemplateConfig config) {
        this.config = config;
    }

    public TemplateManager init(Context context) {
        this.context = context;
        String efoxAppid = config.getEfoxAppid();
        if (TextUtils.isEmpty(efoxAppid)) {
            efoxAppid = AppPushInfo.getPushEfoxAppId(context);
            config.setEfoxAppid(efoxAppid);
        }
        PushNotModleUtil pushUtil = PushNotModleUtil.getInstance(context).initContext(context);
        pushUtil.asyncInitModleJson();
        return this;
    }

    public boolean templateNotificationIntercept(final Context ctx, Intent intent) {
        byte[] payload = intent.getByteArrayExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD);
        long msgId = intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_MSGID, 0);
        int pushType = intent.getIntExtra(YYPushConsts.PUSH_TYPE, YYPushConsts.PUSH_TYPE_FCM);
        String channelType = intent.hasExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE) ?
                intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE) :
                ThirdPartyPushType.PUSH_TYPE_FCM;
        String payloadStr = null;
        try {
            payloadStr = new String(payload, "UTF-8");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return templateNotificationIntercept(ctx, channelType, payloadStr, msgId, pushType);
    }

    public boolean templateNotificationIntercept(final Context ctx,
                                                 String channelType, String payloadStr, long msgId
            , int pushType) {
        boolean enble = config.isEnble();
        if (!enble) {
            return false;
        }
        if (config.getShowTemplateListener() != null) {
            enble = config.getShowTemplateListener().canShowTemplate(payloadStr);
        }
        if (!enble) {
            return false;
        }

        boolean isIntercept = false;
        try {
            final int notificationId = NotificationUtil.createNotificationId(msgId);
            PushLog.inst().log(TAG + ".templateNotificationIntercept, payloadStr=" + payloadStr);
            if (!TextUtils.isEmpty(payloadStr)) {
                final JSONObject payloadObj = new JSONObject(payloadStr);
                if (payloadObj.has(PUSH_NOTIFICATION_TYPE)) {
                    final int modelId = payloadObj.getInt(PUSH_NOTIFICATION_TYPE);
                    boolean hasLargeModle = false;
                    int largeModelId = 0;
                    JSONObject largePushData = null;
                    if (payloadObj.has(PUSH_NOTIFICATION_LARGE_TYPE) &&
                            payloadObj.has(PUSH_NOTIFICATION_LARGE_DATA)) {
                        largeModelId = payloadObj.getInt(PUSH_NOTIFICATION_LARGE_TYPE);
                        largePushData = payloadObj.getJSONObject(PUSH_NOTIFICATION_LARGE_DATA);
                        if (largeModelId > 0 && largePushData != null) {
                            hasLargeModle = true;
                        }
                    }
                    if (hasLargeModle) {
                        if (modelId > 0) {
                            final PushNotModleUtil pm =
                                    PushNotModleUtil.getInstance(ctx).initContext(ctx);
                            String modleJson = pm.getFromData(modelId + "");
                            String largeModleJson = pm.getFromData(largeModelId + "");
                            PushLog.inst()
                                    .log(TAG + ".modleJson:" + modleJson + "/largeModleJson=" +
                                            largeModleJson);
                            if (TextUtils.isEmpty(modleJson) || TextUtils.isEmpty(largeModleJson)) {
                                final int finalLargeModelId = largeModelId;
                                PushThreadPool.getPool().execute(new Runnable() {
                                    @Override
                                    public void run() {
                                        try {
                                            final String result = pm.getSyncModleJson(modelId + "");
                                            final String largeResult =
                                                    pm.getSyncModleJson(finalLargeModelId + "");
                                            PushLog.inst().log(TAG + ".Thread.modleJson:" + result +
                                                    "/largeModleJson=" +
                                                    largeResult);
                                            mainHandler.post(new Runnable() {
                                                @Override
                                                public void run() {
                                                    sendBroadCast(ctx, result, payloadObj,
                                                            largeResult,
                                                            notificationId, true, msgId, pushType,
                                                            channelType);
                                                }
                                            });
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                            PushLog.inst().log(TAG + ".onReceive exception:" + e);
                                            sendDefaultBroadCast(ctx, payloadObj, notificationId,
                                                    msgId, pushType, channelType);
                                        }
                                    }
                                });
                            } else {
                                sendBroadCast(ctx, modleJson, payloadObj, largeModleJson,
                                        notificationId, true, msgId, pushType, channelType);
                            }
                        } else {
                            sendDefaultBroadCast(ctx, payloadObj, notificationId, msgId, pushType,
                                    channelType);
                        }
                    } else {
                        if (modelId > 0) {
                            final PushNotModleUtil pm =
                                    PushNotModleUtil.getInstance(ctx).initContext(ctx);
                            String modleJson = pm.getFromData(modelId + "");
                            PushLog.inst().log(TAG + ".modleJson:" + modleJson);
                            if (TextUtils.isEmpty(modleJson)) {
                                PushThreadPool.getPool().execute(new Runnable() {
                                    @Override
                                    public void run() {
                                        try {
                                            final String result = pm.getSyncModleJson(modelId + "");
                                            PushLog.inst().log(TAG + ".Thread.modleJson:" + result);
                                            mainHandler.post(new Runnable() {
                                                @Override
                                                public void run() {
                                                    sendBroadCast(ctx, result, payloadObj,
                                                            null, notificationId, false, msgId,
                                                            pushType, channelType);
                                                }
                                            });
                                        } catch (PushNotModleUtil.SyncModelException e) {
                                            e.printStackTrace();
                                            PushLog.inst().log(TAG + ".onReceive exception:" + e);
                                            sendDefaultBroadCast(ctx, payloadObj,
                                                    notificationId, msgId, pushType, channelType);
                                        }
                                    }
                                });
                            } else {
                                sendBroadCast(ctx, modleJson, payloadObj, null, notificationId,
                                        false, msgId, pushType, channelType);
                            }
                        } else {
                            sendDefaultBroadCast(ctx, payloadObj, notificationId, msgId, pushType,
                                    channelType);
                        }
                    }
                    isIntercept = true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            PushLog.inst().log(TAG + ".templateNotificationIntercept() exception:" + e);
            isIntercept = false;
            return isIntercept;
        }
        PushLog.inst()
                .log(TAG + ".onReceive intent contains payload templateNotification isIntercept :" +
                        isIntercept);
        return isIntercept;
    }

    private void sendDefaultBroadCast(Context ctx, JSONObject payload, int notificationId,
                                      long msgId, int pushType, String channelType) {
        try {
            if(UndisturbManager.isUndisturb(payload)){
                return ;
            }
            String title = payload.optString(PUSH_NOTIFICATION_TITLE, DEFAULT_TITLE);
            String desc = payload.optString(PUSH_NOTIFICATION_DESC, DEFAULT_DESC);
            payload.put("push_style", "efox");
            boolean isTopMark = getTopMask(payload);
            boolean noGoing = getOnGoing(payload);
            boolean isSuspend = getSuspend(payload);

            int priority = isTopMark ? Notification.PRIORITY_MAX :
                    Notification.PRIORITY_HIGH;
            if (!isSuspend) {
                priority = Notification.PRIORITY_DEFAULT;
            }

            PushLog.inst().log(TAG + ",isTopMark =" + isTopMark + ",noGoing = " + noGoing);

            NotificationCompat.Builder builder = new NotificationCompat.Builder(ctx, null);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                builder.setVisibility(Notification.VISIBILITY_PUBLIC);
            }
            int flags = 0;
            flags |= Notification.DEFAULT_SOUND;
            flags |= Notification.DEFAULT_VIBRATE;
            flags |= Notification.DEFAULT_LIGHTS;
            Intent intent = getClassIntent(payload, notificationId, msgId, channelType);
            if (intent == null) {
                return;
            }
            PendingIntent pendingIntent = PendingIntent.getBroadcast(ctx,
                    notificationId,
                    intent,
                    PendingIntent.FLAG_UPDATE_CURRENT);

            Bitmap bingBitmap = BitmapFactory
                    .decodeResource(ctx.getResources(), config.getLargeIconResourceId());
            builder.setContentIntent(pendingIntent)
                    .setWhen(System.currentTimeMillis())
                    .setPriority(priority)
                    .setOngoing(noGoing)
                    .setContentTitle(title)
                    .setContentText(desc)
                    .setDefaults(flags)
                    .setLargeIcon(bingBitmap)
                    .setSmallIcon(config.getSmallIconResourceId())
                    .setDeleteIntent(getCancleIntent(ctx, msgId));

            NotificationManagerCompat nmc = NotificationManagerCompat.from(ctx);
            String channelId = "channelIdHigh";
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                NotificationManager notificationManager =
                        (NotificationManager) ctx.getSystemService(Context.NOTIFICATION_SERVICE);
                String channelName = "channelNameHigh";
                int channelPriority = NotificationManager.IMPORTANCE_HIGH;
                if (isTopMark) {
                    channelId = "channelIdMax";
                    channelName = "channelNameMax";
                    channelPriority = NotificationManager.IMPORTANCE_MAX;
                }
                if (!isSuspend) {
                    channelId = "channelIdNormal";
                    channelName = "channelNameNormal";
                    channelPriority = NotificationManager.IMPORTANCE_DEFAULT;
                }
                NotificationChannel channel = new NotificationChannel(channelId,
                        channelName, channelPriority);
                notificationManager.createNotificationChannel(channel);
                builder.setChannelId(channelId);
            }

            GroupingEntity groupEntity = GroupingManager.getGroupEntity(payload);
            sendSummary(ctx, groupEntity, channelId);
            setBuilderSummary(groupEntity, builder,notificationId);
            Notification notify = builder.build();
            nmc.notify(notificationId, notify);

            reportTemplate(msgId, payload.toString(), payload.has("pushId") ? payload.getString(
                    "pushId") : "", channelType, ctx);
            if (groupEntity != null && groupEntity.isOperation) {
                NotificationCounter.getInstance().addNotificationCache(context, notificationId,
                        groupEntity.maxCount);
            }

            PushLog.inst().log(TAG + "sendDefaultBroadCast//payload=" + payload.toString());
        } catch (Throwable e) {
            PushLog.inst().log(TAG + "//sendDefaultBroadCast//erro= " + e);
            e.printStackTrace();
        }
    }

    private void setBuilderSummary( GroupingEntity groupEntity,
                                    NotificationCompat.Builder builder,int notId) {
        try {
            if (groupEntity != null) {
                if (!groupEntity.isOperation) {
                    if (!TextUtils.isEmpty(groupEntity.groupName)) {
                        builder.setGroupSummary(false);
                        builder.setGroup(groupEntity.groupName);
                        GroupingManager.savePush(groupEntity.groupName, notId + "");
                    }
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",setBuilderSummary:erro=" + t);
        }
    }

    //发送概要通知
    private void sendSummary(Context ctx, GroupingEntity groupEntity, String channelId) {
        try {
            if (groupEntity != null
                    && !groupEntity.isOperation
                    && !GroupingManager.hasGroupNotfication(groupEntity.groupName)) {
                NotificationCompat.Builder builder2 =
                        new NotificationCompat.Builder(ctx, null);
                builder2.setSmallIcon(config.getSmallIconResourceId())
                        .setCategory(Notification.CATEGORY_EVENT)
                        .setGroupSummary(true)
                        .setGroup(groupEntity.groupName);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    builder2.setChannelId(channelId);
                }
                NotificationManagerCompat.from(ctx)
                        .notify(groupEntity.groupName.hashCode(), builder2.build());
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",sendSummary:erro=" + t);
        }
    }

    private void sendBroadCast(Context ctx, String pushModel, JSONObject payload,
                               String largePushModel, int notificationId, boolean hasLarge,
                               long msgId, int pushType, String channelType) {
        if(UndisturbManager.isUndisturb(payload)){
            return ;
        }
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            sendDefaultBroadCast(ctx, payload, notificationId, msgId, pushType, channelType);
            return;
        }

        if (Build.BRAND.equalsIgnoreCase("oppo")) {
            if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.LOLLIPOP_MR1) {
                sendDefaultBroadCast(ctx, payload, notificationId, msgId, pushType, channelType);
                return;
            }
        }

        YYPushCustomViewUtil yyPushCustomViewUtil = new YYPushCustomViewUtil();
        ViewEntity mainRV = null;
        ViewEntity largeRV = null;
        try {
            if (payload == null) {
                return;
            }
            payload.put("push_style", "efox");
            String title = payload.optString(PUSH_NOTIFICATION_TITLE);
            String desc = payload.optString(PUSH_NOTIFICATION_DESC);
            boolean isTopMark = getTopMask(payload);
            boolean noGoing = getOnGoing(payload);
            boolean isSuspend = getSuspend(payload);

            int priority = isTopMark ? Notification.PRIORITY_MAX :
                    Notification.PRIORITY_HIGH;
            if (!isSuspend) {
                priority = Notification.PRIORITY_DEFAULT;
            }

            PushLog.inst().log(TAG + ",isTopMark =" + isTopMark + ",noGoing = " + noGoing);

            yyPushCustomViewUtil.init(payload.optString("pushId"),
                    msgId,
                    channelType,
                    payload,
                    ctx,
                    false,
                    pushModel,
                    config.getImgFailCallback());
            mainRV = yyPushCustomViewUtil.parsePushCustomContent();
            if (mainRV == null) {
                sendDefaultBroadCast(ctx, payload, notificationId, msgId, pushType, channelType);
                return;
            }
            if (hasLarge) {
                yyPushCustomViewUtil.init(payload.optString("pushId"),
                        msgId,
                        channelType,
                        payload,
                        ctx,
                        true,
                        largePushModel,
                        config.getImgFailCallback());
                largeRV = yyPushCustomViewUtil.parsePushCustomContent();
            }

            int flags = 0;
            flags |= Notification.DEFAULT_SOUND;
            flags |= Notification.DEFAULT_VIBRATE;
            flags |= Notification.DEFAULT_LIGHTS;
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(ctx, null);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                mBuilder.setVisibility(Notification.VISIBILITY_PUBLIC);
            }
            if (largeRV != null) {
                mBuilder.setCustomBigContentView(largeRV.mRemoteView);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP &&
                        config.isLargeImgPriority()) {
                    mBuilder.setCustomHeadsUpContentView(largeRV.mRemoteView);
                }
            }
            mBuilder.setAutoCancel(true);
            Bitmap bingBitmap = BitmapFactory
                    .decodeResource(ctx.getResources(), config.getLargeIconResourceId());
            mBuilder.setCustomContentView(mainRV.mRemoteView)
                    .setWhen(System.currentTimeMillis())// 通知产生的时间，会在通知信息里显示
                    .setPriority(priority)// 设置该通知优先级
                    .setOngoing(noGoing)//不是正在进行的   true为正在进行  效果和.flag一样
                    .setDefaults(flags)
                    .setAutoCancel(true)
                    .setContentTitle(title)
                    .setContentText(desc)
                    .setLargeIcon(bingBitmap)
                    .setSmallIcon(config.getSmallIconResourceId())
                    .setDeleteIntent(getCancleIntent(ctx, msgId));

            // NotificationManager.IMPORTANCE_HIGH
            Uri alarmSound = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
            mBuilder.setSound(alarmSound);

            String channelId = "channelIdHigh";
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                NotificationManager notificationManager =
                        (NotificationManager) ctx.getSystemService(Context.NOTIFICATION_SERVICE);
                String channelName = "channelNameHigh";
                int channelPriority = NotificationManager.IMPORTANCE_HIGH;
                if (isTopMark) {
                    channelId = "channelIdMax";
                    channelName = "channelNameMax";
                    channelPriority = NotificationManager.IMPORTANCE_MAX;
                }
                if (!isSuspend) {
                    channelId = "channelIdNormal";
                    channelName = "channelNameNormal";
                    channelPriority = NotificationManager.IMPORTANCE_DEFAULT;
                }

                NotificationChannel channel = new NotificationChannel(channelId,
                        channelName, channelPriority);
                notificationManager.createNotificationChannel(channel);
                mBuilder.setChannelId(channelId);
            }

            GroupingEntity groupEntity = GroupingManager.getGroupEntity(payload);
            sendSummary(ctx, groupEntity, channelId);
            setBuilderSummary(groupEntity, mBuilder,notificationId);
            yyPushCustomViewUtil.handlePushImages(mBuilder.build(), notificationId);
            reportTemplate(msgId, payload.toString(), payload.has("pushId") ? payload.getString(
                    "pushId") : "", channelType, ctx);
            if (groupEntity != null && groupEntity.isOperation) {
                NotificationCounter.getInstance().addNotificationCache(context, notificationId,groupEntity.maxCount);
            }
            PushLog.inst().log(TAG + "sendBroadCast//payload=" + payload.toString());
        } catch (Throwable e) {
            PushLog.inst().log(TAG + "//sendBroadCast//erro=" + e);
            e.printStackTrace();
        }
    }

    private void reportTemplate(long msgId, String payload, String pushId, String channelType,
                                Context context) {
        try {
            YYPushMsgDispacher.getInstance().onPushSDKNotificationShow(msgId, payload.getBytes(),
                    channelType, IMsgArriveCallback.NOTIFICATION_TEMPLATE_TYPE, context);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("pushid", pushId);
            jsonObject.put("channeltype", channelType);
            PushReporter.getInstance().reportEvent(
                    YYPushStatisticEvent.REPORT_SEND_TEMPLATE_NOTIFICATION, jsonObject.toString());
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",reportTemplate" + t);
        }
    }

    private PendingIntent getCancleIntent(Context ctx, long msgId) {
        Intent in = new Intent(ctx, NotificationCancleReceiver.class);
        in.putExtra("msgId", msgId);
        PendingIntent pi = PendingIntent.getBroadcast(ctx, NotificationUtil.createNotificationId(msgId), in,
                PendingIntent.FLAG_UPDATE_CURRENT);
        return pi;
    }

    public Intent getClassIntent(JSONObject payloadJson,
                                 int notificationId,
                                 long msgId,
                                 String channelType) {
        Intent notifyIntent = null;
        try {
            JSONObject templateData = payloadJson.optJSONObject(PUSH_NOTIFICATION_DATA);
            String skipLink = "";
            if (templateData != null) {
                JSONObject skipLinkmap = templateData.optJSONObject(TEMPLATE_SKIPLINKMAP);
                if (skipLinkmap != null) {
                    Iterator<String> skit = skipLinkmap.keys();
                    while (skit.hasNext()) {
                        skipLink = skipLinkmap.getString(skit.next());
                    }
                }
            }
            notifyIntent = ClickIntentUtil.getLuluboxIntent(context,
                    payloadJson.toString(),
                    skipLink,
                    payloadJson.optString("pushId"),
                    notificationId,
                    msgId,
                    channelType);
        } catch (Throwable e) {
            PushLog.inst().log(TAG + "- getClassIntent: " + Log.getStackTraceString(e));
        }
        return notifyIntent;
    }

    private boolean getOnGoing(JSONObject payload) {
        boolean noGoing = false;
        try {
            JSONObject pushsdk = payload.optJSONObject(YYPushConsts.PAYLOAD_PUSHSDK_KEY);
            //1默认可消除；2打开app后可消除；3不可消除
            int clear = pushsdk.optInt("clear", 1);
            IAcquireAppState acquireAppState = YYPush.getInstace().getAcquireAppState();
            if (acquireAppState != null) {
                if (!acquireAppState.isOpenApp() && clear == 2) {
                    noGoing = true;
                }
            }
            if (clear == 3) {
                noGoing = true;
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",noGoing , erro = " + t);
        }
        return noGoing;
    }

    /**
     * 是否悬浮展示，默认是；
     * 当满足以下3个条件时不悬浮展示：
     * 1、app在前台；
     * 2、payload有标记为 show_type = 1 前台不展示;show_type =0默认展示
     * 3、当天已点击过push
     *
     * @return true展示悬浮（默认），false不展示
     */
    private boolean getSuspend(JSONObject payload) {
        boolean suspend = true;
        try {
            if (YYPush.getInstace().isSuspendStrategyEnable()) {
                JSONObject pushsdk = payload.optJSONObject(YYPushConsts.PAYLOAD_PUSHSDK_KEY);
                int showType = pushsdk.optInt(PUSH_SHOW_TYPE, 0);
                IAcquireAppState acquireAppState = YYPush.getInstace().getAcquireAppState();
                boolean isTodayClick = false;
                if (acquireAppState != null) {
                    isTodayClick = acquireAppState.isTodayClick();
                    if (showType == 1 && isTodayClick && YYPush.getInstace().getIsForground()) {
                        suspend = false;
                    }
                }
                PushLog.inst()
                        .log(TAG + ",suspend = " + suspend + ",showType=" + showType +
                                ",isTodayClick" +
                                "=" + isTodayClick + ",isforground = " +
                                YYPush.getInstace().getIsForground());
            }
            PushLog.inst()
                    .log(TAG + ",isSuspendStrategyEnable = " +
                            YYPush.getInstace().isSuspendStrategyEnable());
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",suspend , erro = " + t);
        }
        return suspend;
    }

    private boolean getTopMask(JSONObject payload) {
        boolean top = false;
        try {
            JSONObject pushsdk = payload.optJSONObject(YYPushConsts.PAYLOAD_PUSHSDK_KEY);
            top = pushsdk.optInt(TOP_MARK_KEY, TOP_MARK_FALSE) == TOP_MARK_TRUE ?
                    true : false;
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",top , erro = " + t);
        }
        return top;
    }
}
