package com.yy.pushsvc.template;

import android.content.Context;
import android.content.Intent;

import com.yy.pushsvc.receiver.ScreenChangeReceiver;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.repush.RepushEntity;
import com.yy.pushsvc.repush.RepushManager;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.YYPushConsts;

/**
 * Created by GuanYuFeng
 * on 2020/3/19
 */
public class TemplateIntercept implements YYPushMsgDispacher.IChainIntercept {
    @Override
    public boolean intercept(Intent intent, Context ctx) {
        try {
            if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD)) {
                if (TemplateManager.getInstance().templateNotificationIntercept(ctx, intent)) {
                    YYPushMsgDispacher.getInstance()
                            .onPushMsgIntercept(
                                    intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_MSGID, 0),
                                    intent.getByteArrayExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD),
                                    intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE),
                                    intent.getIntExtra(YYPushConsts.PUSH_TYPE,
                                            YYPushConsts.PUSH_TYPE_FCM),
                                    ctx);
                    RepushManager.getInstance().addMsg( intent);
                    return true;
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log("TemplateIntercept,intercept,erro = " + t);
        }
        return false;
    }
}
