package com.yy.pushsvc.template;

import com.yy.pushsvc.IImgFailCallback;
import com.yy.pushsvc.IShowTemplate;
import com.yy.pushsvc.R;
import com.yy.pushglide.IPushGlideListener;

public class TemplateConfig {
    private static final String TAG = "TemplateConfig";
    private int largeIconResourceId = R.drawable.yy_bear_logo;
    private int smallIconResourceId = R.drawable.yy_bear_logo;
    /**
     * 自定义样式加载失败时，显示默认图id
     */
    private IImgFailCallback imgFailCallback;
    /**
     *efox平台配置的efoxid
     */
    private String efoxAppid = "";
    /**
     * 自定义样式是否可用,总开关
     */
    private boolean enble = true;
    /**
     * 有大图样式时是否优先显示大图，默认显示小图
     * */
    private boolean largeImgPriority = false;
    /**
     * 该条push是否显示自定义样式，当enble总开关==true时该回调才有效
     */
    private IShowTemplate showTemplateListener;

    private IPushGlideListener glideListener;

    public IPushGlideListener getGlideListener() {
        return glideListener;
    }

    public void setGlideListener(IPushGlideListener glideListener) {
        this.glideListener = glideListener;
    }

    public TemplateConfig() {
    }

    public TemplateConfig(int largeIconResourceId, int smallIconResourceId,
                          IImgFailCallback imgFailCallback, String efoxAppid, boolean enble,
                          boolean largeImgPriority, IShowTemplate showTemplateListener) {
        this.largeIconResourceId = largeIconResourceId;
        this.smallIconResourceId = smallIconResourceId;
        this.imgFailCallback = imgFailCallback;
        this.efoxAppid = efoxAppid;
        this.enble = enble;
        this.largeImgPriority = largeImgPriority;
        this.showTemplateListener = showTemplateListener;
    }

    public int getLargeIconResourceId() {
        return largeIconResourceId;
    }

    public void setLargeIconResourceId(int largeIconResourceId) {
        this.largeIconResourceId = largeIconResourceId;
    }

    public int getSmallIconResourceId() {
        return smallIconResourceId;
    }

    public void setSmallIconResourceId(int smallIconResourceId) {
        this.smallIconResourceId = smallIconResourceId;
    }

    public IImgFailCallback getImgFailCallback() {
        return imgFailCallback;
    }

    public void setImgFailCallback(IImgFailCallback imgFailCallback) {
        this.imgFailCallback = imgFailCallback;
    }

    public String getEfoxAppid() {
        return efoxAppid;
    }

    public void setEfoxAppid(String efoxAppid) {
        this.efoxAppid = efoxAppid;
    }

    public boolean isEnble() {
        return enble;
    }

    public void setEnble(boolean enble) {
        this.enble = enble;
    }

    public boolean isLargeImgPriority() {
        return largeImgPriority;
    }

    public void setLargeImgPriority(boolean largeImgPriority) {
        this.largeImgPriority = largeImgPriority;
    }

    public IShowTemplate getShowTemplateListener() {
        return showTemplateListener;
    }

    public void setShowTemplateListener(IShowTemplate showTemplateListener) {
        this.showTemplateListener = showTemplateListener;
    }
}
