package com.yy.pushsvc.template;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.yy.pushsvc.BuildConfig;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.util.NetUtil;
import com.yy.pushsvc.util.PushHttpUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;

public class PushNotModleUtil {
    private static final String TAG = "PushNotModleUtil";
    private static volatile PushNotModleUtil instance;

    private String releaseModleUrl =
            "https://push-api." + YYPush.httpsDNS + "/push/api/getAppTemplatesInfoForCDN";
    private String testModleUrl =
            "https://push-api-test." + YYPush.httpsDNS + "/push/api/getAppTemplatesInfoForCDN";
    private String mUrl;
    private String uploadFailReason;
    private Context context;

    private PushNotModleUtil(Context context) {
        setRequestUrl();
        this.context = context;
    }

    public static PushNotModleUtil getInstance(Context context) {
        if (instance == null) {
            synchronized (PushNotModleUtil.class) {
                if (instance == null) {
                    instance = new PushNotModleUtil(context);
                }
            }
        }
        return instance;
    }

    public PushNotModleUtil initContext(Context context) {
        if (this.context == null) {
            this.context = context;
        }
        return this;
    }


    void asyncInitModleJson() {
        PushThreadPool.getPool().execute(new ModleRunnable());
    }

    private void setRequestUrl() {
        String ip = AppPushInfo.getTestEnvIp();
        boolean bHasConfigIp = (ip != null && (StringUtil.isIp(ip) || StringUtil.isDomain(ip)));
        mUrl = releaseModleUrl;
        if (bHasConfigIp) {
            mUrl = testModleUrl;
        }
    }

    public String getSyncModleJson(String modleId) throws SyncModelException {
        SharedPreferences sp = getSP();
        String result = null;
        String erro = "";
        try {
            if (!NetUtil.isNetworkAvailable(context)) {
                erro = "network is disable";
                throw new SyncModelException(erro);
            }
            setRequestUrl();
            //第一次请求拉去，modleUrls
            boolean isTest = !mUrl.equals(releaseModleUrl);
            mUrl = mUrl + "?appId=" + TemplateManager.getInstance().getConfig().getEfoxAppid() +
                    "&version=1" +
                    "&sdkver=" + BuildConfig.VERSION_NAME;
            PushLog.inst().log(TAG + "getSyncModleJson,mUrl = " + mUrl + ",isTest = " + isTest);
            PushHttpUtil.PushHttpResp resp = PushHttpUtil.getModle(mUrl, isTest);
            if (resp.statusCode != 200) {
                erro = "httpStatusCode:" + resp.statusCode + ", reason:" + resp.reason;
                PushLog.inst().log(TAG + ".getSyncModleJson postfrom data error " + resp.statusCode);
                throw new SyncModelException(erro);
            }
            result = resp.result;
            PushLog.inst().log(TAG + ".getSyncModleJson, mResult.content = " + result);
            if (result == null || result.isEmpty()) {
                erro = "reposeContent is null or empty statusCode:" + resp.statusCode;
                throw new SyncModelException(erro);
            } else {
                JSONObject jsonObject = new JSONObject(result);
                int code = jsonObject.getInt("code");
                String msg = jsonObject.getString("msg");
                if (code == 0) {
                    JSONObject modleInfo = jsonObject.getJSONObject("data");
                    if (modleInfo != null) {
                        JSONArray templates = modleInfo.getJSONArray("templates");
                        if (templates != null && templates.length() > 0) {
                            for (int i = 0; i < templates.length(); i++) {
                                JSONObject template = templates.getJSONObject(i);
                                String templateId = template.getString("templateId");
                                if (!TextUtils.isEmpty(modleId) && !TextUtils.isEmpty(templateId)
                                        && modleId.equals(templateId)) {

                                    String content = null;
                                    if (template.has("content")) {
                                        content = template.getString("content");
                                    }
                                    if (!TextUtils.isEmpty(content)) {
                                        sp.edit().putString(templateId, content).apply();
                                        return content;
                                    }else{
                                        String modelUrl = template.getString("url");
                                        PushHttpUtil.PushHttpResp modleResp2 =
                                                PushHttpUtil.getTemplateJson(
                                                        modelUrl, isTest);
                                        PushLog.inst().log(TAG + "getSyncModleJson, modelUrl = " +
                                                modelUrl + ",isTest = " + isTest);
                                        if (modleResp2 != null &&
                                                !TextUtils.isEmpty(modleResp2.result)) {
                                            PushLog.inst().log(TAG + "getSyncModleJson, modelUrl = " +
                                                    modelUrl + ",isTest = " + isTest + "/resultData=" +
                                                    modleResp2.result);
                                            sp.edit().putString(templateId, modleResp2.result).apply();
                                            return modleResp2.result;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    erro = modleId + "无法找到对应模板";
                    throw new SyncModelException(erro);
                } else {
                    erro = " statusCode:" + code + "and msg:" + msg;
                    throw new SyncModelException(erro);
                }
            }
        } catch (JSONException jSONException) {
            jSONException.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getFromData(String modleId) {
        String result = getSP().getString(modleId, null);
        return result;
    }

    private SharedPreferences getSP() {
        return context.getSharedPreferences(TAG, context.MODE_PRIVATE);
    }

    //初始化的时候下拉所有模板数据，并保存
    private class ModleRunnable implements Runnable {
        private String reposeContent;

        @Override
        public void run() {
            try {
                setRequestUrl();
                if (!NetUtil.isNetworkAvailable(context)) {
                    uploadFailReason = "network is disable";
                    return;
                }
                //第一次请求拉去，modleUrls
                boolean isTest = !mUrl.equals(releaseModleUrl);
                mUrl = mUrl + "?appId=" + TemplateManager.getInstance().getConfig().getEfoxAppid() +
                        "&version=1" +
                        "&sdkver=" + BuildConfig.VERSION_NAME;
                PushLog.inst().log(TAG + "ModleRunnable,mUrl = " + mUrl + ",isTest = " + isTest);
                PushHttpUtil.PushHttpResp resp = PushHttpUtil.getModle(mUrl, isTest);
                int mStatusCode = resp.statusCode;
                uploadFailReason = "httpStatusCode:" + mStatusCode + ", reason:" + resp.reason;
                if (mStatusCode != 200) {
                    PushLog.inst().log(TAG + ".ModleRunnable getAppTemplatesInfo  error " + mStatusCode);
                    return;
                }
                reposeContent = resp.result;
                PushLog.inst().log(TAG + ".ModleRunnable, mResult.content = " + reposeContent);
                if (reposeContent == null || reposeContent.isEmpty()) {
                    uploadFailReason = "reposeContent is null or empty statusCode:" + mStatusCode;
                    return;
                } else {
                    JSONObject jsonObject = new JSONObject(reposeContent);
                    int code = jsonObject.getInt("code");
                    String msg = jsonObject.getString("msg");
                    if (code == 0) {
                        JSONObject modleInfo = jsonObject.getJSONObject("data");
                        if (modleInfo != null) {
                            JSONArray templates = modleInfo.getJSONArray("templates");
                            if (templates != null && templates.length() > 0) {
                                SharedPreferences sp = getSP();
                                for (int i = 0; i < templates.length(); i++) {
                                    JSONObject template = templates.getJSONObject(i);
                                    String templateId = template.getString("templateId");
                                    String templateJson = sp.getString(templateId, null);
                                    if (TextUtils.isEmpty(templateJson)) {
                                        templateJson = template.getString("content");
                                        if (!TextUtils.isEmpty(templateJson)) {
                                            sp.edit().putString(templateId, templateJson).apply();
                                            PushLog.inst().log(TAG + ",ModleRunnable, " +
                                                    "templateJson = " + templateJson);
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        uploadFailReason = " statusCode:" + code + "and msg:" + msg;
                    }
                }
                return;
            } catch (Exception e) {
                uploadFailReason = e.toString();
                e.printStackTrace();
                PushLog.inst().log(TAG + ".ModleRunnable, post failed " + e.toString());
            }
            return;
        }
    }

    public static class SyncModelException extends Exception {

        public SyncModelException(String erro) {
            super(erro);
        }
    }
}

