package com.yy.pushsvc.template;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;

import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.YYPushStatisticEvent;

import org.json.JSONObject;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class NotificationHandler {
    int notificationId;
    public int maxImgCount;
    Context context;
    Notification notification;
    AtomicInteger complateCount = new AtomicInteger();
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private ConcurrentHashMap<Integer, Notification> delayNotificationMap = new ConcurrentHashMap();

    public NotificationHandler(Context context, int maxImgCount, int notificationId,
                               Notification notification) {
        this.notificationId = notificationId;
        this.maxImgCount = maxImgCount;
        this.notification = notification;
        this.context = context;
    }

    public void addComplate(boolean success, String url, String pushId) {
        try {
            int count = complateCount.incrementAndGet();
            PushLog.inst().log("NotificationHandler//" + "addComplate()" + ",count=" + count + "," +
                    "maxImgCount=" + maxImgCount + ",url=" + url + ",issuccess=" + success);
            if (count == maxImgCount) {
                showNotificationDelay(notificationId, notification, 0, true, pushId);
            }
        } catch (Throwable t) {
            PushLog.inst().log("NotificationHandler//" + "addComplate(),erro = " + t.toString());
        }
    }

    /**
     * 1、图片加载完显示，showCurrent=true；
     * 2、delayMillis内图片没加载完也显示一次
     *
     * @param notificationId
     * @param notification
     * @param delayMillis
     * @param showCurrent
     */
    public void showNotificationDelay(int notificationId, Notification notification,
                                      long delayMillis, boolean showCurrent, String pushId) {
        try {

            PushLog.inst().log("NotificationHandler//showNotificationDelay//" + "notificationId=" +
                    notificationId + ",delayMillis=" + delayMillis + ",showCurrent = " +
                    showCurrent);
            if (showCurrent) {
                NotificationUtil.cancleNotification(context, notificationId);
                delayNotificationMap.remove(notificationId);
                NotificationManager manager = (NotificationManager)
                        context.getSystemService(Context.NOTIFICATION_SERVICE);
                manager.notify(notificationId, notification);
                reportTemplate(YYPushStatisticEvent.REPORT_SEND_TEMPLATE_ALL_IMAGE, pushId, "fcm");
            } else {
                PushLog.inst().log("NotificationHandler//containsKey=" +
                        delayNotificationMap.containsKey(notificationId));
                if (!delayNotificationMap.containsKey(notificationId)) {
                    delayNotificationMap.put(notificationId, notification);
                    mainHandler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                Notification not = delayNotificationMap.remove(notificationId);
                                if (not != null) {
                                    PushLog.inst()
                                            .log("NotificationHandler//showNotificationDelay//" +
                                                    "run()=" + "show" + ",notificationId = " +
                                                    notificationId);
                                    NotificationUtil.cancleNotification(context, notificationId);
                                    NotificationManager manager = (NotificationManager)
                                            context.getSystemService(Context.NOTIFICATION_SERVICE);
                                    manager.notify(notificationId, not);
                                    reportTemplate(
                                            YYPushStatisticEvent.REPORT_SEND_TEMPLATE_TIMEOUT,
                                            pushId, "fcm");
                                }
                            } catch (Throwable t) {
                                PushLog.inst().log("NotificationHandler//showNotificationDelay//" +
                                        "notificationId=" +
                                        notificationId + ",run,erro=" + t.toString());
                            }
                        }
                    }, delayMillis);
                }

            }
        } catch (Throwable t) {
            PushLog.inst().log("NotificationHandler//showNotificationDelay//" + "notificationId=" +
                    notificationId + ",erro=" + t.toString());
        }
    }

    private void reportTemplate(String actionName, String pushId, String channelType) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("pushid", pushId);
            jsonObject.put("channeltype", channelType);
            PushReporter.getInstance().reportEvent(
                    actionName, jsonObject.toString());
        } catch (Throwable t) {
            PushLog.inst().log("NotificationHandler," + t);
        }
    }
}
