package com.yy.pushsvc.template;

import android.app.Activity;
import android.app.Notification;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.TextView;

import com.yy.pushsvc.util.PushLog;

import java.util.ArrayList;
import java.util.List;

import androidx.core.app.NotificationCompat;

public class NoficationBar {
    private static final String TAG = "NoficationBar";
    private static final double COLOR_THRESHOLD = 180.0;

    private static String DUMMY_TITLE = "DUMMY_TITLE";
    private int titleColor;

    public NoficationBar() {
    }

    //判断是否Notification背景是否为黑色
    public boolean isDarkNotificationBar(Context context) {
        boolean result = false;
        try {
            result = !isColorSimilar(Color.BLACK, getNotificationTitleColor(context));
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ".templateNotificationIntercept() exception:" + Log.getStackTraceString(e));
        }
        return result;
    }

    //获取Notification 标题的颜色
    private int getNotificationTitleColor(Context context) {
        int color = 0;
        if (context instanceof Activity) {
            color = getNotificationColorCompat(context);
        } else {
            color = getNotificationColorInternal(context);
        }
        return color;
    }

    //判断颜色是否相似
    private boolean isColorSimilar(int baseColor, int color) {
        int simpleBaseColor = baseColor | 0xff000000;
        int simpleColor = color | 0xff000000;
        int baseRed = Color.red(simpleBaseColor) - Color.red(simpleColor);
        int baseGreen = Color.green(simpleBaseColor) - Color.green(simpleColor);
        int baseBlue = Color.blue(simpleBaseColor) - Color.blue(simpleColor);


        double value = Math.sqrt(baseRed * baseRed + baseGreen * baseGreen + baseBlue * baseBlue);
        return value < COLOR_THRESHOLD;

    }

    //获取标题颜色
    private int getNotificationColorInternal(Context context) {
        Notification.Builder builder = new Notification.Builder(context);
        builder.setContentTitle(DUMMY_TITLE);
        builder.setContentText(DUMMY_TITLE);


        //notification.contentView 在android N 被弃用 返回的remoteViews有可能是空的
        //翻遍官方文档找到builder.createContentView() 来获取remoteViews
        // 官方文档原话：Construct a RemoteViews for the final 1U notification layout.
        //理论上返回为默认RemoteViews 经测试 有效

        RemoteViews remoteViews = null;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            remoteViews = builder.createContentView();
        } else {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                Notification notification = builder.build();
                remoteViews = notification.contentView;
            }
        }

        if (remoteViews == null) {
            return Color.BLACK;
        }
        ViewGroup vs = new FrameLayout(context);
        TextView title = null;
        ViewGroup notificationRoot = null;
        try {
            notificationRoot = (ViewGroup) remoteViews.apply(context, vs);
            title = (TextView) notificationRoot.findViewById(android.R.id.title);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ".getNotificationColorInternal() exception:" + Log.getStackTraceString(t));
        }
        if (title == null) { //如果ROM厂商更改了默认的id
            iteratorView(notificationRoot, new Filter() {
                @Override
                public void filter(View view) {
                    if (view instanceof TextView) {
                        TextView textView = (TextView) view;
                        if (DUMMY_TITLE.equals(textView.getText().toString())) {
                            titleColor = textView.getCurrentTextColor();
                        }
                    }
                }
            });
            return titleColor;
        } else {
            return title.getCurrentTextColor();
        }
    }

    private int getNotificationColorCompat(Context context) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        Notification notification = builder.build();
        if (notification == null || notification.contentView == null) {
            return Color.BLACK;
        }
        int layoutId = notification.contentView.getLayoutId();
        ViewGroup notificationRoot = (ViewGroup) LayoutInflater.from(context).inflate(layoutId, null);
        TextView title = (TextView) notificationRoot.findViewById(android.R.id.title);
        if (title == null) {
            final List<TextView> textViews = new ArrayList<>();
            iteratorView(notificationRoot, new Filter() {
                @Override
                public void filter(View view) {
                    if (view instanceof TextView) {
                        textViews.add((TextView) view);
                    }
                }
            });
            float minTextSize = Integer.MIN_VALUE;
            int index = 0;
            for (int i = 0, j = textViews.size(); i < j; i++) {
                float currentSize = textViews.get(i).getTextSize();
                if (currentSize > minTextSize) {
                    minTextSize = currentSize;
                    index = i;
                }
            }
            textViews.get(index).setText(DUMMY_TITLE);
            return textViews.get(index).getCurrentTextColor();
        } else {
            return title.getCurrentTextColor();
        }

    }

    private void iteratorView(View view, Filter filter) {
        if (view == null || filter == null) {
            return;
        }
        filter.filter(view);
        if (view instanceof ViewGroup) {
            ViewGroup container = (ViewGroup) view;
            for (int i = 0, j = container.getChildCount(); i < j; i++) {
                View child = container.getChildAt(i);
                iteratorView(child, filter);
            }
        }

    }

    interface Filter {
        void filter(View view);
    }
}
