package com.yy.pushsvc.template;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.yy.pushsvc.template.jumps.NotificationClickReceiver1;
import com.yy.pushsvc.util.PushLog;

import org.json.JSONObject;

/**
 * Created by GuanYuFeng
 * on 2019/5/27
 */
public class ClickIntentUtil {
    public static final String URL = "url";//efox配置跳转string
    public static final String PUSHI_D = "pushId";
    public static final String NOTIFICATION_ID = "notificationId";
    public static final String CHANNEL_TYPE = "channelType";
    public static final String MSG_ID = "msgId";
    public static final String PAYLOAD = "payload";
    public static final String YYPUSH_SKIPLINK = "yypushskiplink";

    public static Intent getLuluboxIntent(Context context,
                                          String payload,
                                          String url,
                                          String pushId,
                                          int notificationId,
                                          long msgId,
                                          String channelType) {
        Intent result = null;
        try {
            result = new Intent(context, NotificationClickReceiver1.class);
            JSONObject payloadJson = new JSONObject(payload);
            payloadJson.put("push_style","efox");
            payloadJson.put(YYPUSH_SKIPLINK, url);
            // payloadJson.remove(TemplateManager.PUSH_NOTIFICATION_TYPE);
            payloadJson.remove(TemplateManager.PUSH_NOTIFICATION_DATA);
            // payloadJson.remove(TemplateManager.PUSH_NOTIFICATION_LARGE_TYPE);
            payloadJson.remove(TemplateManager.PUSH_NOTIFICATION_LARGE_DATA);
            result.putExtra(PAYLOAD, payloadJson.toString());
            result.putExtra(MSG_ID, msgId);
            result.putExtra(PUSHI_D, pushId);
            result.putExtra(CHANNEL_TYPE, channelType);
            result.putExtra(NOTIFICATION_ID, notificationId);
        } catch (Throwable e) {
            PushLog.inst()
                    .log("ClickIntentUtil ,json construct failed =" + Log.getStackTraceString(e));
        }
        return result;
    }
}
