package com.yy.pushsvc.simplify;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

import com.yy.hiidostatis.defs.obj.Property;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.report.YYPushReportStatisticsHttp;
import com.yy.pushsvc.report.YYTokenBindHttp;
import com.yy.pushsvc.report.YYTokenUnBindHttp;
import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.util.AppPackageUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import androidx.core.app.NotificationManagerCompat;

/**
 * Created by maxiaodong on 2017/12/6.
 * Description
 */

public class TokenStore {

    private static TokenStore mInstance = new TokenStore();
    private volatile PushDBHelper mDbHelper = null;
    private volatile PushDBHelper.PushAccountInfo mBindInfo = new PushDBHelper.PushAccountInfo();
    private ConcurrentHashMap<String, String> mTokens = new ConcurrentHashMap<>();
    private volatile String mYYToken = "";
    private volatile String mThirdPartyToken = "";
    private volatile String mFcmToken = "";
    private volatile byte[] mMacAddr;

    public void init(Context context) {
        mDbHelper = PushDBHelper.getInstance(context);
        PushDBHelper.PushDeviceInfo deviceInfo = mDbHelper.getPushDeviceInfo();
        if (deviceInfo != null) {
            mYYToken = deviceInfo.mToken;
            mMacAddr = deviceInfo.mMac;
        } else {
            mMacAddr = AppPackageUtil.getMac(context).getBytes();
        }
        if (mDbHelper.hasStrKey(AppPushInfo.DB_KEY_THIRD_PARTY_TOKEN)) {
            mThirdPartyToken = mDbHelper.getStrVal(AppPushInfo.DB_KEY_THIRD_PARTY_TOKEN);
        }
        if (mDbHelper.hasStrKey(AppPushInfo.DB_KEY_FCM_TOKEN)) {
            mFcmToken = mDbHelper.getStrVal(AppPushInfo.DB_KEY_FCM_TOKEN);
        }

    }

    public static TokenStore getInstance() {
        return mInstance;
    }

    private TokenStore() {
    }

    public String getTokenID() {
        try {
            return mYYToken;
        } catch (Exception e) {
            return "";
        }
    }

    public String getMacAddr() {
        try {
            if (mMacAddr != null) {
                return new String(mMacAddr);
            } else {
                return "";
            }
        } catch (Exception e) {
            return "";
        }
    }

    public void addToken(Context context, String type, String token) {
        PushLog.inst().log("TokenStore.addToken, type = " + type + ",token = " + token);
        mTokens.put(type, token);
        if (type.equals(ThirdPartyPushType.PUSH_TYPE_YYPUSH)) {
            mYYToken = token;
        } else {
            if (mDbHelper != null) {
                if (type.equals(ThirdPartyPushType.PUSH_TYPE_XIAOMI)
                        || type.equals(ThirdPartyPushType.PUSH_TYPE_HUAWEI)||type.equals(ThirdPartyPushType.PUSH_TYPE_OPPO)) {
                    mDbHelper.addOrUpdateStrKey2StrVal(AppPushInfo.DB_KEY_THIRD_PARTY_TOKEN, token);
                    mThirdPartyToken = token;
                } else if (type.equals(ThirdPartyPushType.PUSH_TYPE_FCM)) {
                    mDbHelper.addOrUpdateStrKey2StrVal(AppPushInfo.DB_KEY_FCM_TOKEN, token);
                    mFcmToken = token;
                }
            }
        }

        if (!YYTokenBindHttp.getinstance().getBindFailedAccount().equals("")) {
            YYTokenBindHttp.getinstance().bindAccount(context, YYTokenBindHttp.getinstance().getBindFailedAccount());
        }
        if (!YYTokenUnBindHttp.getinstance().getUnBindFailedAccount().equals("")) {
            YYTokenUnBindHttp.getinstance()
                    .unBindAccount(context, YYTokenUnBindHttp.getinstance().getUnBindFailedAccount());
        }
    }

    public int getTokenMask() {
        int mask = 0;
        if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_XIAOMI) || (!TextUtils.isEmpty(mThirdPartyToken) &&
                Build.MANUFACTURER.equalsIgnoreCase(ThirdPartyPushType.PUSH_TYPE_XIAOMI))) {
            if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_FCM) || !TextUtils.isEmpty(mFcmToken)) {
                mask = (ThirdPartyPushType.TokenTypeMask.TOKEN_XIAOMI | ThirdPartyPushType.TokenTypeMask.TOKEN_FCM);
            } else {
                mask = ThirdPartyPushType.TokenTypeMask.TOKEN_XIAOMI;
            }
        } else if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_HUAWEI) || (!TextUtils.isEmpty(mThirdPartyToken) &&
                (Build.MANUFACTURER.equalsIgnoreCase(ThirdPartyPushType.PUSH_TYPE_HUAWEI) ||
                        Build.MANUFACTURER.equalsIgnoreCase("honor")))) {
            if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_FCM) || !TextUtils.isEmpty(mFcmToken)) {
                mask = (ThirdPartyPushType.TokenTypeMask.TOKEN_HUAWEI | ThirdPartyPushType.TokenTypeMask.TOKEN_FCM);
            } else {
                mask = ThirdPartyPushType.TokenTypeMask.TOKEN_HUAWEI;
            }
        }else if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_OPPO) ||
                (!TextUtils.isEmpty(mThirdPartyToken) &&
                        Build.BRAND.equals(ThirdPartyPushType.PUSH_TYPE_OPPO))) {
            if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_FCM) || !TextUtils.isEmpty(mFcmToken)) {
                mask = (ThirdPartyPushType.TokenTypeMask.TOKEN_OPPO | ThirdPartyPushType.TokenTypeMask.TOKEN_FCM);
            } else {
                mask = ThirdPartyPushType.TokenTypeMask.TOKEN_OPPO;
            }
        } else {
            if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_FCM) || !TextUtils.isEmpty(mFcmToken)) {
                mask = ThirdPartyPushType.TokenTypeMask.TOKEN_FCM;
            }
        }
        return mask;
    }

    public String getSysToken() {
        String token = "";

        try {
            if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_XIAOMI)) {
                token = mTokens.get(ThirdPartyPushType.PUSH_TYPE_XIAOMI);
            } else if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_HUAWEI)) {
                token = mTokens.get(ThirdPartyPushType.PUSH_TYPE_HUAWEI);
            } else if(mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_OPPO)){
                token = mTokens.get(ThirdPartyPushType.PUSH_TYPE_OPPO);
            }else {
                token = mThirdPartyToken;
            }
        } catch (Exception e) {
            PushLog.inst().log("TokenStore.getSysToken:  exception" + e.toString());
            return token;
        }

        PushLog.inst().log("TokenStore.getSysToken:  " + token);
        return token;
    }

    public String getFcmToken() {
        String utoken = "";

        try {
            if (mTokens.containsKey(ThirdPartyPushType.PUSH_TYPE_FCM)) {
                utoken = mTokens.get(ThirdPartyPushType.PUSH_TYPE_FCM);
            } else {
                utoken = mFcmToken;
            }
        } catch (Exception e) {
            PushLog.inst().log("TokenStore.getFcmToken, exception : " + e.toString());
            return utoken;
        }

        PushLog.inst().log("TokenStore.getFcmToken: " + utoken);
        return utoken;
    }

    public long getBindAccount() {
        long account = 0;
        try {
            if (mBindInfo.mAccount.equals("")) {
                return 0;
            }
            account = Long.parseLong(mBindInfo.mAccount);
            return account;
        } catch (Exception ex) {
            return 0;
        }
    }

    public void saveBindInfo(PushDBHelper.PushAccountInfo info) {
        if (mDbHelper != null) {
            mBindInfo = info;
        }
    }

    public void removeBindInfo() {
        if (mDbHelper != null) {
            mBindInfo.mAccount = "";
        }
    }

    public void saveRecvMsg(PushDBHelper.PushRecvMsg msg) {
        if (mDbHelper != null) {
            if (!isDuplicateMsg(msg.msgId)) {
                mDbHelper.saveRecvMsg(msg);
            }
        }
    }

    public boolean isDuplicateMsg(long msgid) {
        boolean isDuplicate;
        if (mDbHelper != null) {
            isDuplicate = mDbHelper.isDuplicateMsg(msgid);
            return isDuplicate;
        }
        return false;
    }

    public void removeDeviceinfo() {
        if (mDbHelper != null) {
            mDbHelper.removePushDeviceInfo();
        }
    }

    public  void dispatchToken(Context context, String type, String token) {
        PushLog.inst().log("TokenStore.dispatcherToken, token from: " + type + ",value:" + token);

        if (TextUtils.isEmpty(token)) {
            return;
        }

        //发送广播到APP，继承自YYPushMsgBroadcastReceiver 类
        String appKey = AppPushInfo.getPushReceiverAction(context);
        Intent intent = new Intent(appKey);
        intent.setPackage(context.getApplicationContext().getPackageName());
        intent.putExtra(YYPushConsts.YY_PUSH_KEY_TOKEN, token.getBytes());
        intent.putExtra(YYPushConsts.YY_REAL_TOKEN_TYPE, type);
        YYPushMsgDispacher.getInstance().dispatch(intent);
    }

    public void dispatchBindRes(Context context, int appID, String account, int resCode) {
        PushLog.inst()
                .log("TokenStore.dispatchBindRes, appId/account/rescode = " + appID + "/" + account + "/" + resCode);

        String appKey = AppPushInfo.getPushReceiverAction(context);
        Intent intent = new Intent(appKey);
        intent.setPackage(context.getApplicationContext().getPackageName());
        intent.putExtra(YYPushConsts.YY_PUSH_KEY_REG_PUSH_APP_RES, resCode);
        intent.putExtra(YYPushConsts.YY_PUSH_KEY_ACCOUNT, account);
        YYPushMsgDispacher.getInstance().dispatch(intent);
    }

    public void dispatchUnBindRes(Context context, int appID, String account, int resCode) {
        PushLog.inst()
                .log("TokenStore.dispatchUnBindRes, appId/account/rescode = " + appID + "/" + account + "/" + resCode);

        String appKey = AppPushInfo.getPushReceiverAction(context);
        Intent intent = new Intent(appKey);
        intent.setPackage(context.getApplicationContext().getPackageName());
        intent.putExtra(YYPushConsts.YY_PUSH_KEY_UNREG_PUSH_APP_RES, resCode);
        intent.putExtra(YYPushConsts.YY_PUSH_KEY_ACCOUNT, account);
        YYPushMsgDispacher.getInstance().dispatch(intent);
    }

    public void dispatchSetTagRes(Context context, int appID, int resCode) {
        PushLog.inst().log("TokenStore.dispatchSetTagRes, appID/rescode = " + appID + "/" + resCode);

        String appKey = AppPushInfo.getPushReceiverAction(context);
        Intent intent = new Intent(appKey);
        intent.setPackage(context.getApplicationContext().getPackageName());
        intent.putExtra(YYPushConsts.YY_PUSH_KEY_SET_TAG_RES, resCode);
        YYPushMsgDispacher.getInstance().dispatch(intent);
    }

    public void dispatchDelTagRes(Context context, int appID, int resCode) {
        PushLog.inst().log("TokenStore.dispatchDelTagRes, appID/rescode = " + appID + "/" + resCode);

        String appKey = AppPushInfo.getPushReceiverAction(context);
        Intent intent = new Intent(appKey);
        intent.setPackage(context.getApplicationContext().getPackageName());
        intent.putExtra(YYPushConsts.YY_PUSH_KEY_DEL_TAG_RES, resCode);
        YYPushMsgDispacher.getInstance().dispatch(intent);
    }

    ///递送应用在线透传信令消息
    public  boolean dispacthMsg(Context context, String type, String msgContext) {
        try {
            JSONObject jObject = new JSONObject(msgContext);
            return dispacthMsg(context, type, jObject);
        } catch (JSONException ex) {
            PushLog.inst()
                    .log("TokenStore.dispatcher msg (" + msgContext + ") error: " + StringUtil.exception2String(ex));
        }

        return false;
    }

    ///递送应用在线透传信令消息
    public  boolean dispacthMsg(Context context, String type, JSONObject jObject) {
        try {
            PushReporter.getInstance().init(context.getApplicationContext());
            long msgID = getLongFromJsonObject(jObject, "msgid");
            long pushid = getLongFromJsonObject(jObject, "pushid");
            reportEvent(context, YYPushConsts.PUSH_BROADCAST_ON_APP_MSG_RECEIVED_ALL, type, String.valueOf(pushid),
                    String.valueOf(msgID), false);

            if (isDuplicateMsg(msgID)) {
                PushLog.inst().log("TokenStore.dispactherMsg from json msgid=" + msgID +
                        ", db has same msgid and fiter the pushmsg.");
                return false;
            }

            saveRecvMsg(new PushDBHelper.PushRecvMsg(msgID, String.valueOf(getBindAccount()), type, mTokens.get(type)));

            String payload = getStringFromJsonObject(jObject, "payload");
            PushLog.inst().log("TokenStore.dispactherMsg from json msgid=" + msgID + ", channeltype = " + type +
                    ", payload = " + payload + ", pushid = " + pushid);

            reportEvent(context, YYPushConsts.PUSH_BROADCAST_ON_APP_MSG_RECEIVED, type, String.valueOf(pushid),
                    String.valueOf(msgID), false);
            // 把这段代码提前,避免因为中间一些代码差异有影响, 当前RECEIVED事件比ARRIVED的多
            String eid = YYPushConsts.HIIDO_PUSH_MESSAGE_ARRIVED;
            Property property = new Property();
            property.putString("msgid", String.valueOf(msgID));
            property.putString("pushid", String.valueOf(pushid));
            property.putString("unread", String.valueOf(false));
            property.putString(YYPushConsts.HIIDO_NOTIFICATION_PERMISSION,
                    String.valueOf(NotificationManagerCompat.from(context.getApplicationContext()).areNotificationsEnabled()));
            PushReporter.getInstance().reportNotificationEventToHiido(eid, type, property);


            String appKey = AppPushInfo.getPushReceiverAction(context);
            Intent intent = new Intent(appKey);
            if (type.equals(ThirdPartyPushType.PUSH_TYPE_FCM)) {
                Map<String, String> map = getMapFromJsonObject(jObject, YYPushConsts.YY_PUSH_KEY_MSGDATA);
                HashMap<String, String> newMap = new HashMap<>();
                if (map != null) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        newMap.put(entry.getKey(), entry.getValue());
                    }
                }
                if (newMap.size() > 0) {
                    PushLog.inst().log("TokenStore.dispacthMsg put msgdata to intent, msgdata:" + newMap.toString());
                    intent.putExtra(YYPushConsts.YY_PUSH_KEY_MSGDATA, newMap);
                }
            }

            intent.putExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE, type);
            intent.putExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD, payload.getBytes());
            intent.putExtra(YYPushConsts.YY_PUSH_KEY_MSGID, msgID);
            intent.putExtra(YYPushConsts.YY_PUSH_KEY_MSGTYPE, type);
            intent.putExtra(YYPushConsts.PUSH_TYPE, YYPushConsts.PUSH_TYPE_FCM);
            intent.setPackage(context.getApplicationContext().getPackageName());
            YYPushMsgDispacher.getInstance().dispatch(intent);

            if (convertChannelType(type) != -1) {
                String thirdToken;
                if (convertChannelType(type) != 128) {
                    thirdToken = getSysToken();
                } else {
                    thirdToken = getFcmToken();
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", convertChannelType(type));
                jsonObject.put("msgID", msgID);
                jsonObject.put("pushID", pushid);
                jsonObject.put("stat", YYPushConsts.MSG_STATE_APP_RECEIVED);
                jsonObject.put("thirdToken", thirdToken);
                JSONArray jsonArray = new JSONArray();
                jsonArray.put(jsonObject);
                if (mDbHelper != null) {
                    mDbHelper.recordReportStatistics(type, msgID, pushid, YYPushConsts.MSG_STATE_APP_RECEIVED,
                            thirdToken);
                } else {
                    mDbHelper = PushDBHelper.getInstance(context);
                    mDbHelper.recordReportStatistics(type, msgID, pushid, YYPushConsts.MSG_STATE_APP_RECEIVED,
                            thirdToken);
                }

                YYPushReportStatisticsHttp.getInstance()
                        .doReportStatisticsByHttp(context.getApplicationContext(), jsonArray);
            }

            return true;
        } catch (Exception ex) {
            PushLog.inst().log("TokenStore.dispatcher msg (" + jObject.toString() + ") error: " +
                    StringUtil.exception2String(ex));
        }

        return false;
    }

    ///递送应用在线透传信令消息
    public  void dispacthUnreadMsg(Context context, String type, String from, JSONArray jsonArray) {
        try {
            JSONArray newJsonArray = new JSONArray();
            PushLog.inst().log("TokenStore.dispatchUnreadMsg unreadMsg size:" + jsonArray.length());
            PushReporter.getInstance().init(context.getApplicationContext());
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = new JSONObject(jsonArray.getString(i));
                String msgIdKey = jsonObject.has("msgid")? "msgid" : "msgId";
                long msgID = getLongFromJsonObject(jsonObject, msgIdKey);
                String pushIdKey = jsonObject.has("pushid")? "pushid" : "pushId";
                long pushId = getLongFromJsonObject(jsonObject, pushIdKey);

                reportEvent(context, YYPushConsts.PUSH_BROADCAST_ON_APP_OUTLINE_MSG_RECEIVED_ALL, type, String.valueOf(pushId),
                        String.valueOf(msgID), true);

                if (isDuplicateMsg(msgID)) {
                    PushLog.inst().log("TokenStore.reportUnreadMsg from json msgid=" + msgID +
                            ", db has same msgid and fiter the pushmsg.");
                } else {
                    String payload = getStringFromJsonObject(jsonObject, "payload");
                    JSONObject jsonObject1 = new JSONObject();
                    jsonObject1.put("msgid", msgID);
                    jsonObject1.put("payload", payload);
                    jsonObject1.put("pushid", pushId);
                    newJsonArray.put(jsonObject1);

                    reportUnreadMsg(context, type, from, msgID, pushId, payload);
                }
            }

            if (newJsonArray.length() > 0) {
                String appKey = AppPushInfo.getPushReceiverAction(context);
                Intent intent = new Intent(appKey);
                intent.putExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE, type);
                intent.putExtra(YYPushConsts.YY_PUSH_KEY_UNREAD_MSG_JSON, newJsonArray.toString());
                intent.setPackage(context.getApplicationContext().getPackageName());
                intent.putExtra(YYPushConsts.PUSH_TYPE, YYPushConsts.PUSH_TYPE_UNREAD);
                YYPushMsgDispacher.getInstance().dispatch(intent);
            } else {
                PushLog.inst().log("TokenStore.dispatchUnreadMsg has no unreadMsg");
            }
        } catch (Exception ex) {
            PushLog.inst().log("TokenStore.dispacthUnreadMsg msg (" + jsonArray.toString() + ") error: " +
                    StringUtil.exception2String(ex));
        }

    }

    ///递送通知栏广播
    public void dispatchNotification(Context context, String notifytype, String channeltype,
                                     JSONObject jObject){
        try {
            long msgID = getLongFromJsonObject(jObject, "msgid");
            String payload = getStringFromJsonObject(jObject, "payload");
            long pushid = getLongFromJsonObject(jObject, "pushid");
            String eid;
            int state;
            if (mTokens.containsKey(channeltype)) {
                saveRecvMsg(new PushDBHelper.PushRecvMsg(msgID, String.valueOf(getBindAccount()), channeltype,
                        mTokens.get(channeltype)));
            }

            PushLog.inst().log("TokenStore.dispatcherNotification from json msgid=" + msgID + " broadcast type = " +
                    notifytype + ", msgtype = " + channeltype);

            reportEvent(context, notifytype, channeltype, String.valueOf(pushid),
                    String.valueOf(msgID), false);
            String appKey = AppPushInfo.getPushReceiverAction(context);

            Intent intent = new Intent(appKey);
            intent.putExtra(YYPushConsts.PUSH_BROADCAST_TYPE, notifytype);
            intent.putExtra(YYPushConsts.YY_PUSH_NOTIFICATION_PAYLOAD, payload.getBytes());
            intent.putExtra(YYPushConsts.YY_PUSH_KEY_MSGID, msgID);
            intent.putExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE, channeltype);
            intent.putExtra(YYPushConsts.YY_PUSH_KEY_PUSHID, pushid);
            intent.setPackage(context.getApplicationContext().getPackageName());
            YYPushMsgDispacher.getInstance().dispatch(intent);

            if (notifytype.equals(YYPushConsts.PUSH_BROADCAST_NOTIFICATION_ARRIVED)) {
                state = YYPushConsts.MSG_STATE_APP_RECEIVED;
                eid = YYPushConsts.HIIDO_PUSH_NOTIFICATION_ARRIVED;
            } else {
                state = YYPushConsts.MSG_STATE_OPENED;
                eid = YYPushConsts.HIIDO_PUSH_NOTIFICATION_CLICKED;
            }
            if (convertChannelType(channeltype) != -1) {
                String thirdToken;
                if (convertChannelType(channeltype) != 128) {
                    thirdToken = getSysToken();
                } else {
                    thirdToken = getFcmToken();
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", convertChannelType(channeltype));
                jsonObject.put("msgID", msgID);
                jsonObject.put("pushID", pushid);
                jsonObject.put("stat", state);
                jsonObject.put("thirdToken", thirdToken);
                JSONArray jsonArray = new JSONArray();
                jsonArray.put(jsonObject);
                if (mDbHelper != null) {
                    mDbHelper.recordReportStatistics(channeltype, msgID, pushid, state, thirdToken);
                } else {
                    mDbHelper = PushDBHelper.getInstance(context);
                    mDbHelper.recordReportStatistics(channeltype, msgID, pushid, state, thirdToken);
                }
                YYPushReportStatisticsHttp.getInstance()
                        .doReportStatisticsByHttp(context.getApplicationContext(), jsonArray);
            }
            Property property = new Property();
            property.putString("msgid", String.valueOf(msgID));
            property.putString("pushid", String.valueOf(pushid));
            property.putString("unread", String.valueOf(false));
            property.putString(YYPushConsts.HIIDO_NOTIFICATION_PERMISSION, String.valueOf(
                    NotificationManagerCompat.from(context.getApplicationContext()).areNotificationsEnabled()));
            PushReporter.getInstance().reportNotificationEventToHiido(eid, channeltype, property);

        } catch (Exception ex) {
            PushLog.inst().log("TokenStore.dispatchNotification msg (" + jObject.toString() + ") error: " +
                    StringUtil.exception2String(ex));
        }
    }

    private String getStringFromJsonObject(JSONObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            try {
                return jsonObject.getString(key);
            } catch (JSONException e) {
                e.printStackTrace();
                return "";
            }
        }
        return "";
    }

    private long getLongFromJsonObject(JSONObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            try {
                return jsonObject.getLong(key);
            } catch (JSONException e) {
                e.printStackTrace();
                return 0;
            }
        }
        return 0;
    }

    @SuppressWarnings("unchecked")
    private Map<String, String> getMapFromJsonObject(JSONObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            try {
                return (Map<String, String>) jsonObject.get(key);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private int convertChannelType(String channeltype) {
        switch (channeltype) {
            case ThirdPartyPushType.PUSH_TYPE_XIAOMI:
                return 1;
            case ThirdPartyPushType.PUSH_TYPE_HUAWEI:
                return 2;
            case ThirdPartyPushType.PUSH_TYPE_OPPO:
                return 32;
            case ThirdPartyPushType.PUSH_TYPE_FCM:
                return 128;
            case ThirdPartyPushType.PUSH_TYPE_YYPUSH:
                return 0;
            default:
                return -1;
        }
    }

    public void removeReportedStatistics(Context context, long msgid, int stat) {
        if (mDbHelper != null) {
            mDbHelper.clearReportStatistics(msgid, stat);
        } else {
            mDbHelper = PushDBHelper.getInstance(context);
            mDbHelper.clearReportStatistics(msgid, stat);
        }
    }

    public synchronized JSONArray getUnReportedStasticsFromDb(Context context) {
        PushLog.inst().log("TokenStore.getUnReportedStasticsFromDb");
        if (mDbHelper != null) {
            JSONArray jsonArray = mDbHelper.getUnReportedStatistics();
            if (jsonArray.length() != 0) {
                return jsonArray;
            } else {
                return null;
            }
        } else {
            mDbHelper = PushDBHelper.getInstance(context);
            JSONArray jsonArray = mDbHelper.getUnReportedStatistics();
            if (jsonArray.length() != 0) {
                return jsonArray;
            } else {
                return null;
            }
        }
    }

    public synchronized void uploadFcmReportStatistics(Context context, String channelType, long msgId, long pushId,
                                                       int state, boolean unreadFlag) {
        PushLog.inst().log("TokenStore.uploadFcmReportStatistics channelType:" + channelType + ", msgID:" + msgId +
                ", pushId:" + pushId + ", state :" + state + ", unreadFlag " + unreadFlag);
        try {
            if (context != null) {
                PushReporter.getInstance().init(context.getApplicationContext());
            }
            JSONObject jsonObject = new JSONObject();
            String thirdToken;
            thirdToken = getFcmToken();
            jsonObject.put("type", convertChannelType(channelType));
            jsonObject.put("msgID", msgId);
            jsonObject.put("pushID", pushId);
            jsonObject.put("stat", state);
            jsonObject.put("thirdToken", thirdToken);
            JSONArray jsonArray = new JSONArray();
            jsonArray.put(jsonObject);
            if (mDbHelper != null) {
                mDbHelper.recordReportStatistics(channelType, msgId, pushId, state, thirdToken);
            } else {
                if (context != null) {
                    mDbHelper = PushDBHelper.getInstance(context);
                    mDbHelper.recordReportStatistics(channelType, msgId, pushId, state, thirdToken);
                }
            }
            if (context != null) {
                YYPushReportStatisticsHttp.getInstance()
                        .doReportStatisticsByHttp(context.getApplicationContext(), jsonArray);
            }
            Property property = new Property();
            property.putString("msgid", String.valueOf(msgId));
            property.putString("pushid", String.valueOf(pushId));
            property.putString("unread", String.valueOf(unreadFlag));
            PushReporter.getInstance()
                    .reportNotificationEventToHiido(YYPushConsts.HIIDO_PUSH_NOTIFICATION_CLICKED,
                            channelType, property);

            reportEvent(context, YYPushConsts.PUSH_BROADCAST_NOTIFICATION_CLICKED,
                    ThirdPartyPushType.PUSH_TYPE_FCM, String.valueOf(pushId), String.valueOf(msgId), unreadFlag);
        } catch (Exception e) {
            PushLog.inst().log("TokenStore.uploadFcmReportStatistics exception:" + e);
        }

    }

    public void saveJiGuangPushSwitchToDb(final Context context, final String jiGuangPushSwitch) {
        try {
            PushThreadPool.getPool().execute(new Runnable() {
                @Override
                public void run() {
                    if (mDbHelper != null) {
                        PushLog.inst().log("TokenStore.saveJiGuangPushSwitchToDb " +
                                "mDbHelper is not null, call addOrUpdateStrKey2StrVal");
                        mDbHelper.addOrUpdateStrKey2StrVal(AppPushInfo.DB_KEY_JIGUANG_PUSH_SWITCH, jiGuangPushSwitch);
                    } else {
                        PushLog.inst().log("TokenStore.saveJiGuangPushSwitchToDb mDbHelper is null, " +
                                "call PushDBHelper first and then call addOrUpdateStrKey2StrVal");
                        mDbHelper = PushDBHelper.getInstance(context);
                        mDbHelper.addOrUpdateStrKey2StrVal(AppPushInfo.DB_KEY_JIGUANG_PUSH_SWITCH, jiGuangPushSwitch);
                    }
                }
            });
        } catch (Exception e) {
            PushLog.inst().log("TokenStore.saveJiGuangPushSwitchToDb exception:" + e);
        }
    }

    public boolean getJiGuangPushSwitch() {
        if (mDbHelper != null) {
            if (mDbHelper.hasStrKey(AppPushInfo.DB_KEY_JIGUANG_PUSH_SWITCH)) {
                if (mDbHelper.getStrVal(AppPushInfo.DB_KEY_JIGUANG_PUSH_SWITCH).equals("true")) {
                    PushLog.inst().log("TokenStore.getJiGuangPushSwitch JiGuangSwitch is on");
                    return true;
                } else {
                    PushLog.inst().log("TokenStore.getJiGuangPushSwitch JiGuangSwitch is off");
                    return false;
                }
            } else {
                PushLog.inst().log("TokenStore.getJiGuangPushSwitch db has no JiGuangSwitch");
                return true;
            }
        } else {
            PushLog.inst().log("TokenStore.getJiGuangPushSwitch mDbHelper is null");
            return true;
        }
    }

    public void saveYYTokenToDb(Context context, String token) {
        if (mDbHelper != null) {
            try {
                PushLog.inst().log("TokenStore.saveYYTokenToDb token:" + token);
                PushDBHelper.PushDeviceInfo deviceInfo = new PushDBHelper.PushDeviceInfo();
                deviceInfo.mToken = token;
                String hdid = DeviceProxy.getHdid(context);
                if (!StringUtil.isNullOrEmpty(hdid)) {
                    deviceInfo.mDeviceID = hdid.getBytes();
                }
                deviceInfo.mMac = TokenStore.getInstance().getMacAddr().getBytes();
                mDbHelper.savePushDeviceInfo(deviceInfo);
            } catch (Exception e) {
                Log.e("TokenStore", "saveYYTokenToDb exception:" + e);
            }
        }
        mYYToken = token;
    }

    public void reportEvent(Context context, String notifyType, String channelType, String pushId, String msgID, boolean unreadFlag) {
        PushLog.inst()
                .log("TokenStore.reportEvent channelType:" + channelType + ", notifyType:" + notifyType + ", pushId:" +
                        pushId + ", msgId:" + msgID);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("pushid", pushId);
            jsonObject.put("msgid", msgID);
            jsonObject.put("channeltype", channelType);
            switch (notifyType) {
                case YYPushConsts.PUSH_BROADCAST_ON_APP_MSG_RECEIVED_ALL:
                    if (!unreadFlag) {
                        // 因旧的离线也会走这里,所以要区分是否是离线
                        PushReporter.getInstance().reportEvent(
                                YYPushStatisticEvent.REPORT_RECEIVER_PUSH_ALL, jsonObject.toString());
                    }
                    break;
                case YYPushConsts.PUSH_BROADCAST_ON_APP_OUTLINE_MSG_RECEIVED_ALL:
                    {
                        PushReporter.getInstance().reportEvent(
                                YYPushStatisticEvent.REPORT_RECEIVER_OUTLINE_PUSH_ALL, jsonObject.toString());
                    }
                    break;
                case YYPushConsts.PUSH_BROADCAST_NOTIFICATION_CLICKED:
                    switch (channelType) {
                        case ThirdPartyPushType.PUSH_TYPE_XIAOMI:
                            PushReporter.getInstance()
                                    .reportEvent(YYPushStatisticEvent.CLICK_XIAOMI_PUSH, jsonObject.toString());
                            KLogW.i(YYPushStatisticEvent.CLICK_XIAOMI_PUSH, jsonObject.toString());
                            break;
                        case ThirdPartyPushType.PUSH_TYPE_HUAWEI:
                            PushReporter.getInstance()
                                    .reportEvent(YYPushStatisticEvent.CLICK_HUAWEI_PUSH, jsonObject.toString());
                            KLogW.i(YYPushStatisticEvent.CLICK_HUAWEI_PUSH, jsonObject.toString());
                            break;

                        case ThirdPartyPushType.PUSH_TYPE_OPPO:
                            PushReporter.getInstance()
                                    .reportEvent(YYPushStatisticEvent.CLICK_OPPO_PUSH,
                                            jsonObject.toString());
                            KLogW.i(YYPushStatisticEvent.CLICK_OPPO_PUSH, jsonObject.toString());
                            break;
                        case ThirdPartyPushType.PUSH_TYPE_FCM:
                            PushReporter.getInstance()
                                    .reportEvent(unreadFlag ? YYPushStatisticEvent.CLICK_FCM_UNREAD_PUSH :
                                                    YYPushStatisticEvent.CLICK_FCM_PUSH,
                                            jsonObject.toString());
                            KLogW.i(unreadFlag ? YYPushStatisticEvent.CLICK_FCM_UNREAD_PUSH :
                                    YYPushStatisticEvent.CLICK_FCM_PUSH, jsonObject.toString());
                            break;
                        default:
                            break;
                    }
                    break;
                case YYPushConsts.PUSH_BROADCAST_NOTIFICATION_ARRIVED:
                    if (channelType.equals(ThirdPartyPushType.PUSH_TYPE_XIAOMI)) {
                        PushReporter.getInstance()
                                .reportEvent(YYPushStatisticEvent.RECEIVER_XIAOMI_PUSH, jsonObject.toString());
                        KLogW.i(YYPushStatisticEvent.RECEIVER_XIAOMI_PUSH, jsonObject.toString());
                        if (NotificationManagerCompat.from(context.getApplicationContext()).areNotificationsEnabled()) {
                            PushReporter.getInstance()
                                    .reportEvent(YYPushStatisticEvent.SHOW_XIAOMI_PUSH, jsonObject.toString());
                            KLogW.i(YYPushStatisticEvent.SHOW_XIAOMI_PUSH, jsonObject.toString());
                        }
                    }
                    break;
                case YYPushConsts.PUSH_BROADCAST_ON_APP_MSG_RECEIVED:
                    switch (channelType) {
                        case ThirdPartyPushType.PUSH_TYPE_XIAOMI:
                            PushReporter.getInstance()
                                    .reportEvent(YYPushStatisticEvent.RECEIVER_XIAOMI_PUSH, jsonObject.toString());
                            KLogW.i(YYPushStatisticEvent.RECEIVER_XIAOMI_PUSH, jsonObject.toString());
                            if (NotificationManagerCompat.from(context.getApplicationContext())
                                    .areNotificationsEnabled()) {
                                PushReporter.getInstance()
                                        .reportEvent(YYPushStatisticEvent.SHOW_XIAOMI_PUSH, jsonObject.toString());
                            }
                            KLogW.i(YYPushStatisticEvent.SHOW_XIAOMI_PUSH, jsonObject.toString());
                            break;
                        case ThirdPartyPushType.PUSH_TYPE_HUAWEI:
                            PushReporter.getInstance()
                                    .reportEvent(YYPushStatisticEvent.RECEIVER_HUAWEI_PUSH, jsonObject.toString());
                            KLogW.i(YYPushStatisticEvent.RECEIVER_HUAWEI_PUSH, jsonObject.toString());
                            if (NotificationManagerCompat.from(context.getApplicationContext())
                                    .areNotificationsEnabled()) {
                                PushReporter.getInstance()
                                        .reportEvent(YYPushStatisticEvent.SHOW_HUAWEI_PUSH, jsonObject.toString());
                                KLogW.i(YYPushStatisticEvent.SHOW_HUAWEI_PUSH, jsonObject.toString());
                            }
                            break;

                        case ThirdPartyPushType.PUSH_TYPE_OPPO:
                            PushReporter.getInstance()
                                    .reportEvent(YYPushStatisticEvent.RECEIVER_OPPO_PUSH, jsonObject.toString());
                            KLogW.i(YYPushStatisticEvent.RECEIVER_OPPO_PUSH, jsonObject.toString());
                            if (NotificationManagerCompat.from(context.getApplicationContext())
                                    .areNotificationsEnabled()) {
                                PushReporter.getInstance()
                                        .reportEvent(YYPushStatisticEvent.SHOW_OPPO_PUSH, jsonObject.toString());
                                KLogW.i(YYPushStatisticEvent.SHOW_OPPO_PUSH, jsonObject.toString());
                            }
                            break;
                        case ThirdPartyPushType.PUSH_TYPE_FCM:
                            PushReporter.getInstance()
                                    .reportEvent(unreadFlag ? YYPushStatisticEvent.RECEIVER_FCM_UNREAD_PUSH :
                                                    YYPushStatisticEvent.RECEIVER_FCM_PUSH,
                                            jsonObject.toString());
                            KLogW.i(unreadFlag ? YYPushStatisticEvent.RECEIVER_FCM_UNREAD_PUSH :
                                    YYPushStatisticEvent.RECEIVER_FCM_PUSH, jsonObject.toString());
                            if (NotificationManagerCompat.from(context.getApplicationContext())
                                    .areNotificationsEnabled()) {
                                PushReporter.getInstance()
                                        .reportEvent(unreadFlag ? YYPushStatisticEvent.SHOW_FCM_UNREAD_PUSH :
                                                        YYPushStatisticEvent.SHOW_FCM_PUSH,
                                                jsonObject.toString());
                                KLogW.i(unreadFlag ? YYPushStatisticEvent.SHOW_FCM_UNREAD_PUSH :
                                        YYPushStatisticEvent.SHOW_FCM_PUSH, jsonObject.toString());
                            }
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    break;
            }
        } catch (Throwable e) {
            PushLog.inst().log("reportEvent failed:" + Log.getStackTraceString(e));
        }
    }

    private void reportUnreadMsg(Context context, String type, String from, long msgId, long pushId, String payload) {
        try {
            PushLog.inst().log("TokenStore.reportUnreadMsg from json msgid=" + msgId + ", channeltype = " + type +
                    ", payload = " + payload + ", pushid = " + pushId + ", from=" + from);

            saveRecvMsg(new PushDBHelper.PushRecvMsg(msgId, String.valueOf(getBindAccount()), type, mTokens.get(type)));

            // reportEvent 方法太多地方调用,改接口会影响其他地方,所以对于quic的单独逻辑上报
            if ("quic".equals(from)) {
                reportFetchOutlineUnreadMsgToHiido(context, String.valueOf(pushId), String.valueOf(msgId));
            } else {
                reportEvent(context, YYPushConsts.PUSH_BROADCAST_ON_APP_MSG_RECEIVED, type, String.valueOf(pushId),
                        String.valueOf(msgId), true);
            }

            if (convertChannelType(type) != -1) {
                String thirdToken;
                if (convertChannelType(type) != 128) {
                    thirdToken = getSysToken();
                } else {
                    thirdToken = getFcmToken();
                }
                JSONObject jObject = new JSONObject();
                jObject.put("type", convertChannelType(type));
                jObject.put("msgID", msgId);
                jObject.put("pushID", pushId);
                jObject.put("stat", YYPushConsts.MSG_STATE_APP_RECEIVED);
                jObject.put("thirdToken", thirdToken);
                JSONArray newJsonArray = new JSONArray();
                newJsonArray.put(jObject);
                if (mDbHelper != null) {
                    mDbHelper.recordReportStatistics(type, msgId, pushId, YYPushConsts.MSG_STATE_APP_RECEIVED,
                            thirdToken);
                } else {
                    mDbHelper = PushDBHelper.getInstance(context);
                    mDbHelper.recordReportStatistics(type, msgId, pushId, YYPushConsts.MSG_STATE_APP_RECEIVED,
                            thirdToken);
                }

                YYPushReportStatisticsHttp.getInstance()
                        .doReportStatisticsByHttp(context.getApplicationContext(), newJsonArray);
            }

            String eid = YYPushConsts.HIIDO_PUSH_MESSAGE_ARRIVED;
            Property property = new Property();
            property.putString("msgid", String.valueOf(msgId));
            property.putString("pushid", String.valueOf(pushId));
            property.putString("unread", String.valueOf(true));
            property.putString("msgfrom", from);
            property.putString(YYPushConsts.HIIDO_NOTIFICATION_PERMISSION, String.valueOf(
                    NotificationManagerCompat.from(context.getApplicationContext()).areNotificationsEnabled()));

            PushReporter.getInstance().reportNotificationEventToHiido(eid, type, property);
        } catch (Exception e) {
            Log.e("TokenStore", "reportUnreadMsg: " + e);
        }
    }

    // 为不影响其它逻辑, quic获取离线单独逻辑上报
    private void reportFetchOutlineUnreadMsgToHiido(Context context, String pushId, String msgID) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("pushid", pushId);
            jsonObject.put("msgid", msgID);
            jsonObject.put("msgfrom", "quic");
            PushReporter.getInstance().reportEvent(
                    YYPushConsts.HIIDO_FETCH_OUTLINE_MSG_RECEIVED_EVENT_ID,
                    jsonObject.toString());
            KLogW.i(YYPushConsts.HIIDO_FETCH_OUTLINE_MSG_RECEIVED_EVENT_ID, jsonObject.toString());
            if (NotificationManagerCompat.from(context.getApplicationContext()).areNotificationsEnabled()) {
                PushReporter.getInstance().reportEvent(
                        YYPushConsts.HIIDO_FETCH_OUTLINE_MSG_SHOW_EVENT_ID,
                        jsonObject.toString());
                KLogW.i(YYPushConsts.HIIDO_FETCH_OUTLINE_MSG_SHOW_EVENT_ID, jsonObject.toString());
            }
        } catch (Throwable e) {
            KLogW.i("TokenStore", "reportFetchOutlineUnreadMsgToHiido faild!!" + Log.getStackTraceString(e));
        }
    }
}
