package com.yy.pushsvc.simplify;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import android.util.Log;

import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.StringUtil;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by HUTAO on 2017/12/6.
 */

public class AppPushInfo {
    private static final String TAG = "AppPushInfo";
    private static int mMainVer = 3;
    private static int mSubVer = 0;
    private static int mSubVer2 = 0;
    private volatile static String mAppVersion = "";
    private static String mYYPushVersionName = "pushsdkversion";
    private volatile static String mYYPushVersion = "";

    private static String mYYKeyName = "appKey";
    private volatile static int mYYKey = 0;
    private static String mYYAuthTicketName = "PushAuthUniTicket";
    private static String mYYAuthTicket = "";

    private static String APP_PUSH_RECEIVER_PREFIX = "com.yy.pushsrv.";
    public static String HIIDO_APP_KEY = "4b04df0edd0bbc0881cfe72233e0be63";

    private static String mXiaomiID = "";
    private static String mXiaomiKey = "";

    private static final String KEY_USE_XIAOMI = "use_xiaomi";
    private static final String KEY_USE_HUAWEI = "use_huawei";
    private static Map<String, Object> mParams = new HashMap<>();

    public static final String DB_KEY_THIRD_PARTY_TOKEN = "DBKeyThirdPartyToken";
    public static final String DB_KEY_FCM_TOKEN = "DBKeyFcmToken";

    public static final String DB_KEY_JIGUANG_PUSH_SWITCH = "DBKeyJiGuangPushSwitch";

    public static final String START_SERVICE = "START_SERVICE";
    public static final String BIND_SERVICE = "BIND_SERVICE";
    public static final String CONTENTPROVIDER = "CONTENTPROVIDER";
    private static String EFOX_PUSH_APPID_NAME = "EFOX_PUSH_APPID";

    private static String pushTestIp = null;

    private static volatile boolean isDealFcmToken = false;
    private static volatile boolean getUnreadMsgFlag = false;

    private static volatile boolean isNeedGetUnreadMsg = false;
    private static volatile int getUnreadMsgMaxNum = 3;
    private static volatile int mSyncPeriod = 900;
    private static volatile boolean isNeedStartAccountSync = false;
    private static volatile String mFcmToken = "";

    private static boolean enableFetchOutlineMsg = false;
    private static boolean useHttpFetchOutlineMsg = false;

    public static void setAppVersion(String appVer) {
        mAppVersion = appVer;
    }

    public static String getAppVersion() {
        return mAppVersion;
    }

    public static String getYYPushVersion(Context context) {
        if (!TextUtils.isEmpty(mYYPushVersion)) {
            return mYYPushVersion;
        }
        if (context == null) {
            return mYYPushVersion;
        }
        ApplicationInfo appInfo;
        try {
            appInfo = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            mYYPushVersion = appInfo.metaData.getString(mYYPushVersionName);
        } catch (Exception e) {
            PushLog.inst().log("AppPushInfo.getPushSdkVersion error: " + StringUtil.exception2String(e));
        }
        return mYYPushVersion;
    }

    public static int getYYPushVersionNo() {
        String strPushVer = mYYPushVersion;
        if (!StringUtil.isNullOrEmpty(strPushVer)) {
            String[] version = strPushVer.split("\\.|-|_");
            if (version.length < 3) {
                return mSubVer2 + mSubVer * 1000 + mMainVer * 1000 * 1000;
            }

            mMainVer = Integer.valueOf(version[0]);
            mSubVer = Integer.valueOf(version[1]);
            mSubVer2 = Integer.valueOf(version[2]);
        }
        return mSubVer2 + mSubVer * 1000 + mMainVer * 1000 * 1000;
    }

    public static int getYYKey(Context context) {
        if (mYYKey > 0) {
            return mYYKey;
        }
        if (context == null) {
            return mYYKey;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            mYYKey = appInfo.metaData.getInt(mYYKeyName);
            return mYYKey;
        } catch (Exception e) {
            PushLog.inst().log("AppPushInfo.getYYKey error: " + StringUtil.exception2String(e));
            return mYYKey;
        }
    }

    public static String getYYAuthTicket(Context context) {
        if (!TextUtils.isEmpty(mYYAuthTicket)) {
            return mYYAuthTicket;
        }
        if (context == null) {
            return mYYAuthTicket;
        }
        try {
            ApplicationInfo appInfo = context.getApplicationContext().getPackageManager().
                    getApplicationInfo(context.getApplicationContext().getPackageName(), PackageManager.GET_META_DATA);
            return appInfo.metaData.getString(mYYAuthTicketName);
        } catch (Exception ex) {
            PushLog.inst().log("AppPushInfo.getYYAuthTicket error: " + Log.getStackTraceString(ex));
            return mYYAuthTicket;
        }
    }

    public static String getPushReceiverAction(Context context) {
        return APP_PUSH_RECEIVER_PREFIX + getYYKey(context);
    }

    public static String getXiaomiID() {
        return mXiaomiID;
    }

    public static String getXiaomiKey() {
        return mXiaomiKey;
    }

    public static void setXiaomiId(String xiaomiId) {
        mXiaomiID = xiaomiId;
    }

    public static void setXiaomiKey(String xiaomiKey) {
        mXiaomiKey = xiaomiKey;
    }

    public static void setUseXiaomi(boolean isUse) {
        mParams.put(KEY_USE_XIAOMI, isUse);
    }

    public static boolean getUseXiaomi() {
        //不包含，默认使用
        return !mParams.containsKey(KEY_USE_XIAOMI) || (boolean) mParams.get(KEY_USE_XIAOMI);
    }

    public static void setUseHuawei(boolean isUse) {
        mParams.put(KEY_USE_HUAWEI, isUse);
    }

    public static boolean getUseHuawei() {
        //不包含，默认使用
        return !mParams.containsKey(KEY_USE_HUAWEI) || (boolean) mParams.get(KEY_USE_HUAWEI);
    }

    public static String getMac(Context context) {
        try {
            WifiManager wifiMgr = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
            if (wifiMgr != null) {
                WifiInfo connectionInfo = wifiMgr.getConnectionInfo();
                if (connectionInfo != null) {
                    String macAddress = connectionInfo.getMacAddress();
                    if (macAddress != null) {
                        try {
                            String macStr = URLEncoder.encode(macAddress, "UTF-8");
                            if (macStr != null) {
                                return macStr;
                            }
                        } catch (UnsupportedEncodingException e1) {
                            // fall back to return fake mac.
                            e1.printStackTrace();
                        }
                    }
                }
            }
            return "YY_FAKE_MAC";
        } catch (Exception e) {
            PushLog.inst().log("AppPushInfo.getMac error: " + Log.getStackTraceString(e));
            return "YY_FAKE_MAC";
        }
    }

    public synchronized static void setPushTestEnvIp(String ip) {
        pushTestIp = ip;
    }

    public synchronized static String getPushTestEnvIp() {
        return pushTestIp;
    }

    public synchronized static String getTestEnvIp() {
        return pushTestIp;
    }

    public synchronized static boolean isTestEnv() {
        boolean isTest = (pushTestIp != null && (StringUtil.isIp(pushTestIp) || StringUtil.isDomain(pushTestIp)));
        return isTest;
    }


    public synchronized static boolean isDealFcmToken() {
        return isDealFcmToken;
    }

    public synchronized static void setIsDealFcmToken() {
        AppPushInfo.isDealFcmToken = true;
    }

    public static String jiGuangWakeType2WakeName(int wakeType) {
        switch (wakeType) {
            case 1:
                return START_SERVICE;
            case 2:
                return BIND_SERVICE;
            case 4:
                return CONTENTPROVIDER;
            default:
                return "";
        }
    }

    public static String getPushEfoxAppId(Context context) {
        String result = "";
        if (context == null) {
            return result;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            result = appInfo.metaData.getString(EFOX_PUSH_APPID_NAME);
            if (TextUtils.isEmpty(result)) {
                int temp = appInfo.metaData.getInt(EFOX_PUSH_APPID_NAME);
                if (temp != 0) {
                    result = String.valueOf(temp);
                }
            }
            return result;
        } catch (Exception e) {
            PushLog.inst().log("AppPushInfo.getYYKey error: " + StringUtil.exception2String(e));
            return result;
        }
    }

    public static void setUnreadMsgFlag(boolean flag) {
        getUnreadMsgFlag = flag;
    }

    public static boolean getUnreadMsgFlag() {
        return getUnreadMsgFlag;
    }

    public static void setIsNeedGetUnreadMsg(boolean flag) {
        isNeedGetUnreadMsg = flag;
    }

    public static boolean getIsNeedGetUnreadMsg() {
        return isNeedGetUnreadMsg;
    }

    public static void setGetUnreadMsgMaxNum(int maxNum) {
        getUnreadMsgMaxNum = maxNum;
    }

    public static int getUnreadMsgMaxNum() {
        return getUnreadMsgMaxNum;
    }
    public static void setAccountSyncPeriod(int period) {
        mSyncPeriod = period;
    }
    public static int getAccountSyncPeriod() {
        return mSyncPeriod;
    }

    public static void setIsNeedAccountSync(boolean flag) {
        isNeedStartAccountSync = flag;
    }

    public static boolean getIsNeedAccountSync() {
        return isNeedStartAccountSync;
    }

    public static void saveFcmToken(String token) {
        mFcmToken = token;
    }

    public static String getFcmToken() {
        return mFcmToken;
    }

    public static boolean isEnableFetchOutlineMsg() {
        return enableFetchOutlineMsg;
    }

    public static void setEnableFetchOutlineMsg(boolean enable) {
        enableFetchOutlineMsg = enable;
    }

    public static void setFetchOutlineUseHttp(boolean useHttp) {
        useHttpFetchOutlineMsg = useHttp;
    }

    public static boolean isUseHttpFetchOutlineMsg() {
        return useHttpFetchOutlineMsg;
    }

    public static int getSDKVersion() {
        int ver = 0;
        try {
            ver = android.os.Build.VERSION.SDK_INT;
        } catch (Throwable e) {
            PushLog.inst().log("AppPushInfo.getSDKVersion error: " + Log.getStackTraceString(e));
        }
        return ver;
    }

    private static String mOppoAppkey = null;
    private static String mOppoAppSecret = null;
    public static String getOpushAppkey(Context context) {
        String appkey = mOppoAppkey;
        if (!StringUtil.isNullOrEmpty(appkey)) {
            return appkey;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            if (appInfo.metaData.containsKey("OPUSH_APPKEY")) {
                appkey = appInfo.metaData.getString("OPUSH_APPKEY");
            } else {
                PushLog.inst().log(TAG + ".getOpushAppkey metaData has no OPUSH_APPKEY: ");
            }
            return appkey;
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".getOpushAppkey error: " + StringUtil.exception2String(e));
            return null;
        }
    }

    public static String getOpushAppSecret(Context context) {
        String appSecret = mOppoAppSecret;
        if (!StringUtil.isNullOrEmpty(appSecret)) {
            return appSecret;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(
                    context.getPackageName(),
                    PackageManager.GET_META_DATA);
            if (appInfo.metaData.containsKey("OPUSH_APPSECRET")) {
                appSecret = appInfo.metaData.getString("OPUSH_APPSECRET");
            } else {
                PushLog.inst().log(TAG + ".getOpushAppSecret metaData has no OPUSH_APPSECRET");
            }
            return appSecret;
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".getOpushAppSecret exception: " + StringUtil.exception2String(e));
            return null;
        }
    }
}
