package com.yy.pushsvc.service.outline;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;

import com.yy.pushsvc.util.PushLog;

class LoopRunner implements Runnable {

    private final static String TAG = "LoopRunner";
    volatile Runnable runnable;
    final Handler handler;
    final static int MIN_TIME = 15;
    final static int MAX_TIME = 300;
    volatile long lastDelaySec = 15L;

    public LoopRunner(final HandlerThread handlerThread, final Runnable runnable) {
        this.runnable = runnable;
        handler = new Handler(handlerThread.getLooper());
    }

    public synchronized void onStart() {
        handler.post(this);
    }

    public synchronized void onStop() {
        handler.removeCallbacks(this);
    }

    public synchronized void onUpdate(long sec) {
        this.lastDelaySec = sec;
        handler.removeCallbacks(this);
        // -1 表示服务器当前不希望被访问,待下次app启动再启动
        if (lastDelaySec != -1) {
            lastDelaySec = lastDelaySec <= MIN_TIME?
                    MIN_TIME :
                    (lastDelaySec >= MAX_TIME? MAX_TIME : lastDelaySec);
            handler.postDelayed(this, lastDelaySec * 1000);
        } else {
            PushLog.inst().log(TAG + " Current Service Stop, Start On Next AppStart");
        }
    }

    @Override
    public void run() {
        try {
            if (runnable != null) {
                runnable.run();
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ", LoopRunner exception:" + Log.getStackTraceString(e));
        }
    }
}
