package com.yy.pushsvc.service.outline;

import android.app.Service;
import android.content.Intent;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.pushsvc.BuildConfig;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.aidl.IPushSvcInterface;
import com.yy.pushsvc.aidl.IPushUnreadCallback;
import com.yy.pushsvc.aidl.PushUnreadMsg;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.util.CronetUtils;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushSPHelper;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;

import org.json.JSONObject;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * 使用quic协议,定时去google云获取离线数据
 */
public class FetchOutlineMsgService extends Service {

    boolean isTestEvn = false;
    boolean isEnable = false;
    boolean isStart = false;
    boolean isHttp = false;
    final LoopRunner loopRunner;
    final HandlerThread handlerThread;
    static long lastDelaySec = 15;

    @Override
    public IBinder onBind(Intent intent) { return iPushSvcInterface; }


    @Override
    public void onCreate() {
        super.onCreate();
        YYPush.getInstace().setHostName(this,PushSPHelper.getInstance().getConfUrlDomain(this));
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (isEnable) {
            loopRunner.onStop();
        }
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null && intent.hasExtra("isEnable")) {
            isEnable = intent.getBooleanExtra("isEnable", false);
            isHttp = intent.getBooleanExtra("isHttp", false);
            String pushTestIp = intent.getStringExtra("pushTestIp");
            isTestEvn = (pushTestIp != null && (StringUtil.isIp(pushTestIp) || StringUtil.isDomain(pushTestIp)));
            Log.i("FetchOutlineMsgService=" , "isHttp =  " + isHttp +",isTestEvn = "+isTestEvn);
        }
        PushLog.inst().log("FetchOutlineMsgService.isEnableFetchOutlineMsg=" + isEnable + ",isTestEvn=" + isTestEvn);

        if (isEnable && !isStart) {
            PushThreadPool.getPool().execute(new Runnable() {
                @Override
                public void run() {
                    Log.i("FetchOutlineMsgService=" , "start time= " + System.currentTimeMillis());
                    CronetUtils.getsInstance(isTestEvn).init(getBaseContext(),isHttp);
                    Log.i("FetchOutlineMsgService=" , "end time= " + System.currentTimeMillis());

                    isStart = true;
                    loopRunner.onStart();
                }
            });
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public FetchOutlineMsgService() {
        handlerThread = new HandlerThread("fetch_outline_msg_thread");
        handlerThread.start();
        this.loopRunner = new LoopRunner(handlerThread, new Runnable() {
            @Override
            public void run() {
                PushLog.inst().log("FetchOutlineMsgService " + "LoopRunner run");
                runnerBody();
            }
        });
    }

    private synchronized void runnerBody() {
        try {
            final String reqParams = requestParams(lastDelaySec);
            PushLog.inst().log("FetchOutlineMsgService " + "runnerBody reqParams: " + reqParams);
            CronetUtils.getsInstance(isTestEvn).getOutlineMsgFromNet(true ,  reqParams,
                    new CronetUtils.Callback() {
                @Override
                public void onSuccess(int code, String result) {
                    try {
                        PushLog.inst().log("FetchOutlineMsgService " + "runnerBody parseJson: " + result);
                        JSONObject jobj = new JSONObject(result);
                        JSONObject dataObbj = jobj.optJSONObject("data");
                        lastDelaySec = dataObbj.optLong("delaySec", 15L);
//                        JSONArray msgs = dataObbj.optJSONArray("msgs");
                        String msgs = dataObbj.optString("msgs", "");
                        if (fetchCallback != null) {
                            fetchCallback.callback(new PushUnreadMsg(ThirdPartyPushType.PUSH_TYPE_FCM, msgs));
                        }
                    } catch (Throwable e) {
                        PushLog.inst().log("FetchOutlineMsgService" + ",runnerBody parseJson failed!!" + result);
                    } finally {
                        loopRunner.onUpdate(lastDelaySec);
                    }
                }

                @Override
                public void onFailed(int code, String error) {
                    PushLog.inst().log("FetchOutlineMsgService" + ",runnerBody request failed!! code=" + code + ",msg=" + error);
                    lastDelaySec = (lastDelaySec >= 300)? 300 : lastDelaySec * 2;
                    loopRunner.onUpdate(lastDelaySec);
                }
            });
        } catch (Throwable e) {
            PushLog.inst().log("FetchOutlineMsgService " + "runnerBody " + Log.getStackTraceString(e));
        }
    }

    // lastDelaySec 上一次拉去时间,这参数服务端没有记录这个状态,还需要客户端上报
    private String requestParams(long lastDelaySec) {
        StringBuilder tempParams = new StringBuilder();
        try {
            int pos = 0;
            boolean isFrontGround = (fetchCallback != null)? fetchCallback.isActivityFrontGround() : false;
            Map<String, String> paramsMap = new HashMap<String, String>() {
                {
                    put("deviceId",     DeviceProxy.getHdid(getBaseContext()));
                    put("uid",          "" + TokenStore.getInstance().getBindAccount());
//                put("appid",        "1236618350");
                    put("appid",        "" + AppPushInfo.getYYKey(getBaseContext()));
                    put("lastPullSec",  "" + System.currentTimeMillis());
                    put("lastDelaySec", "" + lastDelaySec);
                    put("isFrontGround", "" + (isFrontGround? 1: 0));
                    put("ver",          "" + BuildConfig.VERSION_NAME);
                    put("extJson",      "");
                }
            };
            for (String key : paramsMap.keySet()) {
                if (pos > 0) {
                    tempParams.append("&");
                }
                tempParams.append(String.format("%s=%s", key, URLEncoder.encode(paramsMap.get(key), "utf-8")));
                pos++;
            }
        } catch (Throwable e) {
            PushLog.inst().log("requestParams failed!" + Log.getStackTraceString(e));
        }
        return tempParams.toString();
    }

    IPushUnreadCallback fetchCallback;
    IPushSvcInterface.Stub iPushSvcInterface = new IPushSvcInterface.Stub() {
        @Override
        public void setDispacthUnreadMsg(IPushUnreadCallback callback) throws RemoteException {
            fetchCallback = callback;
        }
    };

}
