package com.yy.pushsvc.service.outline;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

import com.yy.pushsvc.aidl.IPushSvcInterface;
import com.yy.pushsvc.aidl.IPushUnreadCallback;
import com.yy.pushsvc.aidl.PushUnreadMsg;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.ActivityLifecycleHelper;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONArray;

public class FetchOutlineMsgLocalService extends Service {

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        final boolean isEnableFetchOutlineMsg = AppPushInfo.isEnableFetchOutlineMsg();
        final String pushTestIp               = AppPushInfo.getPushTestEnvIp();
        final int sdkVer                      = AppPushInfo.getSDKVersion();
        if (isEnableFetchOutlineMsg && sdkVer > Build.VERSION_CODES.LOLLIPOP_MR1) {
            Intent remote = new Intent(this, FetchOutlineMsgService.class);
            PushThreadPool.getPool().execute(new Runnable() {
                @Override
                public void run() {
                    Log.i("FetchLocalService=", "start bind time= " + System.currentTimeMillis() + ",isEnableFetchOutlineMsg=" + isEnableFetchOutlineMsg);
                    bindService(remote, conn, Context.BIND_AUTO_CREATE);
                    Log.i("FetchLocalService=", "end bind time= " + System.currentTimeMillis());
                }
            });
        }
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onDestroy() {
        try {
            unbindService(conn);
        } catch (Throwable t) {
            PushLog.inst().log("FetchOutlineMsgLocalService//unbindService//Throwable= " + t);
        }
    }

    IPushSvcInterface pushSvcInterface;
    ServiceConnection conn = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                pushSvcInterface = IPushSvcInterface.Stub.asInterface(service);
                pushSvcInterface.setDispacthUnreadMsg(unreadCallback);
            } catch (Throwable e) {
                PushLog.inst().log("FetchOutlineMsgLocalService setDispacthUnreadMsg failed!!" + Log.getStackTraceString(e));
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            try {
                pushSvcInterface = null;
            }catch (Throwable t){
                PushLog.inst().log("FetchOutlineMsgLocalService//onServiceDisconnected//Throwable= " + t);
            }
        }
    };

    IPushUnreadCallback.Stub unreadCallback = new IPushUnreadCallback.Stub() {

        @Override
        public void callback(PushUnreadMsg unreadMsg) throws RemoteException {
            PushLog.inst().log("FetchOutlineMsgLocalService callback " + unreadMsg);
            try {
                if (!TextUtils.isEmpty(unreadMsg.jsonString)) {
                    JSONArray array = new JSONArray(unreadMsg.jsonString);
                    if (array.length() > 0) {
                        KLogW.i(YYPushStatisticEvent.REPORT_QUIC_GET_UNREAD_MSG, unreadMsg.jsonString);
                        String type = unreadMsg.type;
                        PushThreadPool.getPool().execute(new Runnable() {
                            @Override
                            public void run() {
                                TokenStore.getInstance().dispacthUnreadMsg(getBaseContext(), type, "quic", array);
                            }
                        });
                    }
                }
            } catch (Throwable e) {
                PushLog.inst().log("IPushUnreadCallback parse JsonFailed!" + Log.getStackTraceString(e));
            }
        }

        @Override
        public boolean isActivityFrontGround() throws RemoteException {
            return ActivityLifecycleHelper.isForground();
        }
    };
}
