package com.yy.pushsvc.service;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.os.Build;

import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.YYPushConsts;

/**
 * Created by maxiaodong on 2019/2/20.
 * Description
 */

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
public class KeepLiveJobService extends JobService {
    private static final String TAG = "KeepLiveJobService";

    @Override
    public boolean onStartJob(JobParameters params) {
        PushThreadPool.getPool().execute(new Runnable() {
            @Override
            public void run() {
                try {
                    PushLog.inst().log(TAG + ".onStartJob upload to Hiido");
                    PushReporter.getInstance().init(getApplicationContext());
                    PushReporter.getInstance()
                            .newReportSucEvtToHiido(YYPushConsts.HIIDO_EXECUTE_JOBSCHEDULER_EVENT);
                } catch (Exception e) {
                    PushLog.inst().log(TAG + ".onStartJob exception:" + e);
                }
            }
        });
        return false;
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        return false;
    }
}
