package com.yy.pushsvc.service;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.Service;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;

import com.yy.pushsvc.util.PushLog;

/**
 * Created by maxiaodong on 2019/2/21.
 * Description
 */

public class ForegroundLiveService extends Service {
    private static final String TAG = "ForegroundLiveService";

    private static final int SERVICE_ID = 1;
    private volatile static int iconId = 0;

    @Override
    public void onCreate() {
        super.onCreate();
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        //判断版本
        if (Build.VERSION.SDK_INT < 18) { //Android4.3以下版本

            //将Service设置为前台服务，可以取消通知栏消息
            try {
                startForeground(SERVICE_ID, new Notification());
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else if (Build.VERSION.SDK_INT < 24) { //Android4.3 - 7.0之间
            //将Service设置为前台服务，可以取消通知栏消息
            try {
                int var = this.getPackageManager().getPackageInfo(this.getPackageName(), 0).applicationInfo.icon;
                if (var != 0) {
                    iconId = var;
                    Notification.Builder builder = new Notification.Builder(this);
                    builder.setSmallIcon(iconId);
                    startForeground(SERVICE_ID, builder.build());
                    startService(new Intent(this, InnerService.class));
                    PushLog.inst().log(TAG + ".onStartCommand start InnerService");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    public static class InnerService extends Service {
        private static final String TAG = "InnerService";

        @Override
        public IBinder onBind(Intent intent) {
            return null;
        }

        @TargetApi(Build.VERSION_CODES.JELLY_BEAN)
        @Override
        public int onStartCommand(Intent intent, int flags, int startId) {
            PushLog.inst().log(TAG + ".onStartCommand");
            try {
                if (iconId != 0) {
                    Notification.Builder builder = new Notification.Builder(this);
                    builder.setSmallIcon(iconId);
                    startForeground(SERVICE_ID, builder.build());
                    stopForeground(true); //移除通知栏消息
                    stopSelf();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return super.onStartCommand(intent, flags, startId);
        }
    }

}
