package com.yy.pushsvc.service;

import android.accounts.AbstractAccountAuthenticator;
import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;

public class AccountVerifyService extends Service {
    private AccountVerifyService.AccountAuthenticator mAuthenticator;

    private AccountVerifyService.AccountAuthenticator getAuthenticator() {
        if (mAuthenticator == null) {
            mAuthenticator = new AccountVerifyService.AccountAuthenticator(this);
        }
        return mAuthenticator;
    }

    @Override
    public void onCreate() {
        mAuthenticator = new AccountVerifyService.AccountAuthenticator(this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return getAuthenticator().getIBinder();
    }

    class AccountAuthenticator extends AbstractAccountAuthenticator {
        Context mContext;


        public AccountAuthenticator(Context context) {
            super(context);
            mContext = context;
        }

        @Override
        public Bundle editProperties(AccountAuthenticatorResponse response, String accountType) {
            return null;
        }

        @Override
        public Bundle addAccount(AccountAuthenticatorResponse response, String accountType, String authTokenType,
                                 String[] requiredFeatures, Bundle options) {
            try {
                if (mContext != null) {
                    Intent intent =
                            mContext.getApplicationContext().getPackageManager()
                                    .getLaunchIntentForPackage(mContext.getPackageName());
                    final Bundle bundle = new Bundle();
                    if (intent != null) {
                        intent.putExtra(AccountManager.KEY_ACCOUNT_AUTHENTICATOR_RESPONSE, response);
                        bundle.putParcelable(AccountManager.KEY_INTENT, intent);
                        return bundle;
                    }
                }
            } catch (Throwable e) {
                Log.e("AccountVerifyService", "addAccount: " + e);
            }
            return null;
        }

        @Override
        public Bundle confirmCredentials(AccountAuthenticatorResponse response, Account account, Bundle options) {
            return null;
        }

        @Override
        public Bundle getAuthToken(AccountAuthenticatorResponse response, Account account, String authTokenType,
                                   Bundle options) {
            return null;
        }

        @Override
        public String getAuthTokenLabel(String authTokenType) {
            return null;
        }

        @Override
        public Bundle updateCredentials(AccountAuthenticatorResponse response, Account account, String authTokenType,
                                        Bundle options) {
            return null;
        }

        @Override
        public Bundle hasFeatures(AccountAuthenticatorResponse response, Account account, String[] features) {
            return null;
        }
    }


}
