package com.yy.pushsvc.repush;

import android.content.Context;
import android.content.Intent;

import com.yy.hiidostatis.defs.obj.Property;
import com.yy.pushsvc.IMsgArriveCallback;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.facknotification.FackConst;
import com.yy.pushsvc.receiver.ScreenChangeReceiver;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;

import java.util.Calendar;
import java.util.Iterator;
import java.util.Stack;

/**
 * Created by GuanYuFeng
 * on 2020/9/2
 */
public class RepushManager implements ScreenChangeReceiver.OnScreenChangeListener {
    private static final String TAG = "RepushManager";
    private static final long ONE_HOUR = 1000 * 60 * 60;
    private static volatile RepushManager instance;
    private long prevTime;
    private boolean isLock;
    private Stack<RepushEntity> msgList = new Stack<RepushEntity>();

    public static RepushManager getInstance() {
        if (instance == null) {
            synchronized (RepushManager.class) {
                if (instance == null) {
                    instance = new RepushManager();
                }
            }
        }
        return instance;
    }

    public void init(Context ctx) {
        try {
            prevTime = getStartTime();
            ScreenChangeReceiver.getInstance(ctx).registerListener(this);
            isLock = !ScreenChangeReceiver.getInstance(ctx).isUnLock();
            PushLog.inst().log(TAG + ":init,prevTime=" + prevTime + ",isLock=" + isLock);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",init.erro= " + t);
        }
    }

    private RepushManager() {
    }

    public void addMsg(Intent intent) {
        try {
            PushLog.inst().log(TAG + ",addMsg()");
            if (isLock) {
                RepushEntity entity = new RepushEntity(System.currentTimeMillis(),
                        new String(intent.getByteArrayExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD)),
                        intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_PUSHID, 0),
                        intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_MSGID, 0),
                        intent);

                boolean isContain = false;
                Iterator<RepushEntity> it = msgList.iterator();
                while (it.hasNext()) {
                    RepushEntity re = it.next();
                    if (re.msgId == entity.msgId) {
                        isContain = true;
                    }
                }
                if (!isContain) {
                    msgList.add(entity);
                    PushLog.inst().log(TAG + ",addMsg,success,msgId = " + entity.msgId);
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",addMsg.erro= " + t);
        }
    }

    /**
     * 点击后要移除
     *
     * @param msgId
     */
    public void removeMsg(long msgId) {
        try {
            PushLog.inst().log(TAG + ",removeMsg,msgId=" + msgId);
            Iterator<RepushEntity> it = msgList.iterator();
            while (it.hasNext()) {
                RepushEntity re = it.next();
                if (re.msgId == msgId) {
                    msgList.remove(re);
                    return;
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",removeMsg.erro= " + t);
        }
    }

    public void removeAll(){
        try {
            PushLog.inst().log(TAG + ",removeAll" );
            msgList.clear();
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",removeMsg.erro= " + t);
        }
    }

    @Override
    public void onScreenOff() {
        isLock = true;
    }

    @Override
    public void onScreenOn() {
    }

    @Override
    public void onUnlockScreen() {
        try {
            isLock = false;
            long currentTime = System.currentTimeMillis();
            PushLog.inst().log(TAG + ",minuteTime = " + (currentTime - prevTime) / 1000 / 60);
            if (currentTime - prevTime > ONE_HOUR) {
                if (msgList.size() > 0) {
                    RepushEntity entity = msgList.pop();
                    if (entity != null) {
                        NotificationUtil.cancleNotification(YYPush.getInstace().getContext(),
                                NotificationUtil.createNotificationId(entity.msgId));

                        reportShow(entity.msgId, entity.payload, entity.pushId + "", "fcm");
                        YYPushMsgDispacher.getInstance().dispatch(entity.intent);
                        prevTime = currentTime;
                    }
                }
                removeAll();
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",onUnlockScreen.erro= " + t);
        }
    }

    private Long getStartTime() {
        Calendar todayStart = Calendar.getInstance();
        try {
            todayStart.set(Calendar.HOUR, 0);
            todayStart.set(Calendar.MINUTE, 0);
            todayStart.set(Calendar.SECOND, 0);
            todayStart.set(Calendar.MILLISECOND, 0);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",getStartTime.erro= " + t);
        }
        return todayStart.getTime().getTime();
    }

    private void reportShow(long msgId, String payload, String pushId, String channelType) {
        YYPushMsgDispacher.getInstance().onPushSDKNotificationReShow(msgId, payload.getBytes(),
                channelType, YYPush.getInstace().getContext());
        Property property = new Property();
        property.putString("msgid", String.valueOf(msgId));
        property.putString("pushid", String.valueOf(pushId));
        PushReporter.getInstance()
                .reportNotificationEventToHiido(
                        YYPushStatisticEvent.REPORT_SEND_REPUSH,
                        channelType, property);
    }

}
