package com.yy.pushsvc.report;

import android.content.Context;
import android.os.Message;

import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.receiver.YYPushKitErrorCodes;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushHttpUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by DW on 2017/11/5.
 * Description
 */

public class YYTokenUnBindHttp {
    private static final YYTokenUnBindHttp instance = new YYTokenUnBindHttp();

    public static YYTokenUnBindHttp getinstance() {
        return instance;
    }

    public static String tag = "YYTokenUnBindHttp";

    private String releaseUnBindUrl =
            YYPush.getInstace().getGrobalPrefix() + YYPush.httpsDNS + "/push/UnRegPushApp";
    private String testUnBindUrl = "https://%s:4080/push/UnRegPushApp";
    private String mUrl;
    private volatile Boolean isRunning = false;
    private volatile JSONObject mJsonData;

    private static int REPORT_SUCCESS = 0;
    private static int REPORT_FAILED = 1;
    private static int REPORT_TIMEOUT = 2;

    private static volatile String uploadFailReason;

    private volatile String mUnBindFailedAccount = "";

    private class ReportTask implements Runnable {
        private String reposeContent;
        private Context mContext;
        private JSONObject responseJsonObject;

        ReportTask(Context context) {
            mContext = context;
            uploadFailReason = "uploadInitState";
        }

        public void run() {
            TokenStore.getInstance().removeBindInfo();
            int tryCount = 5;
            Message msg = new Message();
            msg.what = REPORT_TIMEOUT;
            while (--tryCount > 0) {
                if (doSubmit()) {
                    msg.what = REPORT_SUCCESS;
                    msg.obj = reposeContent;
                    break;
                } else {
                    try {
                        msg.what = REPORT_FAILED;
                        Thread.sleep(5000 + (5 - tryCount) * 500);
                    } catch (InterruptedException ex) {
                        uploadFailReason = ex.getMessage();
                        PushLog.inst().log(tag + ".run sleep exception " + ex.getMessage());
                        break;
                    }
                }
            }

            //send msg to ui
            try {

                if (msg.what != REPORT_SUCCESS) {
                    saveUnBindFailedAccount(mJsonData.getString("account"));
                }
                //上报http解绑结果到海度
                PushReporter.getInstance()
                        .uploadHttpResponseToHiido(msg.what, YYPushConsts.HIIDO_APPUNBIND_RES_BY_HTTP_EVENT_ID,
                                uploadFailReason);

                if (msg.what == REPORT_SUCCESS) {
                    KLogW.i(YYPushStatisticEvent.REPORT_UNBIND_TOKEN_SUCCESS, mJsonData.getString("account"));
                } else {
                    KLogW.i(YYPushStatisticEvent.REPORT_UNBIND_TOKEN_FAILURE, mJsonData.getString("account"));
                }

                if (msg.what == REPORT_SUCCESS) {
                    responseJsonObject = new JSONObject(reposeContent);
                    mUnBindFailedAccount = "";
                }

                //通知app解绑结果
                int resCode = (responseJsonObject != null && responseJsonObject.has("resCode")) ?
                        responseJsonObject.getInt("resCode") : -1;
                TokenStore.getInstance()
                        .dispatchUnBindRes(mContext, mJsonData.getInt("appID"), mJsonData.getString("account"),
                                resCode);
            } catch (Exception e) {
                e.printStackTrace();
            }
            synchronized (isRunning) {
                isRunning = false;
            }
        }

        private boolean doSubmit() {
            try {
                if (TokenStore.getInstance().getTokenID() != null &&
                        !TokenStore.getInstance().getTokenID().equals("")) {
                    if (mJsonData.getString("tokenID") == null || mJsonData.getString("tokenID").equals("")) {
                        mJsonData.put("tokenID", TokenStore.getInstance().getTokenID());
                    }
                    PushLog.inst().log(tag + ".doSubmit yytoken is not null");
                } else {
                    PushLog.inst().log(tag + ".doSubmit yytoken is null");
                    uploadFailReason = "yyToken is null";
                    return false;
                }

                PushLog.inst().log(tag + ".doSubmit start to upload");

                PushHttpUtil.PushHttpResp resp =
                        PushHttpUtil.post(mUrl, mJsonData.toString(), !mUrl.equals(releaseUnBindUrl));

                int mStatusCode = resp.statusCode;
                uploadFailReason = "httpStatusCode:" + mStatusCode + ",reason:" + resp.reason;
                if (mStatusCode != 200) {
                    PushLog.inst().log(tag + ".doSubmit postfrom data error " + uploadFailReason);
                    return false;
                }

                reposeContent = resp.result;
                PushLog.inst().log(tag + ".doSubmit, mResult.content = " + reposeContent);
                if (reposeContent == null || reposeContent.isEmpty()) {
                    uploadFailReason = "reposeContent is null or empty statusCode:" + mStatusCode;
                    return false;
                }
                return true;
            } catch (Exception e) {
                e.printStackTrace();
                uploadFailReason = e.toString();
                PushLog.inst().log(tag + ".doSubmit, post failed " + e.toString());
            }
            return false;
        }
    }

    private YYTokenUnBindHttp() {
        mJsonData = new JSONObject();
    }

    private void setReportValue(Context context, String uid) {
        try {
            PushLog.inst().log("YYTokenUnBindHttp.setReportValue, uid:" + uid);
            mJsonData.put("appID", AppPushInfo.getYYKey(context));
            mJsonData.put("account", uid);
            mJsonData.put("ticket", AppPushInfo.getYYAuthTicket(context));
            mJsonData.put("term", "1");
            mJsonData.put("multiBind", false);
            mJsonData.put("tokenID", TokenStore.getInstance().getTokenID());
            mJsonData.put("deviceID", DeviceProxy.getHdid(context));
        } catch (JSONException ex) {
            PushLog.inst().log("YYTokenUnBindHttp.setReportValue set json data exception " + ex.getMessage());
        }
    }

    public void asyncSubmitFrom(Context context) {
        if (!isRunning) {
            PushThreadPool.getPool().execute(new ReportTask(context));
            isRunning = !isRunning;
        }
    }

    private void setRequstUrl() {
        String ip = AppPushInfo.getPushTestEnvIp();
        boolean bHasConfigIP = (ip != null && (StringUtil.isIp(ip) || StringUtil.isDomain(ip)));
        String url = releaseUnBindUrl;
        if (bHasConfigIP) {
            url = String.format(testUnBindUrl, ip);
            PushLog.inst().log("YYTokenUnBindHttp.setRequstUrl, connect to Test Environment:" + ip);
        } else {
            PushLog.inst().log("YYTokenUnBindHttp.setRequstUrl, connect to Production Environment");
        }
        mUrl = url;
    }

    public YYPushKitErrorCodes unBindAccount(Context context, String uid) {
        if (uid == null || uid.length() == 0 || "0".equals(uid)) {
            PushLog.inst().log("YYTokenUnBindHttp.unBindAccount, can't bind null account");
            return YYPushKitErrorCodes.PARAM_ERROR;
        }
        if (isRunning) {
            return YYPushKitErrorCodes.ON_PENDING;
        }

        setRequstUrl();

        setReportValue(context, uid);

        YYTokenUnBindHttp.getinstance().asyncSubmitFrom(context);
        PushLog.inst().log("YYTokenUnBindHttp.unBindAccount, call asyncSubmitFrom, " +
                "appid = " + AppPushInfo.getYYKey(context) + ", account = " + uid);

        return YYPushKitErrorCodes.SUCCESS;
    }

    public void saveUnBindFailedAccount(String account) {
        mUnBindFailedAccount = account;
    }

    public String getUnBindFailedAccount() {
        return mUnBindFailedAccount;
    }

}
