package com.yy.pushsvc.report;

import android.content.Context;
import android.os.Message;

import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.util.PushHttpUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Administrator on 2017/11/2.
 */
public class YYTokenLoginHttp {
    private static String TAG = "YYTokenLoginHttp";
    private static final YYTokenLoginHttp instance = new YYTokenLoginHttp();

    public static YYTokenLoginHttp getinstance() {
        return instance;
    }

    private String releaseLoginUrl =
            YYPush.getInstace().getGrobalPrefix() + YYPush.httpsDNS + "/push" +
                    "/PushLogin";
    private String testLoginUrl = "https://%s:4080/push/PushLogin";
    private String mUrl;
    private volatile boolean isRunning = false;
    private volatile JSONObject mJsonData;

    private static int REPORT_SUCCESS = 0;
    private static int REPORT_FAILED = 1;
    private static int REPORT_TIMEOUT = 2;

    private String reposeContent;
    private static volatile String uploadFailReason;

    private YYTokenLoginHttp() {
        mJsonData = new JSONObject();
    }

    private void setReportValue(Context context) {
        try {

            PushLog.inst().log("YYTokenLoginHttp.setReportValue");

            JSONObject deviceInfo = new JSONObject();
            deviceInfo.put("brand", android.os.Build.BRAND);
            deviceInfo.put("model", android.os.Build.MODEL);
            deviceInfo.put("android_sdk_ver", android.os.Build.VERSION.SDK);
            deviceInfo.put("sys_ver", android.os.Build.VERSION.RELEASE);
            deviceInfo.put("app_ver", AppPushInfo.getAppVersion());

            mJsonData.put("appid", AppPushInfo.getYYKey(context));
            mJsonData.put("sdkVer", AppPushInfo.getYYPushVersionNo());
            mJsonData.put("verify", "");
            mJsonData.put("hdid", DeviceProxy.getHdid(context));
            mJsonData.put("macAddr", AppPushInfo.getMac(context));
            mJsonData.put("cliType", 0);
            mJsonData.put("tokenID", TokenStore.getInstance().getTokenID()); //YY Token
            mJsonData.put("deviceID", DeviceProxy.getHdid(context));
            mJsonData.put("thirdtokenMask", String.valueOf(TokenStore.getInstance().getTokenMask()));
            mJsonData.put("deviceInfo", deviceInfo);
        } catch (JSONException ex) {
            PushLog.inst().log("YYTokenLoginHttp.setReportValue set json data exception " + ex.getMessage());
        }
    }

    private boolean doSubmit() {
        try {
            PushLog.inst().log(TAG + ".doSubmit start to upload");

            PushHttpUtil.PushHttpResp resp =
                    PushHttpUtil.post(mUrl, mJsonData.toString(), !mUrl.equals(releaseLoginUrl));

            int mStatusCode = resp.statusCode;
            uploadFailReason = "httpStatusCode:" + mStatusCode + ", reason:" + resp.reason;
            if (mStatusCode != 200) {
                PushLog.inst().log(TAG + ".doSubmit postfrom data error " + mStatusCode);
                return false;
            }
            reposeContent = resp.result;
            PushLog.inst().log(TAG + ".doSubmit, mResult.content = " + reposeContent);
            if (reposeContent == null || reposeContent.isEmpty()) {
                uploadFailReason = "reposeContent is null or empty statusCode:" + mStatusCode;
                return false;
            } else {
                JSONObject jsonObject = new JSONObject(reposeContent);
                if (jsonObject.has("resCode")) {
                    int resCode = jsonObject.getInt("resCode");
                    if (resCode != 200) {
                        PushLog.inst().log(TAG + ".doSubmit post from push server resCode:" + resCode);
                        uploadFailReason = "push server return resCode:" + resCode;
                        if (resCode == 401) {
                            PushLog.inst()
                                    .log(TAG + ".doSubmit post from data errorcode is 401, remove yyToken from db");
                            TokenStore.getInstance().removeDeviceinfo();
                        }
                        return false;
                    }
                }
            }
            return true;
        } catch (Exception e) {
            uploadFailReason = e.toString();
            e.printStackTrace();
            PushLog.inst().log(TAG + ".doSubmit, post failed " + e.toString());
        }
        return false;
    }

    public void syncSubmitFrom(Context context) {
        if (!isRunning) {
            isRunning = true;
            uploadFailReason = "uploadInitState";
            int tryCount = 5;
            Message msg = new Message();
            msg.what = REPORT_TIMEOUT;
            while (--tryCount > 0) {
                if (doSubmit()) {
                    msg.what = REPORT_SUCCESS;
                    msg.obj = reposeContent;
                    break;
                } else {
                    try {
                        msg.what = REPORT_FAILED;
                        Thread.sleep(5000 + (5 - tryCount) * 500);
                    } catch (InterruptedException ex) {
                        PushLog.inst().log(TAG + ".run sleep exception " + ex.getMessage());
                        break;
                    }
                }
            }

            isRunning = false;

            //send msg to ui
            try {
                JSONObject jsonData;
                if (reposeContent == null) {
                    jsonData = mJsonData;
                } else {
                    jsonData = new JSONObject(reposeContent);
                }
                if (msg.what == REPORT_SUCCESS) {

                    if (YYSetTagHttp.getInstance().getPostFailTag() != null) {
                        YYSetTagHttp.getInstance()
                                .setTag(context.getApplicationContext(), YYSetTagHttp.getInstance().getPostFailTag(),
                                        YYSetTagHttp.getInstance().getAppendValue());
                    }

                    if (YYDelTagHttp.getInstance().getPostFailTag() != null) {
                        YYDelTagHttp.getInstance()
                                .delTag(context.getApplicationContext(), YYDelTagHttp.getInstance().getPostFailTag());
                    }


                    //通知到YYPush注册结果
                    TokenStore.getInstance()
                            .dispatchToken(context, ThirdPartyPushType.PUSH_TYPE_YYPUSH, jsonData.getString("tokenID"));

                    if (jsonData.has("tokenID") && !TokenStore.getInstance().getTokenID().equals(jsonData.getString(
                            "tokenID"))) {
                        TokenStore.getInstance().saveYYTokenToDb(context, jsonData.getString("tokenID"));
                    } else {
                        PushLog.inst().log(TAG + ".syncSubmitFrom do not need save yyToken");
                    }
                }

                //上报http登录yypush结果到海度
                PushReporter.getInstance()
                        .uploadHttpResponseToHiido(msg.what, YYPushConsts.HIIDO_YY_TOKEN_RES_BY_HTTP_EVENT_ID,
                                uploadFailReason);

                if (jsonData.has("ctrlPolicy")) {
                    JSONObject jsonCtrlPolicy = jsonData.getJSONObject("ctrlPolicy");
                    if (jsonCtrlPolicy.has(YYPushConsts.JIGUANG_PUSH_SWITCH)) {
                        String jiGuangPushSwitch = String.valueOf(jsonCtrlPolicy.getBoolean("JiGuangPushSwitch"));
                        PushLog.inst().log(TAG + ".syncSubmitFrom JiGuangPushSwitch:" + jiGuangPushSwitch);
                        TokenStore.getInstance().saveJiGuangPushSwitchToDb(context, jiGuangPushSwitch);
                    } else {
                        PushLog.inst().log(TAG + ".syncSubmitFrom jsonData ctrlPolicy has no JiGuangPushSwitch");
                    }
                } else {
                    PushLog.inst().log(TAG + ".syncSubmitFrom jsonData  has no ctrlPolicy");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void registerYYPush(final Context context) {
        if (isRunning) {
            PushLog.inst().log(TAG + ".registerYYPush, has already registerYYPush.");
            return;
        }
        PushLog.inst().log(TAG + ".registerYYPush, begin to registerYYPush.");

        setRequstUrl();

        setReportValue(context);

        PushLog.inst()
                .log("YYTokenLoginHttp.registerYYPush, call syncSubmitFrom, appid = " + AppPushInfo.getYYKey(context));

        PushThreadPool.getPool().execute(new Runnable() {
            @Override
            public void run() {
                YYTokenLoginHttp.getinstance().syncSubmitFrom(context);
            }
        });
    }

    private void setRequstUrl() {
        String ip = AppPushInfo.getPushTestEnvIp();
        boolean bHasConfigIP = (ip != null && (StringUtil.isIp(ip) || StringUtil.isDomain(ip)));
        String url = releaseLoginUrl;
        if (bHasConfigIP) {
            url = String.format(testLoginUrl, ip);
            PushLog.inst().log(TAG + ".setRequstUrl, login to Test Environment:" + ip);
        } else {
            PushLog.inst().log(TAG + ".setRequstUrl, login to Production Environment");
        }
        mUrl = url;
    }
}
