package com.yy.pushsvc.report;

import android.content.Context;
import android.os.Message;
import android.text.TextUtils;

import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.receiver.YYPushKitErrorCodes;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.PushDBHelper;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushHttpUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Administrator on 2017/11/2.
 */
public class YYTokenBindHttp {
    private static final YYTokenBindHttp instance = new YYTokenBindHttp();

    public static YYTokenBindHttp getinstance() {
        return instance;
    }

    public static String tag = "YYTokenBindHttp";
    private String releaseBindUrl =
            YYPush.getInstace().getGrobalPrefix() + YYPush.httpsDNS + "/push/RegPushApp";
    private String testBindUrl = "https://%s:4080/push/RegPushApp";
    private String mUrl;
    private Boolean isRunning = false;
    private volatile JSONObject mJsonData;

    private static int REPORT_SUCCESS = 0;
    private static int REPORT_FAILED = 1;
    private static int REPORT_TIMEOUT = 2;
    private static volatile String uploadFailReason;
    private volatile String mBindFailedAccount = "";

    private class ReportTask implements Runnable {
        private JSONObject responseJsonObject;
        private String reposeContent;
        private Context mContext;
        private PushDBHelper.PushAccountInfo mAccountInfo = new PushDBHelper.PushAccountInfo();

        ReportTask(Context context, PushDBHelper.PushAccountInfo saveInfo) {
            mContext = context;
            mAccountInfo = saveInfo;
            uploadFailReason = "uploadInitState";
        }

        public void run() {
            TokenStore.getInstance().saveBindInfo(mAccountInfo);
            int tryCount = 5;
            Message msg = new Message();
            msg.what = REPORT_TIMEOUT;
            while (--tryCount > 0) {
                if (doSubmit()) {

                    msg.what = REPORT_SUCCESS;
                    msg.obj = reposeContent;
                    break;
                } else {
                    try {
                        msg.what = REPORT_FAILED;
                        Thread.sleep(5000 + (5 - tryCount) * 500);
                    } catch (InterruptedException ex) {
                        uploadFailReason = ex.getMessage();
                        PushLog.inst().log(tag + ".run sleep exception " + ex.getMessage());
                        break;
                    }
                }
            }

            //send msg to ui
            try {
                if (msg.what != REPORT_SUCCESS) {
                    saveBindFailedAccount(mJsonData.getString("account"));
                }
                //上报http绑定结果到海度
                PushReporter.getInstance()
                        .uploadHttpResponseToHiido(msg.what, YYPushConsts.HIIDO_APPBIND_RES_BY_HTTP_EVENT_ID,
                                uploadFailReason);
                if (msg.what == REPORT_SUCCESS) {
                    KLogW.i(YYPushStatisticEvent.REPORT_BIND_TOKEN_SUCCESS, mJsonData.getString("account"));
                } else {
                    KLogW.i(YYPushStatisticEvent.REPORT_BIND_TOKEN_FAILURE, mJsonData.getString("account"));
                }


                if (msg.what == REPORT_SUCCESS) {
                    responseJsonObject = new JSONObject(reposeContent);
                    mBindFailedAccount = "";
                }

                //通知到app绑定结果
                int resCode = (responseJsonObject != null && responseJsonObject.has("resCode")) ?
                        responseJsonObject.getInt("resCode") : -1;
                if (responseJsonObject != null && responseJsonObject.has("tokenID")) {
                    String token = responseJsonObject.getString("tokenID");
                    if (!TextUtils.isEmpty(token) && !token.equals(TokenStore.getInstance().getTokenID())) {
                        TokenStore.getInstance().saveYYTokenToDb(mContext, token);
                    } else {
                        PushLog.inst().log("YYTokenBindHttp.run has already got yyToken do not need save yyToken");
                    }
                }
                TokenStore.getInstance()
                        .dispatchBindRes(mContext, mJsonData.getInt("appID"), mJsonData.getString("account"),
                                resCode);

            } catch (Exception e) {
                e.printStackTrace();
            }

            synchronized (isRunning) {
                isRunning = false;
            }
        }

        private boolean doSubmit() {
            try {
                if (!isTokenValid()) {
                    return false;
                }

                PushLog.inst().log(tag + ".doSubmit start to upload");

                PushHttpUtil.PushHttpResp resp =
                        PushHttpUtil.post(mUrl, mJsonData.toString(), !mUrl.equals(releaseBindUrl));

                int mStatusCode = resp.statusCode;
                uploadFailReason = "httpStatusCode:" + mStatusCode + ", reason:" + resp.reason;
                if (mStatusCode != 200) {
                    PushLog.inst().log(tag + ".doSubmit postfrom data error " + uploadFailReason);
                    return false;
                }

                reposeContent = resp.result;
                PushLog.inst().log(tag + ".doSubmit, mResult.content = " + reposeContent);
                if (reposeContent == null || reposeContent.isEmpty()) {
                    uploadFailReason = "reposeContent is null or empty statusCode:" + mStatusCode;
                    return false;
                }
                return true;
            } catch (Exception e) {
                uploadFailReason = e.toString();
                e.printStackTrace();
                PushLog.inst().log(tag + ".doSubmit, post failed " + e.toString());
            }

            return false;
        }
    }

    private YYTokenBindHttp() {
        mJsonData = new JSONObject();
    }

    public void setReportValue(Context context, String account, String thirdTokenSys, String thirdTokenNonSys) {
        try {
            PushLog.inst().log("YYTokenBindHttp.setReportValue, uid:" + account);
            mJsonData.put("appID", AppPushInfo.getYYKey(context));
            mJsonData.put("account", account);
            mJsonData.put("ticket", AppPushInfo.getYYAuthTicket(context));
            mJsonData.put("sdkVer", String.valueOf(AppPushInfo.getYYPushVersionNo()));
            mJsonData.put("appVer", AppPushInfo.getAppVersion());
            mJsonData.put("term", "1");
            mJsonData.put("multiBind", false);
            mJsonData.put("tokenID", TokenStore.getInstance().getTokenID()); //YY Token
            mJsonData.put("deviceID", DeviceProxy.getHdid(context));
            mJsonData.put("hdid", DeviceProxy.getHdid(context));
            mJsonData.put("macAddr", TokenStore.getInstance().getMacAddr());
            mJsonData.put("thirdtokenSys", thirdTokenSys); //小米或华为Token
            mJsonData.put("thirdtokenNonSys", thirdTokenNonSys); //第三方Token
            mJsonData.put("thirdtokenMask", String.valueOf(TokenStore.getInstance().getTokenMask()));
        } catch (JSONException ex) {
            PushLog.inst().log("YYTokenBindHttp.setReportValue set json data exception " + ex.getMessage());
        }
    }

    public void asyncSubmitFrom(Context context, PushDBHelper.PushAccountInfo info) {
        synchronized (isRunning) {
            if (!isRunning) {
                PushThreadPool.getPool().execute(new ReportTask(context, info));
                isRunning = !isRunning;
            }
        }
    }

    public YYPushKitErrorCodes bindAccount(Context context, String uid) {

        synchronized (isRunning) {
            if (isRunning) {
                return YYPushKitErrorCodes.ON_PENDING;
            }
        }

        String thirdPartyToken = TokenStore.getInstance().getSysToken();
        String fcmToken = TokenStore.getInstance().getFcmToken();

        YYTokenBindHttp.getinstance().setRequstUrl();

        setReportValue(context, uid, thirdPartyToken, fcmToken);

        asyncSubmitFrom(context, getBindInfo(context, uid, thirdPartyToken, fcmToken));
        PushLog.inst().log("YYTokenBindHttp.bindAccount, call asyncSubmitFrom," +
                " appid = " + AppPushInfo.getYYKey(context) + ", account = " + uid);

        return YYPushKitErrorCodes.SUCCESS;
    }

    private void setRequstUrl() {
        String ip = AppPushInfo.getPushTestEnvIp();
        boolean bHasConfigIP = (ip != null && (StringUtil.isIp(ip) || StringUtil.isDomain(ip)));
        String url = releaseBindUrl;
        if (bHasConfigIP) {
            url = String.format(testBindUrl, ip);
            PushLog.inst().log("YYTokenBindHttp.setRequstUrl, connect to Test Environment:" + ip);
        } else {
            PushLog.inst().log("YYTokenBindHttp.setRequstUrl, connect to Production Environment");
        }
        mUrl = url;
    }

    public void saveBindFailedAccount(String account) {
        mBindFailedAccount = account;
    }

    public String getBindFailedAccount() {
        return mBindFailedAccount;
    }

    private boolean isTokenValid() {
        try {
            if (TokenStore.getInstance().getTokenID() != null && !TokenStore.getInstance().getTokenID().equals("")) {
                if (mJsonData.getString("tokenID") == null || mJsonData.getString("tokenID").equals("")) {
                    mJsonData.put("tokenID", TokenStore.getInstance().getTokenID());
                }
                PushLog.inst().log(tag + ".isTokenValid yytoken is not null");
            } else {
                PushLog.inst().log(tag + ".isTokenValid yytoken is null");
            }

            if (!TokenStore.getInstance().getFcmToken().equals("")) {
                if (mJsonData.getString("thirdtokenNonSys").equals("")) {
                    mJsonData.put("thirdtokenNonSys",
                            TokenStore.getInstance().getFcmToken());
                }
                PushLog.inst().log(tag + ".isTokenValid fcmToken is not empty");
                return true;
            } else {
                if (!TokenStore.getInstance().getSysToken().equals("")) {
                    if (mJsonData.getString("thirdtokenSys").equals("")) {
                        mJsonData.put("thirdtokenSys",
                                TokenStore.getInstance().getSysToken());
                    }
                    PushLog.inst().log(tag + ".isTokenValid fcm token is empty and sysToken is not empty");
                    return true;
                } else {
                    PushLog.inst().log(tag + ".isTokenValid fcm token and sysToken are empty");
                    uploadFailReason = "sysToken and fcmToken are empty";
                    return false;
                }
            }
        } catch (Exception e) {
            PushLog.inst().log(tag + ".isTokenValid exception:" + e.toString());
            return false;
        }
    }

    private PushDBHelper.PushAccountInfo getBindInfo(Context context, String uid, String thirdTokenSys,
                                                     String thirdTokenNonSys) {
        PushDBHelper.PushAccountInfo bindInfo = new PushDBHelper.PushAccountInfo();
        bindInfo.mAppID = AppPushInfo.getYYKey(context);
        bindInfo.mAppver = AppPushInfo.getAppVersion();
        bindInfo.mTicket = AppPushInfo.getYYAuthTicket(context).getBytes();
        bindInfo.mMulti = false;
        bindInfo.mSysToken = thirdTokenSys.getBytes();
        bindInfo.mThirdToken = thirdTokenNonSys.getBytes();
        bindInfo.mAccount = uid;
        return bindInfo;
    }

}
