package com.yy.pushsvc.report;

import android.content.Context;
import android.os.Message;

import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.receiver.YYPushKitErrorCodes;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushHttpUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by DW on 2018/5/18.
 * Description
 */

public class YYSetTagHttp {
    private static final String TAG = "YYSetTagHttp";
    private static final YYSetTagHttp instance = new YYSetTagHttp();
    private Boolean isRunning = false;
    private String releaseSetTagUrl =
            YYPush.getInstace().getGrobalPrefix() + YYPush.httpsDNS + "/push/SetTag";
    private String testSetTagUrl = "https://%s:4080/push/SetTag";
    private static String m_url;
    private volatile JSONObject mJsonData;
    private static final int REPORT_SUCCESS = 0;
    private static final int REPORT_FAILED = 1;
    private static final int REPORT_TIMEOUT = 2;
    private static volatile JSONArray postTag = null;
    private static boolean mIsAppendTag = false;
    private static volatile String uploadFailReason;

    public static YYSetTagHttp getInstance() {
        return instance;
    }

    private class ReportTask implements Runnable {
        private String responseContent;
        private Context mContext;
        private JSONObject responseJsonObject;

        private ReportTask(Context context) {
            mContext = context;
            uploadFailReason = "uploadInitState";
        }

        @Override
        public void run() {
            int tryCount = 5;
            Message msg = new Message();
            msg.what = REPORT_TIMEOUT;
            while (--tryCount > 0) {
                if (doSubmit()) {
                    msg.what = REPORT_SUCCESS;
                    msg.obj = responseContent;
                    break;
                } else {
                    try {
                        msg.what = REPORT_FAILED;
                        Thread.sleep(5000 + (5 - tryCount) * 500);
                    } catch (InterruptedException e) {
                        uploadFailReason = e.getMessage();
                        PushLog.inst().log(TAG + ".run sleep exception " + e.getMessage());
                        break;
                    }
                }
            }
            //send msg to ui
            try {
                if (TokenStore.getInstance().getTokenID() == null || TokenStore.getInstance().getTokenID().equals("")) {
                    if (mJsonData.has("tag")) {
                        postTag = mJsonData.getJSONArray("tag");
                    }
                }

                //上报http设置标签结果到海度
                PushReporter.getInstance()
                        .uploadHttpResponseToHiido(msg.what, YYPushConsts.HIIDO_SET_TAG_RES_BY_HTTP_EVENT_ID,
                                uploadFailReason);

                if (msg.what == REPORT_SUCCESS) {
                    responseJsonObject = new JSONObject(responseContent);
                    postTag = null;
                }

                //通知app端设置标签结果
                int resCode = (responseJsonObject != null && responseJsonObject.has("resCode")) ?
                        responseJsonObject.getInt("resCode") : -1;
                TokenStore.getInstance().dispatchSetTagRes(mContext, mJsonData.getInt("appID"), resCode);
            } catch (Exception e) {
                e.printStackTrace();
            }

            synchronized (isRunning) {
                isRunning = false;
            }
        }

        private boolean doSubmit() {
            try {
                if (TokenStore.getInstance().getTokenID() != null &&
                        !TokenStore.getInstance().getTokenID().equals("")) {
                    if (mJsonData.getString("tokenID") == null || mJsonData.getString("tokenID").equals("")) {
                        mJsonData.put("tokenID", TokenStore.getInstance().getTokenID());
                    }
                    PushLog.inst().log(TAG + ".doSubmit yytoken is not null");
                } else {
                    PushLog.inst().log(TAG + ".doSubmit yytoken is null");
                    uploadFailReason = "yyToken is null";
                    return false;
                }

                PushLog.inst().log(TAG + ".doSubmit start to upload");

                PushHttpUtil.PushHttpResp resp =
                        PushHttpUtil.post(m_url, mJsonData.toString(), !m_url.equals(releaseSetTagUrl));

                int mStatusCode = resp.statusCode;
                uploadFailReason = "httpStatusCode:" + mStatusCode + ", reason:" + resp.reason;
                if (mStatusCode != 200) {
                    PushLog.inst().log(TAG + ".doSubmit post from data error" + uploadFailReason);
                    return false;
                }
                responseContent = resp.result;
                PushLog.inst().log(TAG + ".doSubmit mResult content:" + responseContent);
                if (responseContent == null || responseContent.isEmpty()) {
                    uploadFailReason = "reposeContent is null or empty statusCode:" + mStatusCode;
                    return false;
                }
                return true;
            } catch (Exception e) {
                uploadFailReason = e.toString();
                PushLog.inst().log(TAG + ".doSubmit post failed exception:" + e);
            }
            return false;
        }

    }

    private YYSetTagHttp() {
        mJsonData = new JSONObject();
    }

    public YYPushKitErrorCodes setTag(Context context, JSONArray tag, boolean append) {
        PushLog.inst().log(TAG + ".setTag" + ", append:" + append);
        if (context == null || tag == null || tag.length() == 0) {
            PushLog.inst().log(TAG + ".setTag, param error!");
            return YYPushKitErrorCodes.PARAM_ERROR;
        }
        synchronized (isRunning) {
            if (isRunning) {
                return YYPushKitErrorCodes.ON_PENDING;
            }
        }
        mIsAppendTag = append;

        setRequestUrl();

        setReportValue(context, tag, append);

        asynSubmit(context);
        return YYPushKitErrorCodes.SUCCESS;
    }

    private void setRequestUrl() {
        String ip = AppPushInfo.getPushTestEnvIp();
        boolean bHasConfigIp = (ip != null && (StringUtil.isIp(ip) || StringUtil.isDomain(ip)));
        String url = releaseSetTagUrl;
        if (bHasConfigIp) {
            url = String.format(testSetTagUrl, ip);
            PushLog.inst().log(TAG + ".setRequestUrl connect to Test Environment:" + ip);
        } else {
            PushLog.inst().log(TAG + ".setRequestUrl connect to Production Environment");
        }
        m_url = url;
    }

    private void asynSubmit(Context context) {
        synchronized (isRunning) {
            if (!isRunning) {
                PushThreadPool.getPool().execute(new ReportTask(context));
                isRunning = !isRunning;
            }
        }
    }

    public JSONArray getPostFailTag() {
        return postTag;
    }

    public boolean getAppendValue() {
        return mIsAppendTag;
    }

    private void setReportValue(Context context, JSONArray tag, boolean append) {
        try {
            PushLog.inst().log("YYSetTagHttp.setReportValue append = " + append);
            mJsonData.put("tokenID", TokenStore.getInstance().getTokenID());
            mJsonData.put("appID", AppPushInfo.getYYKey(context));
            mJsonData.put("tag", tag);
            mJsonData.put("ticket", AppPushInfo.getYYAuthTicket(context));
            mJsonData.put("term", 1);
            mJsonData.put("app_ver", AppPushInfo.getAppVersion());
            mJsonData.put("append", append);

        } catch (JSONException e) {
            PushLog.inst().log("YYSetTagHttp.setReportValue exception:" + e.getMessage());
            e.printStackTrace();
        }
    }
}
