package com.yy.pushsvc.report;

import android.content.Context;

import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushHttpUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.TimerTask;

/**
 * Created by DW on 2018/6/1.
 * Description
 */

public class YYPushReportStatisticsHttp {
    private static final String TAG = "YYPushReportStatisticsHttp";
    private volatile JSONObject mJsonData;

    private enum ReportState {
        REPORT_INITIATE,
        REPORT_PROCESSING,
        REPORT_SUCCESS,
        REPORT_FAILED,
        REPORT_TIMEOUT
    }

    private volatile static ReportState m_reportState = ReportState.REPORT_INITIATE;
    private static String m_url = "";
    public String releaseReporStatisticstUrl =
            YYPush.getInstace().getGrobalPrefix() + YYPush.httpsDNS + "/push/ReportStatistics";
    public String testReportStatisticsUrl = "https://%s:4080/push/ReportStatistics";
    private volatile String responseContent;
    private static JSONObject m_responseContent;
    private Context mContext;
    private static YYPushReportStatisticsHttp instance = new YYPushReportStatisticsHttp();

    public static YYPushReportStatisticsHttp getInstance() {
        return instance;
    }

    private YYPushReportStatisticsHttp() {
        mJsonData = new JSONObject();
    }

    class ReportTask extends TimerTask {
        private int tryCount = 5;

        @Override
        public void run() {
            m_reportState = ReportState.REPORT_PROCESSING;
            while (--tryCount > 0) {
                if (doSubmit()) {
                    m_reportState = ReportState.REPORT_SUCCESS;
                    break;
                } else {
                    m_reportState = ReportState.REPORT_FAILED;
                    try {
                        Thread.sleep(3000);
                    } catch (InterruptedException e) {
                        PushLog.inst().log("YYPushReportStatisticsHttp.ReportTask run exception:" + e);
                    }
                }
            }
            tryCount = 3;
            if (m_reportState == ReportState.REPORT_SUCCESS) {
                m_reportState = ReportState.REPORT_INITIATE;
                PushLog.inst().log("YYPushReportStatisticsHttp.ReportTask run report success");
                JSONArray jsonArray = TokenStore.getInstance().getUnReportedStasticsFromDb(mContext);
                if (jsonArray != null) {
                    YYPushReportStatisticsHttp.getInstance().doReportStatisticsByHttp(mContext, jsonArray);
                }
            } else if (m_reportState == ReportState.REPORT_FAILED) {
                m_reportState = ReportState.REPORT_INITIATE;
                PushLog.inst().log("YYPushReportStatisticsHttp.ReportTask run report failed");
            } else {
                m_reportState = ReportState.REPORT_INITIATE;
                PushLog.inst().log("YYPushReportStatisticsHttp.ReportTask run report timeout");
            }
        }
    }

    private boolean doSubmit() {
        try {
            if (TokenStore.getInstance().getTokenID() != null && !TokenStore.getInstance().getTokenID().equals("")) {
                if (mJsonData.get("tokenID") == null || mJsonData.get("tokenID").equals("")) {
                    mJsonData.put("tokenID", TokenStore.getInstance().getTokenID());
                }
                PushLog.inst().log(TAG + ".doSubmit yytoken is not null");
            } else {
                PushLog.inst().log(TAG + ".doSubmit yytoken is null");
                return false;
            }

            PushLog.inst().log(TAG + ".doSubmit start to upload");

            PushHttpUtil.PushHttpResp resp =
                    PushHttpUtil.post(m_url, mJsonData.toString(), !m_url.equals(releaseReporStatisticstUrl));

            int statusCode = resp.statusCode;
            if (statusCode >= 400) {
                PushLog.inst().log("YYPushReportStatisticsHttp.soSubmit statusCode :" + statusCode);
                return false;
            }

            responseContent = resp.result;
            PushLog.inst().log("YYPushReportStatisticsHttp.doSubmit responContent:" + responseContent);
            if (responseContent == null || responseContent.isEmpty()) {
                return false;
            }
            m_responseContent = new JSONObject(responseContent);
            if (m_responseContent.has("pushMsgStat")) {
                JSONArray jsonArray = new JSONArray(m_responseContent.getString("pushMsgStat"));
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = (JSONObject) jsonArray.get(i);
                    if (jsonObject.has("msgID") && jsonObject.has("stat")) {
                        TokenStore.getInstance().removeReportedStatistics(mContext, jsonObject.getLong("msgID"),
                                jsonObject.getInt("stat"));
                    }
                }
            } else {
                if (m_responseContent.has("resCode")) {
                    int resCode = m_responseContent.getInt("resCode");
                    if (resCode != 200) {
                        PushLog.inst().log(TAG + ".doSubmit upload fail resCode:" + resCode);
                        return false;
                    } else {
                        PushLog.inst().log(TAG + ".doSubmit upload succeed");
                    }
                } else {
                    return false;
                }
            }
            return true;
        } catch (Exception e) {
            PushLog.inst().log("YYPushReportStatisticsHttp.doSubmit exception:" + e);
        }
        return false;
    }

    public synchronized void doReportStatisticsByHttp(Context context, JSONArray jsonArray) {
        PushLog.inst().log("YYPushReportStatisticsHttp.doReportStatisticsByHttp jsonarray:" + jsonArray);
        if (m_reportState != ReportState.REPORT_INITIATE) {
            PushLog.inst()
                    .log("YYPushReportStatisticsHttp.doReportStatisticsByHttp has not finish upload, reportstate:" +
                            m_reportState);
            return;
        }

        setRequestUrl();

        mContext = context;

        setReportValue(context, jsonArray);
    }

    private void setReportValue(Context context, JSONArray jsonArray) {
        try {
            PushLog.inst().log("YYPushReportStatisticsHttp.setReportValue");
            mJsonData.put("appID", AppPushInfo.getYYKey(context));
            mJsonData.put("tokenID", TokenStore.getInstance().getTokenID());
            mJsonData.put("ticket", AppPushInfo.getYYAuthTicket(context));
            mJsonData.put("term", 1);
            mJsonData.put("pushMsgStat", jsonArray);
            PushThreadPool.getPool().execute(new ReportTask(), 0);
        } catch (JSONException e) {
            e.printStackTrace();
            PushLog.inst().log("YYPushReportStatisticsHttp.setReportValue exception:" + e.getMessage());
        }
    }

    private void setRequestUrl() {
        if (m_url.equals("")) {
            String ip = AppPushInfo.getPushTestEnvIp();
            boolean bHasConfigIP = (ip != null && (StringUtil.isIp(ip) || StringUtil.isDomain(ip)));
            m_url = releaseReporStatisticstUrl;
            if (bHasConfigIP) {
                m_url = String.format(testReportStatisticsUrl, ip);
                PushLog.inst().log("YYPushReportStatisticsHttp.setRequestUrl, connect to Test Environment:" + ip);
            } else {
                PushLog.inst().log("YYPushReportStatisticsHttp.setRequestUrl, connect to Production Environment");
            }
        }
    }

}
