package com.yy.pushsvc.report;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.util.PushHttpUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.SystemUtil;
import com.yy.pushsvc.util.TokenUploadState;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by DW on 2018/5/23.
 * Description
 */

public class YYPushDeviceInfoHttp {
    private static final String TAG = "YYPushDeviceInfoHttp";
    private ConcurrentHashMap<Integer, TokenUploadState> mThirdPartyTokenMap = new ConcurrentHashMap<>();
    private ConcurrentHashMap<String, Integer> mKeymap = new ConcurrentHashMap<>();
    private static YYPushDeviceInfoHttp instance = new YYPushDeviceInfoHttp();
    private String releaseDeviceinfoUrl =
            YYPush.getInstace().getGrobalPrefix() + YYPush.httpsDNS + "/push/ReportThirdToken";
    private String testDeviceinfoUrl = "https://%s:4080/push/ReportThirdToken";
    private static String m_url;
    private volatile JSONObject mJsonData;
    private static final int REPORT_SUCCESS = 0;
    private static final int REPORT_FAILED = 1;
    private static final int REPORT_TIMEOUT = 2;
    private static volatile boolean isUploadDeviceInfo = false;
    private static volatile Context mContext = null;

    public static YYPushDeviceInfoHttp getInstance() {
        return instance;
    }

    private YYPushDeviceInfoHttp() {
        mKeymap.put(ThirdPartyPushType.PUSH_TYPE_XIAOMI, 1);
        mKeymap.put(ThirdPartyPushType.PUSH_TYPE_HUAWEI, 2);
        mKeymap.put(ThirdPartyPushType.PUSH_TYPE_FCM, 128);
        mKeymap.put(ThirdPartyPushType.PUSH_TYPE_OPPO, 32);
        mJsonData = new JSONObject();
    }

    public class ReporPushDeviceInfoTask extends TimerTask {
        private ConcurrentHashMap<Integer, TokenUploadState> needReportThirdPartyTokenMap;
        private String uploadFailReason;
        private int mReportState;
        private JSONObject mResponseContent;
        private String responseContent;

        public ReporPushDeviceInfoTask() {
            needReportThirdPartyTokenMap = new ConcurrentHashMap<>();
        }

        @Override
        public void run() {
            uploadFailReason = "uploadInitState";
            int tryCounts = 5;
            mReportState = REPORT_TIMEOUT;

            while (--tryCounts > 0) {
                if (doSubmit()) {
                    mReportState = REPORT_SUCCESS;
                    break;
                } else {
                    mReportState = REPORT_FAILED;
                    try {
                        Thread.sleep(3000);
                    } catch (InterruptedException e) {
                        uploadFailReason = e.getMessage();
                        PushLog.inst().log(TAG + ".run sleep exception " + e.getMessage());
                        break;
                    }
                }
            }

            if (uploadFailReason.equals("httpStatusCode:200, reason:OK")) {
                uploadFailReason += " " + responseContent;
            } else if (uploadFailReason.equals("uploadInitState")) {
                uploadFailReason += " " + responseContent;
            }

            for (Map.Entry<Integer, TokenUploadState> entry : needReportThirdPartyTokenMap.entrySet()) {
                if (!entry.getValue().getIsUploaded()) {
                    if (mKeymap.get(ThirdPartyPushType.PUSH_TYPE_FCM).equals(entry.getKey())) {
                        PushReporter.getInstance()
                                .reportEvent(YYPushStatisticEvent.REPORT_FCM_TOKEN_FAILURE, uploadFailReason);
                        KLogW.i(YYPushStatisticEvent.REPORT_FCM_TOKEN_FAILURE,uploadFailReason);
                    } else if (mKeymap.get(ThirdPartyPushType.PUSH_TYPE_XIAOMI).equals(entry.getKey())) {
                        PushReporter.getInstance()
                                .reportEvent(YYPushStatisticEvent.REPORT_XIAOMI_TOKEN_FAILURE, uploadFailReason);
                        KLogW.i(YYPushStatisticEvent.REPORT_XIAOMI_TOKEN_FAILURE,uploadFailReason);
                    } else if(mKeymap.get(ThirdPartyPushType.PUSH_TYPE_OPPO).equals(entry.getKey())){
                        PushReporter.getInstance()
                                .reportEvent(YYPushStatisticEvent.REPORT_OPPO_TOKEN_FAILURE, uploadFailReason);
                        KLogW.i(YYPushStatisticEvent.REPORT_OPPO_TOKEN_FAILURE,uploadFailReason);
                    }else {
                        PushReporter.getInstance()
                                .reportEvent(YYPushStatisticEvent.REPORT_HUAWEI_TOKEN_FAILURE, uploadFailReason);
                        KLogW.i(YYPushStatisticEvent.REPORT_HUAWEI_TOKEN_FAILURE,uploadFailReason);
                    }
                }
            }

            //上报http deviceinfo结果到海度
            PushReporter.getInstance().uploadHttpResponseToHiido(mReportState,
                    YYPushConsts.HIIDO_PUSH_DEVICEINFO_RES_BY_HTTP_EVENT_ID, uploadFailReason);
        }

        private boolean doSubmit() {
            try {
                JSONArray jsonArray = new JSONArray();
                for (Map.Entry<Integer, TokenUploadState> entry : mThirdPartyTokenMap.entrySet()) {
                    JSONObject jsonObject = new JSONObject();
                    if (!entry.getValue().getIsUploaded()) {
                        jsonObject.put("token", entry.getValue().getToken());
                        jsonObject.put("type", entry.getKey());
                        jsonArray.put(jsonObject);
                        needReportThirdPartyTokenMap.put(entry.getKey(), new TokenUploadState(entry.getValue()
                                .getToken(), false));
                        if (mKeymap.get(ThirdPartyPushType.PUSH_TYPE_FCM).equals(entry.getKey())) {
                            PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REPORT_FCM_TOKEN);
                        } else if (mKeymap.get(ThirdPartyPushType.PUSH_TYPE_XIAOMI).equals(entry.getKey())) {
                            PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REPORT_XIAOMI_TOKEN);
                        } else if(mKeymap.get(ThirdPartyPushType.PUSH_TYPE_OPPO).equals(entry.getKey())){
                            PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REPORT_OPPO_TOKEN);
                        }else {
                            PushReporter.getInstance().reportEvent(YYPushStatisticEvent.REPORT_HUAWEI_TOKEN);
                        }
                    }
                }

                if (jsonArray.length() == 0) {
                    if (mThirdPartyTokenMap.size() == 0) {
                        uploadFailReason = "db has no thirdParty token";
                        return false;
                    } else {
                        PushLog.inst().log(TAG + ".doSubmit all token already uploaded");
                        return true;
                    }
                }

                mJsonData.put("thirdToken", jsonArray);

                PushLog.inst()
                        .log(TAG + ".doSubmit start to upload deviceinfo by http tokenSize:" + jsonArray.length());

                PushHttpUtil.PushHttpResp resp =
                        PushHttpUtil.post(m_url, mJsonData.toString(), !m_url.equals(releaseDeviceinfoUrl));

                int mStatusCode = resp.statusCode;
                uploadFailReason = "httpStatusCode:" + mStatusCode + ", reason:" + resp.reason;
                if (mStatusCode != 200) {
                    PushLog.inst()
                            .log(TAG + ".doSubmit post from data error:" + mStatusCode + ", reason:" + resp.reason);
                    return false;
                }
                responseContent = resp.result;
                try {
                    mResponseContent = new JSONObject(responseContent);
                    if (mResponseContent.has("thirdToken")) {
                        JSONArray thirdPartyTokenJsonArray = new JSONArray(mResponseContent.getString("thirdToken"));
                        for (int i = 0; i < thirdPartyTokenJsonArray.length(); ++i) {
                            JSONObject jsonObject1 = (JSONObject) thirdPartyTokenJsonArray.get(i);
                            if (jsonObject1.has("type")) {
                                int type = jsonObject1.getInt("type");
                                String token = mThirdPartyTokenMap.get(type).getToken();
                                mThirdPartyTokenMap.remove(type);
                                mThirdPartyTokenMap.put(type, new TokenUploadState(token, true));
                                needReportThirdPartyTokenMap.remove(type);
                                needReportThirdPartyTokenMap.put(type, new TokenUploadState(token, true));
                                if (mKeymap.get(ThirdPartyPushType.PUSH_TYPE_FCM).equals(type)) {
                                    PushReporter.getInstance()
                                            .reportEvent(YYPushStatisticEvent.REPORT_FCM_TOKEN_SUCCESS);
                                    KLogW.i(YYPushStatisticEvent.REPORT_FCM_TOKEN_SUCCESS,token);
                                } else if (mKeymap.get(ThirdPartyPushType.PUSH_TYPE_XIAOMI).equals(type)) {
                                    PushReporter.getInstance()
                                            .reportEvent(YYPushStatisticEvent.REPORT_XIAOMI_TOKEN_SUCCESS);
                                    KLogW.i(YYPushStatisticEvent.REPORT_XIAOMI_TOKEN_SUCCESS,token);
                                }else if(mKeymap.get(ThirdPartyPushType.PUSH_TYPE_OPPO).equals(type)){
                                    PushReporter.getInstance()
                                            .reportEvent(YYPushStatisticEvent.REPORT_OPPO_TOKEN_SUCCESS);
                                    KLogW.i(YYPushStatisticEvent.REPORT_OPPO_TOKEN_SUCCESS,token);
                                } else {
                                    PushReporter.getInstance()
                                            .reportEvent(YYPushStatisticEvent.REPORT_HUAWEI_TOKEN_SUCCESS);
                                    KLogW.i(YYPushStatisticEvent.REPORT_HUAWEI_TOKEN_SUCCESS,token);
                                }
                            }
                        }
                    }
                    if (mResponseContent.has("resCode")) {
                        int resCode = mResponseContent.getInt("resCode");
                        if (resCode != 200) {
                            uploadFailReason = "push server resCode:" + resCode;
                            return false;
                        }
                    }

                    if (mResponseContent.has("tokenID")) {
                        String token = mResponseContent.getString("tokenID");
                        if (!TextUtils.isEmpty(token) && !token.equals(TokenStore.getInstance().getTokenID())) {
                            PushLog.inst().log(TAG + ".doSubmit got yyToken save yyToken to db");
                            TokenStore.getInstance().saveYYTokenToDb(mContext, token);
                        } else {
                            PushLog.inst().log(TAG + ".doSubmit has already got yyToken do not need save yyToken");
                        }
                    }

                } catch (Exception e) {
                    Log.e(TAG, "doSubmit exception:" + e.getMessage());
                    uploadFailReason = "YYPushDeviceInfoHttp.doSubmit exception:" + e.getMessage();
                }
                PushLog.inst().log(TAG + ".doSubmit result content:" + responseContent);
                if (responseContent == null || responseContent.isEmpty()) {
                    uploadFailReason = "responseContent is null or empty mStatusCode:" + mStatusCode;
                    return false;
                }
                return true;
            } catch (Exception e) {
                uploadFailReason = "YYPushDeviceInfoHttp.dosubmit final exception:" + e.toString();
                PushLog.inst().log(TAG + ".doSubmit exception:" + e);
            }
            return false;
        }
    }

    public synchronized void doReportThiradpartyTokenTask(Context context) {
        PushLog.inst().log(TAG + ".doReportThiradpartyTokenTask");
        if (!isUploadDeviceInfo) {
            isUploadDeviceInfo = true;
        } else {
            PushLog.inst().log(TAG + ".doReportThiradpartyTokenTask is already upload thirdparty token");
            return;
        }
        setRequestUrl();

        mContext = context;

        setReportValue(context);

        saveThirdPartyTokenToMapFromDb();
        if (mThirdPartyTokenMap.size() != 0) {
            PushLog.inst().log(TAG + ".doReportThiradpartyTokenTask execute ReporPushDeviceInfoTask");
            PushThreadPool.getPool().execute(new ReporPushDeviceInfoTask(), 0);
        } else {
            PushLog.inst().log(TAG + ".doReportThiradpartyTokenTask db has no token.");
        }
    }

    private void setRequestUrl() {
        String ip = AppPushInfo.getPushTestEnvIp();
        boolean bHasConfigIp = (ip != null && (StringUtil.isIp(ip) || StringUtil.isDomain(ip)));
        String url = releaseDeviceinfoUrl;
        if (bHasConfigIp) {
            url = String.format(testDeviceinfoUrl, ip);
            PushLog.inst().log(TAG + ".setRequestUrl connect to Test Environment:" + ip);
        } else {
            PushLog.inst().log(TAG + ".setRequestUrl connect to Production Environment");
        }
        m_url = url;
    }

    public synchronized void addThirdpartyToken(String type, String token) {
        try {
            PushLog.inst().log(TAG + ".addThirdpartyToken type:" + type + ", token:" + token);
            int tokentype = mKeymap.get(type);
            TokenUploadState ts = mThirdPartyTokenMap.get(tokentype);
            if (ts != null) {
                if (token.equals(ts.getToken())) {
                    PushLog.inst().log(TAG + ".addThirdpartyToken token already insert");
                    return;
                } else {
                    PushLog.inst().log(TAG + ".addThirdpartyToken token updated, upload again");
                    mThirdPartyTokenMap.remove(tokentype);
                }
            }
            mThirdPartyTokenMap.put(tokentype, new TokenUploadState(token, false));
            if (!isUploadDeviceInfo) {
                PushLog.inst()
                        .log(TAG + ".addThirdpartyToken wait call doReportThiradpartyTokenTask");
                return;
            }
            PushLog.inst().log(TAG + ".addThirdpartyToken execute ReporPushDeviceInfoTask");
            PushThreadPool.getPool().execute(new ReporPushDeviceInfoTask(), 0);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ".addThirdpartyToken erro=" + t);
        }
    }

    private void setReportValue(Context context) {
        try {
            PushLog.inst().log("YYPushDeviceInfoHttp.setReportValue");
            mJsonData.put("appID", AppPushInfo.getYYKey(context));
            mJsonData.put("tokenID", TokenStore.getInstance().getTokenID());
            mJsonData.put("ticket", AppPushInfo.getYYAuthTicket(context));
            mJsonData.put("sdkVer", AppPushInfo.getYYPushVersionNo());
            mJsonData.put("appVer", AppPushInfo.getAppVersion());
            mJsonData.put("sysVer", android.os.Build.VERSION.RELEASE);
            mJsonData.put("brand", android.os.Build.BRAND);
            mJsonData.put("model", android.os.Build.MODEL);
            mJsonData.put("deviceID", DeviceProxy.getHdid(context));
            mJsonData.put("macAddr", AppPushInfo.getMac(context));
            mJsonData.put("hdid", DeviceProxy.getHdid(context));
            mJsonData.put("term", "1");
        } catch (JSONException e) {
            PushLog.inst().log("YYPushDeviceInfoHttp.setReportValue exception:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public synchronized boolean isNeedTryUploadTokenToPushServer() {
        return isUploadDeviceInfo;
    }

    public void tryUploadDeviceInfoToPushServerByHttp() {
        PushLog.inst().log(TAG + ".tryUploadDeviceInfoToPushServerByHttp");
        if (mThirdPartyTokenMap.size() > 0) {
            for (Map.Entry<Integer, TokenUploadState> entry : mThirdPartyTokenMap.entrySet()) {
                if (!entry.getValue().getIsUploaded()) {
                    PushLog.inst().log(TAG + ".tryUploadDeviceInfoToPushServerByHttp " +
                            "execute ReporPushDeviceInfoTask");
                    PushThreadPool.getPool().execute(new ReporPushDeviceInfoTask(), 0);
                    return;
                } else {
                    PushLog.inst().log(TAG + ".tryUploadDeviceInfoToPushServerByHttp " +
                            "token has already uploaded, tokenType:" + entry.getKey());
                }
            }
        }
    }

    private void saveThirdPartyTokenToMapFromDb() {
        PushLog.inst().log(TAG + ".saveThirdPartyTokenToMapFromDb");
        String fcmToken = TokenStore.getInstance().getFcmToken();
        String thirdPartyToken = TokenStore.getInstance().getSysToken();
        if (!fcmToken.equals("")) {
            mThirdPartyTokenMap
                    .put(mKeymap.get(ThirdPartyPushType.PUSH_TYPE_FCM), new TokenUploadState(fcmToken,
                            false));
            PushLog.inst().log(TAG + ".saveThirdPartyTokenToMapFromDb get fcm token from db");
        }
        if (!thirdPartyToken.equals("")) {
            PushLog.inst().log(TAG + ".saveThirdPartyTokenToMapFromDb get thirdParty token from db");
            if(SystemUtil.isHuaWei()){
                mThirdPartyTokenMap.put(mKeymap.get(ThirdPartyPushType.PUSH_TYPE_HUAWEI ), new TokenUploadState(thirdPartyToken, false));
            }else if(SystemUtil.isOppo()){
                mThirdPartyTokenMap.put(mKeymap.get(ThirdPartyPushType.PUSH_TYPE_OPPO ), new TokenUploadState(thirdPartyToken, false));
            }else{
                mThirdPartyTokenMap.put(mKeymap.get(ThirdPartyPushType.PUSH_TYPE_XIAOMI ), new TokenUploadState(thirdPartyToken, false));
            }
        }
    }

}
