package com.yy.pushsvc.report;

import android.content.Context;

import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.util.NetUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by Administrator on 2017/11/3.
 */

public class TokenRegisterState {
    private static final TokenRegisterState instance = new TokenRegisterState();
    private Context mContext;

    public static TokenRegisterState getInstance() {
        return instance;
    }

    public HashMap<String, String> typeDic = new HashMap<>();
    private ConcurrentHashMap<String, Boolean> mRegisterTokenMap = new ConcurrentHashMap<>();
    private ConcurrentHashMap<String, Boolean> mNeedCheckMode = new ConcurrentHashMap<>();
    private long checktimeLong = 20000;

    private TokenRegisterState() {
        typeDic.put(ThirdPartyPushType.PUSH_TYPE_XIAOMI, YYPushConsts.HIIDO_XIAOMI_TOKEN_RES_EVENT_ID);
        typeDic.put(ThirdPartyPushType.PUSH_TYPE_HUAWEI, YYPushConsts.HIIDO_HUAWEI_TOKEN_RES_EVENT_ID);
        typeDic.put(ThirdPartyPushType.PUSH_TYPE_FCM, YYPushConsts.HIIDO_FCM_TOKEN_RES_EVENT_ID);
        typeDic.put(ThirdPartyPushType.PUSH_TYPE_OPPO, YYPushConsts.HIIDO_OPPO_TOKEN_RES_EVENT_ID);
    }

    public synchronized void addRegisterTokenState(String type, Boolean result, String failcode, String failmsg) {
        //// TODO: 2017/11/3 report to server
        PushLog.inst().log("TokenRegisterState.addRegisterTokenState, type = " + type);
        if (!mRegisterTokenMap.containsKey(type)) {
            mRegisterTokenMap.put(type, result);
            //上报注册第三方token状态到海度
            if (result) {
                PushReporter.getInstance()
                        .newReportSucEvtToHiido(typeDic.get(type));
            } else {
                PushReporter.getInstance()
                        .newReportFailEvtToHiido(typeDic.get(type), failcode, failmsg);
            }
        }
    }

    public void doStateCheck(Set<String> checkSet, Context context) {
        mContext = context;
        for (String entry : checkSet) {
            mNeedCheckMode.put(entry, true);
        }

        PushThreadPool.getPool().execute(new Runnable() {
            @Override
            public void run() {
                checkTimeout();
            }
        }, checktimeLong);
    }

    private void checkTimeout() {
        PushLog.inst().log("TokenRegisterState.checkTimeout mRegisterTokenMap.size = " + mRegisterTokenMap.size() +
                ", mNeedCheckMode.size = " + mNeedCheckMode.size());
        for (Map.Entry<String, Boolean> entry : mNeedCheckMode.entrySet()) {
            if (!mRegisterTokenMap.containsKey(entry.getKey())) {
                //report time out register token
                //上报注册第三方token超时到海度
                PushReporter.getInstance().newReportFailEvtToHiido(
                        typeDic.get(entry.getKey()), YYPushConsts.RES_TIMEOUT,
                        "NetworkAvailable is  " + String.valueOf(NetUtil
                                .isNetworkAvailable(mContext)));

                String eventStr = YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN_FAILURE;
                if (entry.getKey().equals(ThirdPartyPushType.PUSH_TYPE_HUAWEI)) {
                    eventStr = YYPushStatisticEvent.REGISTER_HUAWEI_TOKEN_FAILURE;
                } else if (entry.getKey().equals(ThirdPartyPushType.PUSH_TYPE_OPPO)) {
                    eventStr = YYPushStatisticEvent.REGISTER_OPPO_TOKEN_FAILURE;
                } else {
                    eventStr = YYPushStatisticEvent.REGISTER_XIAOMI_TOKEN_FAILURE;
                }

                PushReporter.getInstance().reportEvent(eventStr, "register timeout, NetworkAvailable is "
                        + String.valueOf(NetUtil.isNetworkAvailable(mContext)));

            }
        }
    }
}
