package com.yy.pushsvc.report;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;

import com.google.android.gms.common.GoogleApiAvailability;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.defs.StatisAPI;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.AppPackageUtil;
import com.yy.pushsvc.util.NetUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.RomUtils;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;

import java.util.Map;

/**
 * Created by DW on 2017/11/1.
 * Description
 */

public class PushReporter {
    private static final String TAG = "PushReporter";
    private static final PushReporter instance = new PushReporter();
    private volatile StatisAPI statisAPI;
    private static final int REPORT_SUCCESS = 0;
    private static final int REPORT_FAILED = 1;
    private static final int REPORT_TIMEOUT = 2;
    private long saveJiGuangWakeReportUid = 0;
    private volatile int saveJiGuangWakeReporWakeType = 0;
    private volatile boolean isReportedJiGuangWake = false;
    private Context mContext;

    public static PushReporter getInstance() {
        return instance;
    }

    private PushReporter() {
    }

    public synchronized void init(Context context) {
        initHiidoSdk(context);
        mContext = context;
    }

    /**
     * mbsdkdo表
     * */
    private synchronized void initHiidoSdk(Context context) {
        if (statisAPI == null) {
            PushLog.inst().log(TAG + ".initHiidoSdk, begin to initHiidoSdk.");
            StatisOption option = new StatisOption();
            option.setAppkey(AppPushInfo.HIIDO_APP_KEY);
            option.setAppId("");
            option.setFrom(Integer.toString(AppPackageUtil.getAppKey(context)));
            option.setVer(AppPushInfo.getYYPushVersion(context));
            statisAPI = HiidoSDK.instance().createNewStatisApi();
            statisAPI.init(context, option);
            statisAPI.reportDo(0);
        }
    }

    /**
     * mbsdksuccess表
     * */
    public void newReportSucEvtToHiido(String aid) {
        PushLog.inst()
                .log("PushReporter.newReportSucEvtToHiido: upload success to hiido, aid = " + aid);
        if (statisAPI != null) {
            try {
                boolean needReport = YYPush.getInstace().isExtReportEnble();
                if (!needReport) {
                    PushLog.inst().log(TAG + "- newReportSucEvtToHiido: dont report aid=" + aid);
                    return;
                }
                statisAPI.reportSuccess(TokenStore.getInstance().getBindAccount(), aid, "200", 0,
                        TokenStore
                                .getInstance().getTokenID());
            } catch (Throwable t) {
                Log.e(TAG, "newReportSucEvtToHiido: ", t);
            }
        }
    }

    /**
     * mbsdkfailure表
     * */
    public void newReportFailEvtToHiido(String aid, String failCode, String failMsg) {
        PushLog.inst().log("PushReporter.newReportFailEvtToHiido: upload fail to hiido, aid = " + aid);
        if (statisAPI != null) {
            try {
                boolean needReport = YYPush.getInstace().isExtReportEnble();
                if (!needReport) {
                    PushLog.inst().log(TAG + "- newReportFailEvtToHiido: dont report aid=" + aid);
                    return;
                }

                statisAPI.reportFailure(TokenStore.getInstance().getBindAccount(), aid, failCode,
                        failCode, failMsg,
                        TokenStore.getInstance().getTokenID());
            } catch (Throwable t) {
                Log.e(TAG, "newReportFailEvtToHiido: ", t);
            }
        }
    }

    /**
     * mbsdkevent表
     * */
    public void reportNotificationEventToHiido(String eid, String label, Property property) {
        PushLog.inst().log(TAG + ".reportNotificationEventToHiido, label:" + label + ", eid:" + eid);
        if (statisAPI != null) {
            statisAPI.reportTimesEvent(TokenStore.getInstance().getBindAccount(), eid, label, property);
        }
    }

    /**
     * mbsdksuccess/mbsdkfailure表
     * */
    public void uploadHttpResponseToHiido(int httpStatus, String aid, String failMsg) {
        PushLog.inst().log(TAG + ".uploadHttpResponseToHiido before upload aid = " + aid + ",httpStatus:" + httpStatus);
        if (statisAPI != null) {
            try {
                boolean needReport = YYPush.getInstace().isExtReportEnble();
                if (!needReport) {
                    PushLog.inst().log(TAG + "- uploadHttpResponseToHiido: dont report aid=" + aid);
                    return;
                }

                PushLog.inst().log(TAG + ".uploadHttpResponseToHiido begin to upload aid = " + aid);
                if (httpStatus == REPORT_SUCCESS) {
                    statisAPI
                            .reportSuccess(TokenStore.getInstance().getBindAccount(), aid, "200", 0,
                                    TokenStore.getInstance().getTokenID());
                } else if (httpStatus == REPORT_FAILED) {
                    PushLog.inst().log(TAG + ".uploadHttpResponseToHiido begin to upload failMsg:" +
                            failMsg);
                    statisAPI.reportFailure(TokenStore.getInstance().getBindAccount(), aid,
                            YYPushConsts.RES_FAIL,
                            YYPushConsts.RES_FAIL, failMsg, TokenStore.getInstance().getTokenID());
                } else {
                    statisAPI.reportFailure(TokenStore.getInstance().getBindAccount(), aid,
                            YYPushConsts.RES_TIMEOUT,
                            YYPushConsts.RES_TIMEOUT, failMsg,
                            TokenStore.getInstance().getTokenID());
                }

            } catch (Throwable t) {
                Log.e(TAG, "uploadHttpResponseToHiido: ", t);
            }
        }

    }

    /**
     * mbsdkevent表
     * */
    public void reportPermissionEventToHiido(String eid, String label, Property property) {
        PushLog.inst().log(TAG + ".reportPermissionEventToHiido, label:" + label + ", eid:" + eid);
        if (statisAPI != null) {
            statisAPI.reportTimesEvent(TokenStore.getInstance().getBindAccount(), eid, label, property);
        }
    }

    /**
     * mbsdksuccess表
     * */
    public synchronized void reportJiGuangWakeSucEvtToHiido(final long uid, final int wakeType) {
        try {
            PushLog.inst().log("PushReporter.reportJiGuangWakeSucEvtToHiido");
            if (statisAPI == null) {
                PushLog.inst().log("PushReporter.reportJiGuangWakeSucEvtToHiido statisAPI is null, " +
                        "wait initHiidoSdk continue to report");
                if (saveJiGuangWakeReporWakeType == 0) {
                    saveJiGuangWakeReportUid = uid;
                    saveJiGuangWakeReporWakeType = wakeType;
                }
                return;
            }
            synchronized (PushReporter.class) {
                if (!isReportedJiGuangWake) {
                    boolean needReport = YYPush.getInstace().isExtReportEnble();
                    if (!needReport) {
                        PushLog.inst().log(TAG + "- reportJiGuangWakeSucEvtToHiido: dont report");
                        return;
                    }

                    PushLog.inst().log("PushReporter.reportJiGuangWakeSucEvtToHiido start to upload to hiido" +
                            ", wakeType:" + AppPushInfo.jiGuangWakeType2WakeName(wakeType));
                    statisAPI.reportSuccess(uid, YYPushConsts.HIIDO_JIGUANG_EFFECTIVE_AWAKE_EVENT, "200", 0,
                            AppPushInfo.jiGuangWakeType2WakeName(wakeType));
                    saveJiGuangWakeReporWakeType = 0;
                    isReportedJiGuangWake = true;
                } else {
                    PushLog.inst().log("PushReporter.reportJiGuangWakeSucEvtToHiido has " +
                            "reported to hiido" + ", wakeType:" + AppPushInfo.jiGuangWakeType2WakeName(wakeType));
                }
            }
        } catch (Exception e) {
            PushLog.inst().log("PushReporter.reportJiGuangWakeSucEvtToHiido exception:" + e);
        }
    }

    public synchronized void reportEvent(String event) {
        reportEvent(event, "");
    }

    /**
     * pushevent表
     * */
    public synchronized void reportEvent(String event, String bak1) {
        PushThreadPool.getPool().execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if (statisAPI != null) {

                        boolean needReport = YYPush.getInstace().isExtReportEnble();
                        if (!needReport) {
                            PushLog.inst().log(TAG + "- reportEvent, pushevent: dont report event" + event);
                            return;
                        }

                        StatisContent statisContent = new StatisContent();
                        statisContent.put(YYPushStatisticEvent.EVENT, event);
                        statisContent.put(YYPushStatisticEvent.BUSINESS_APP,
                                AppPushInfo.getYYKey(mContext));
                        statisContent.put(YYPushStatisticEvent.BUSINESS_APPVER,
                                AppPushInfo.getAppVersion());
                        statisContent
                                .put(YYPushStatisticEvent.NET, NetUtil.getNetWorkType(mContext));
                        statisContent
                                .put(YYPushStatisticEvent.ROM, RomUtils.getRomInfo().display());
                        statisContent.put(YYPushStatisticEvent.BAK1, bak1);
                        statisAPI.reportStatisticContent(YYPushStatisticEvent.PUSH_ACT,
                                statisContent, true, true);
                        PushLog.inst().log("PushReporter.reportEvent:" + statisContent);
                    }
                } catch (Exception e) {
                    Log.e(TAG, "reportEvent exception:" + e);
                }
            }
        });
    }


    /**
     * mbsdkevent表
     * */
    public void reportRegisterEventToHiido(String state) {
        try {
            if (statisAPI != null) {
                Property property = new Property();
                property.putString(YYPushConsts.HIIDO_REGISTER_PUSH_SDK_EVENT_ID, state);
                PushLog.inst().log(TAG + ".reportRegisterEventToHiido state:" + state);
                statisAPI.reportTimesEvent(TokenStore.getInstance().getBindAccount(), YYPushConsts
                        .HIIDO_REGISTER_PUSH_SDK_EVENT_ID, Build.MANUFACTURER, property);
            }
        } catch (Exception e) {
            Log.e(TAG, "reportRegisterEventToHiido exception:" + e);
        }
    }

    /**
     * mbsdkevent表
     * */
    public void reportRegisterEventToHiido(Context context, String state) {
        try {
            if (statisAPI != null) {
                Property property = new Property();
                property.putString(YYPushConsts.HIIDO_REGISTER_PUSH_SDK_EVENT_ID, state);
                PushLog.inst().log(TAG + ".reportRegisterEventToHiido state:" + state);
                if (state.equals(YYPushConsts.HUAWEI_NOT_REGISTER_HUAWEI_PUSH_SDK_STATE)) {
                    statisAPI.reportTimesEvent(TokenStore.getInstance().getBindAccount(), YYPushConsts
                                    .HIIDO_REGISTER_PUSH_SDK_EVENT_ID,
                            String.valueOf(
                                    HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(context)),
                            property);
                }
            }
        } catch (Exception e) {
            Log.e(TAG, "reportRegisterEventToHiido state:" + state + ",exception:" + e);
        }
    }

    /**
     * mbsdkevent表
     * */
    public void reportGooglePlayServiceToHiido(Context context) {
        try {
            String label = String.valueOf(GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context));
            String googlePlayServiceVersion = String.valueOf(context.getPackageManager()
                    .getPackageInfo(YYPushConsts.COM_GOOGLE_ANDROID_GMS, PackageManager.GET_SIGNATURES).versionCode);
            if (statisAPI != null) {
                Property property = new Property();
                property.putString(YYPushConsts.GOOGLE_PLAY_SERVICE_VERSION, googlePlayServiceVersion);
                PushLog.inst().log(TAG + ".reportGooglePlayServiceToHiido label:" + label + ", googlePlayService " +
                        "version:" + googlePlayServiceVersion);
                statisAPI.reportTimesEvent(TokenStore.getInstance().getBindAccount(), YYPushConsts
                        .HIIDO_GOOGLE_PLAY_SERVICE_EVENT_ID, label, property);
            }
        } catch (Exception e) {
            Log.e(TAG, "reportGooglePlayServiceToHiido exception:" + e);
        }
    }

    /**
     * mbsdkevent表
     * */
    public void reportHmsVersionEventToHiido(Context context) {
        try {
            PackageInfo packageInfo =
                    context.getPackageManager().getPackageInfo("com.huawei.hwid", PackageManager.GET_INSTRUMENTATION);
            Property property = new Property();
            if (packageInfo == null) {
                property.putString("hmsversion", "0");
                PushLog.inst().log(TAG + ".reportHmsVersionEventToHiido packageInfo is null");
            } else {
                property.putString("hmsversion", String.valueOf(packageInfo.versionCode));
                PushLog.inst().log(TAG + ".reportHmsVersionEventToHiido hms version:" + packageInfo.versionCode);
            }
            PushLog.inst().log(TAG + ".reportHmsVersionEventToHiido");
            if (statisAPI != null) {
                final String emuiVersion = AppPackageUtil.getEmuiVersion();
                statisAPI.reportTimesEvent(
                        TokenStore.getInstance().getBindAccount(),
                        YYPushConsts.HIIDO_HUAWEI_HMS_VERSION,
                        StringUtil.isNullOrEmpty(emuiVersion)
                                ? AppPackageUtil.getSystemProperty("ro.build.version.emui")
                                : emuiVersion,
                        property);
            }
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".uploadHmsVersion exception:" + e);
        }
    }

    /**
     * mbsdkevent表
     * */
    public void reportFetchOutlieMsgEventToHiido(String eid, String label, Map<String, String> propertyMap) {
        PushLog.inst().log(TAG + ".reportFetchOutlieMsgEventToHiido, label:" + label + ", eid:" + eid + ", property:" + propertyMap.toString());
        if (statisAPI != null) {
            Property property = new Property();
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                property.putString(entry.getKey(), entry.getValue());
            }
            statisAPI.reportTimesEvent(TokenStore.getInstance().getBindAccount(), eid, label, property);
        }
    }

}
