package com.yy.pushsvc.report;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;

import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.util.PushHttpUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.StringUtil;
import com.yy.pushsvc.util.YYPushConsts;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by maxiaodong on 2019/5/16.
 * Description
 */
public class PushGetUnreadMsgHttp {
    @SuppressLint("StaticFieldLeak")
    private static PushGetUnreadMsgHttp instance = new PushGetUnreadMsgHttp();
    private static final String TAG = "PushGetUnreadMsgHttp";
    private static String releaseUrl = "https://unpush-yypush.yy.com/PushMessage/UnPush";
    private static String testUrl = "https://test.unpush-yypush.yy.com/PushMessage/UnPush";
    private static JSONObject mHttpJsonData = new JSONObject();
    private static final int REPORT_SUCCESS = 0;
    private static final int REPORT_FAILED = 1;
    private static final int REPORT_TIMEOUT = 2;
    private static String mUrl = "";
    private Context mContext;
    private volatile boolean isRunning = false;

    private PushGetUnreadMsgHttp() {

    }

    public static PushGetUnreadMsgHttp getInstance() {
        return instance;
    }

    public class ReportTask implements Runnable {
        private int tryCount = 3;
        private int mReportState = REPORT_TIMEOUT;
        private String uploadReason = "uploadInitState";
        private JSONObject mJsonObjectRes;
        private int errCode = 0;

        @Override
        public void run() {
            while (tryCount-- > 0) {
                if (doSubmit()) {
                    mReportState = REPORT_SUCCESS;
                    break;
                } else {
                    mReportState = REPORT_FAILED;
                    try {
                        Thread.sleep(5000);
                    } catch (Exception e) {
                        Log.e(TAG, "run: " + e);
                        uploadReason = "Thread sleep exception:" + e;
                        break;
                    }
                }
            }

            PushReporter.getInstance().uploadHttpResponseToHiido(mReportState,
                    YYPushConsts.HIIDO_GET_UNREAD_MSG_BY_HTTP_EVENT_ID, uploadReason);

            if (mReportState == REPORT_SUCCESS) {
                AppPushInfo.setUnreadMsgFlag(true);
            }
            isRunning = false;
        }

        private boolean doSubmit() {
            try {
                PushLog.inst().log(TAG + ".doSubmit");
                PushHttpUtil.PushHttpResp resp = PushHttpUtil.post(mUrl, mHttpJsonData.toString(),
                        !mUrl.equals(releaseUrl));
                int httpCode = resp.statusCode;
                uploadReason = "httpStatusCode:" + httpCode + ", reason:" + resp.reason;
                if (httpCode != 200) {
                    PushLog.inst().log(TAG + ".doSubmit post data failed httpCode:" + httpCode);
                    return false;
                }
                return dealPushServerRes(resp.result);
            } catch (Exception e) {
                Log.e(TAG, "doSubmit: " + e);
                uploadReason = "doSubmit:" + e;
                return false;
            }
        }

        private boolean dealPushServerRes(String res) {
            try {
                mJsonObjectRes = new JSONObject(res);
                if (mJsonObjectRes.has("error_msg")) {
                    PushLog.inst().log(TAG + ".dealPushServerRes error_msg:" + mJsonObjectRes.getString("error_msg"));
                    uploadReason += " error_msg:" + mJsonObjectRes.getString("error_msg");
                }

                if (mJsonObjectRes.has("error")) {
                    errCode = mJsonObjectRes.getInt("error");
                    if (errCode == 1 || errCode == 2 || errCode == 100) {
                        uploadReason += " errCode:" + errCode;
                        return false;
                    }
                }

                if (mJsonObjectRes.has("appid") &&
                        !mJsonObjectRes.getString("appid").equals(String.valueOf(AppPushInfo.getYYKey(mContext)))) {
                    PushLog.inst()
                            .log(TAG + ".dealPushServerRes msg from push server do not belong current app, appid:" +
                                    mJsonObjectRes.getString("appid") + ", current appid:" +
                                    AppPushInfo.getYYKey(mContext));
                    return true;
                }

                if (mJsonObjectRes.has("hdid") &&
                        !mJsonObjectRes.getString("hdid").equals(DeviceProxy.getHdid(mContext))) {
                    PushLog.inst()
                            .log(TAG + ".dealPushServerRes msg from push server do not belong current device, hdid:" +
                                    mJsonObjectRes.getString("hdid") + ", current hdid:" +
                                    DeviceProxy.getHdid(mContext));
                    return true;
                }

                if (mJsonObjectRes.has("number")) {
                    int num = mJsonObjectRes.getInt("number");
                    if (num == 0) {
                        PushLog.inst().log(TAG + ".dealPushServerRes push server has no msg, number is 0");
                        return true;
                    } else if (num == -1) {
                        uploadReason += " number is -1";
                        PushLog.inst().log(TAG + ".dealPushServerRes push server has no msg, number is -1");
                        return false;
                    } else {
                        PushLog.inst().log(TAG + ".dealPushServerRes push server has msg, number is " + num);
                    }
                } else {
                    PushLog.inst().log(TAG + ".dealPushServerRes res from push server do not has number");
                }

                if (mJsonObjectRes.has("body")) {
                    JSONObject msgJsonObject = new JSONObject(mJsonObjectRes.getString("body"));
                    if (msgJsonObject.has("pass-through")) {
                        JSONArray msgJsonArray = new JSONArray(msgJsonObject.getString("pass-through"));
                        PushLog.inst().log(TAG + ".dealPushServerRes msg from push server unreadMsg size:" +
                                msgJsonArray.length());
                        if (msgJsonArray.length() > 0) {
                            TokenStore.getInstance().dispacthUnreadMsg(mContext, ThirdPartyPushType.PUSH_TYPE_FCM, "http", msgJsonArray);
                        }
                    } else {
                        PushLog.inst().log(TAG + ".dealPushServerRes msg from push server has no pass-through");
                    }
                } else {
                    PushLog.inst().log(TAG + ".dealPushServerRes msg from push server has no body");
                }
                return true;
            } catch (Exception e) {
                Log.e(TAG, "dealPushServerRes: " + e);
                uploadReason += " dealPushServerRes exception:" + e;
                return false;
            }
        }
    }

    public synchronized void getUnreadMsgFromPushServer(Context context) {
        if (isRunning) {
            PushLog.inst().log(TAG + ".getUnreadMsgFromPushServer current reportTask is running");
            return;
        }
        isRunning = true;
        mContext = context;
        setRequestUrl();
        setRequestValue(context);
        PushThreadPool.getPool().execute(new ReportTask());
    }

    private void setRequestUrl() {
        String ip = AppPushInfo.getPushTestEnvIp();
        boolean bHasConfigIP = (ip != null && (StringUtil.isIp(ip) || StringUtil.isDomain(ip)));
        String url = releaseUrl;
        if (bHasConfigIP) {
            url = testUrl;
            PushLog.inst().log(TAG + ".setRequstUrl, login to Test Environment:" + ip);
        } else {
            PushLog.inst().log(TAG + ".setRequstUrl, login to Production Environment");
        }
        mUrl = url;
    }

    private void setRequestValue(Context context) {
        try {
            mHttpJsonData.put("appid", AppPushInfo.getYYKey(context));
            mHttpJsonData.put("hdid", DeviceProxy.getHdid(context));
            mHttpJsonData.put("message_number", AppPushInfo.getUnreadMsgMaxNum());
            PushLog.inst().log(TAG + ".setRequstValue");
        } catch (JSONException e) {
            Log.e(TAG, "setRequestValue:" + e);
        }
    }

    public boolean isRunningGetUnreadMsg() {
        return isRunning;
    }
}
