package com.yy.pushsvc.receiver;

import com.yy.pushsvc.YYPush;

public class YYPushToken {
    private static final YYPushToken ourInstance = new YYPushToken();

    public static YYPushToken getInstance() {
        return ourInstance;
    }

    private YYPushToken() {
    }

    /**
     * 注册YYPushToken事件
     *
     * @param callback
     * @return 成功返回 YYPushKitErrorCodes.SUCCESS 其他值参考错误代码表 YYPushKitErrorCodes
     */
    public YYPushKitErrorCodes register(YYPush.IYYPushTokenCallback callback) {
        YYPushCallBackManager.getInstance().setPushTokenCallBack(callback);
        return YYPushKitErrorCodes.SUCCESS;
    }

}
