package com.yy.pushsvc.receiver;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.yy.pushsvc.IMsgArriveCallback;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.template.TemplateManager;
import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.PushThreadPool;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Map;

public class YYPushMsgDispacher {

    private static final String TAG = "YYPushMsgDispacher";
    private static volatile YYPushMsgDispacher instance;
    private Context ctx;
    private IMsgArriveCallback callback;
    private ArrayList<IChainIntercept> list = new ArrayList<>();
    private Object lock =new Object();

    public interface IChainIntercept {
        boolean intercept(Intent intent, Context ctx);
    }

    public static YYPushMsgDispacher getInstance() {
        if (instance == null) {
            synchronized (YYPushMsgDispacher.class) {
                if (instance == null) {
                    instance = new YYPushMsgDispacher();
                }
            }
        }
        return instance;
    }

    public void addFirst(IChainIntercept intercept) {
        synchronized (lock) {
            list.add(0, intercept);
        }
        PushLog.inst().log(TAG + ",addFirst=" + list);
    }

    public void init(Context ctx, IMsgArriveCallback callback) {
        this.ctx = ctx;
        this.callback = callback;
    }

    @SuppressWarnings("unchecked")
    public final void dispatch(Intent intent) {

        try {
            PushLog.inst().log(TAG + ".onReceive received broadcast, " +
                    "intent action=" + (intent == null ? "null" : intent.getAction()));
            if (intent != null && intent.hasExtra(YYPushConsts.SERVICE_PROC_PULL_MAIN_PROC)) {
                return;
            }
            int size = list.size();
            for (int i = 0; i < size; i++) {
                IChainIntercept intercept = list.get(i);
                if (intercept.intercept(intent, ctx)) {
                    return;
                }
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ".onReceive exception:" + e);
        }
    }

    class UnreadIntercept implements  IChainIntercept {
        @Override
        public boolean intercept(Intent intent, Context ctx) {
            try {
                if (intent != null && intent.hasExtra(YYPushConsts.YY_PUSH_KEY_UNREAD_MSG_JSON)) {
                    PushLog.inst().log(TAG + ".onReceive intent contains unreadMsgJson");
                    if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE)) {
                        JSONArray jsonArray = null;
                        jsonArray = new JSONArray(
                                intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_UNREAD_MSG_JSON));
                        JSONArray unHandleArray = handleUnreadTemplateNotification(ctx, jsonArray,
                                        intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE),
                                        intent.getIntExtra(YYPushConsts.PUSH_TYPE,
                                                YYPushConsts.PUSH_TYPE_UNREAD));
                        if (unHandleArray != null && unHandleArray.length() > 0) {
                            onPushUnreadMsgReceived(ctx,
                                    intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE),
                                    unHandleArray);
                        }
                    }
                    return true;
                }
            } catch (Throwable e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private JSONArray handleUnreadTemplateNotification(Context context, JSONArray msgJsonArray,
                                                      String channelType,int pushType) {
        JSONArray unHandleArray = new JSONArray();
        try {
            for (int i = 0; i < msgJsonArray.length(); ++i) {
                JSONObject jsonObject = (JSONObject) msgJsonArray.get(i);
                long msgId = jsonObject.getLong("msgid");
                String payload = jsonObject.getString("payload");
                if (!TemplateManager.getInstance()
                        .templateNotificationIntercept(context,channelType , payload, msgId,
                                pushType)) {
                    unHandleArray.put(msgJsonArray.get(i));
                } else {
                    onPushMsgIntercept(msgId, payload.getBytes(), channelType, pushType
                            ,context);
                }
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return unHandleArray;
    }

    class TransferIntercept implements IChainIntercept {

        @Override
        public boolean intercept(Intent intent, Context ctx) {
            try {
                if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD)) {
                    PushLog.inst().log(TAG + ".onReceive intent contens payload.");
                    if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_MSGID) &&
                            (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_MSGTYPE) &&
                                    !intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_MSGTYPE)
                                            .equals(ThirdPartyPushType.PUSH_TYPE_YYPUSH))) {
                        if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_MSGDATA)) {
                            PushLog.inst().log(TAG +
                                    ".onReceive intent contains payload, call onPushMessageReceived " +
                                    "contain MsgData");
                            Map<String, String> map =
                                    (Map<String, String>) intent
                                            .getSerializableExtra(YYPushConsts.YY_PUSH_KEY_MSGDATA);
                            onPushMessageReceived(
                                    intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_MSGID, 0),
                                    intent.getByteArrayExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD),
                                    intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE),
                                    ctx, map);
                        } else {
                            onPushMessageReceived(
                                    intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_MSGID, 0),
                                    intent.getByteArrayExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD),
                                    intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE),
                                    ctx, null);
                            PushLog.inst().log(TAG +
                                    ".onReceive intent contains payload, call onPushMessageReceived " +
                                    "MsgData is" +
                                    " null");
                        }
                        return true;
                    }
                }
            } catch (Throwable t) {
                PushLog.inst().log(TAG + ",TransferIntercept:err= " + t);
            }
            return false;
        }
    }

    class TokenIntercept implements IChainIntercept {

        @Override
        public boolean intercept(Intent intent, Context ctx) {
            try {
                if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_TOKEN)) {
                    byte[] token = intent.getByteArrayExtra(YYPushConsts.YY_PUSH_KEY_TOKEN);
                    String tokenStr = new String(token);
                    String tokenType = intent.getStringExtra(YYPushConsts.YY_REAL_TOKEN_TYPE);
                    if (tokenType == null) {
                        PushLog.inst()
                                .log(TAG + ".onReceive invalid token or push type or token type");
                        return false;
                    }

                    PushThreadPool.getPool().execute(new Runnable() {
                        @Override
                        public void run() {
                            if (!tokenType.equals(ThirdPartyPushType.PUSH_TYPE_YYPUSH)) {
                                TokenStore.getInstance().addToken(ctx, tokenType, tokenStr);
                            } else {
                                TokenStore.getInstance()
                                        .addToken(ctx, ThirdPartyPushType.PUSH_TYPE_YYPUSH,
                                                tokenStr);
                            }
                        }
                    });
                    PushLog.inst()
                            .log(TAG + ".onReceive intent contains token, " + "token=" + tokenStr +
                                    ", tokentype = " +
                                    tokenType);
                    onTokenReceived(tokenType, token,
                            !tokenType.equals(ThirdPartyPushType.PUSH_TYPE_YYPUSH), ctx);
                    return true;
                }
            } catch (Throwable t) {
                PushLog.inst().log(TAG + ",TokenIntercept:err= " + t);
            }
            return false;
        }
    }

    class BindAccountIntercept implements IChainIntercept {

        @Override
        public boolean intercept(Intent intent, Context ctx) {
            try {
                if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_REG_PUSH_APP_RES)) {
                    PushLog.inst().log(TAG + ".onReceive intent contains reg push app res.");
                    int resCode = intent.getIntExtra(YYPushConsts.YY_PUSH_KEY_REG_PUSH_APP_RES, -1);
                    String account = intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_ACCOUNT);
                    onAppBindRes(resCode, account, ctx);
                    return true;
                }
            } catch (Throwable t) {
                PushLog.inst().log(TAG + ",BindAccountIntercept:err= " + t);
            }
            return false;
        }
    }

    class UnBindAccountIntercept implements IChainIntercept {

        @Override
        public boolean intercept(Intent intent, Context ctx) {
            try {
                if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_UNREG_PUSH_APP_RES)) {
                    PushLog.inst().log(TAG + ".onReceive intent contains unreg push app res.");
                    int resCode =
                            intent.getIntExtra(YYPushConsts.YY_PUSH_KEY_UNREG_PUSH_APP_RES, -1);
                    String account = intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_ACCOUNT);
                    onAppUnbindRes(resCode, account, ctx);
                    return true;
                }
            } catch (Throwable t) {
                PushLog.inst().log(TAG + ",UnBindAccountIntercept:err= " + t);
            }
            return false;
        }
    }

    class AddTagIntercept implements IChainIntercept {

        @Override
        public boolean intercept(Intent intent, Context ctx) {
            try {
                if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_SET_TAG_RES)) {
                    PushLog.inst().log(TAG + ".onReceive intent contains set TAG res.");
                    int resCode = intent.getIntExtra(YYPushConsts.YY_PUSH_KEY_SET_TAG_RES, -1);
                    onSetTagRes(resCode, ctx);
                    return true;
                }
            } catch (Throwable t) {
                PushLog.inst().log(TAG + ",AddTagIntercept:err= " + t);
            }
            return false;
        }
    }

    class DelTagIntercept implements IChainIntercept {

        @Override
        public boolean intercept(Intent intent, Context ctx) {
            try {
                if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_DEL_TAG_RES)) {
                    PushLog.inst().log(TAG + ".onReceive intent contains del TAG res.");
                    int resCode = intent.getIntExtra(YYPushConsts.YY_PUSH_KEY_DEL_TAG_RES, -1);
                    onDelTagRes(resCode, ctx);
                    return true;
                }
            }catch (Throwable t){
                PushLog.inst().log(TAG + ",DelTagIntercept:err= " + t);
            }
            return false;
        }
    }


    class NotificationArrivedIntercept implements IChainIntercept {

        @Override
        public boolean intercept(Intent intent, Context ctx) {
            try {
                if (intent != null) {
                    String pushBroadcastType = intent.getStringExtra(YYPushConsts.PUSH_BROADCAST_TYPE);
                    if (pushBroadcastType != null) {
                        if (pushBroadcastType
                                .equals(YYPushConsts.PUSH_BROADCAST_NOTIFICATION_ARRIVED)) {
                            long msgID = intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_MSGID, 0);
                            long pushID = intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_PUSHID, 0);
                            byte[] payload =
                                    intent.getByteArrayExtra(YYPushConsts.YY_PUSH_NOTIFICATION_PAYLOAD);
                            String channelType =
                                    intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE);
                            PushLog.inst().log(TAG + ".onReceive notification is arrived=" + msgID);
                            onNotificationArrived(msgID, payload, channelType, ctx);
                        }
                    }

                }
            }catch (Throwable t){
                PushLog.inst().log(TAG + ",NotificationArrivedIntercept:err= " + t);
            }
            return false;
        }
    }

    class NotificationClickIntercept implements IChainIntercept {

        @Override
        public boolean intercept(Intent intent, Context ctx) {
            try {
                if (intent != null) {
                    String pushBroadcastType =
                            intent.getStringExtra(YYPushConsts.PUSH_BROADCAST_TYPE);
                    if (pushBroadcastType != null) {
                        if (pushBroadcastType
                                .equals(YYPushConsts.PUSH_BROADCAST_NOTIFICATION_CLICKED)) {
                            long msgID = intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_MSGID, 0);
                            long pushID = intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_PUSHID, 0);
                            byte[] payload = intent.getByteArrayExtra(
                                    YYPushConsts.YY_PUSH_NOTIFICATION_PAYLOAD);
                            String channelType =
                                    intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE);
                            PushLog.inst().log(TAG + ".onReceive notification is clicked=" + msgID);
                            onNotificationClicked(msgID, payload, channelType, ctx);
                            return true;
                        }
                    }

                }
            } catch (Throwable e) {
                PushLog.inst().log(TAG + ",NotificationClickIntercept:err= " + e);
            }
            return false;
        }
    }

    // override this method to receiver token change.
    public void onTokenReceived(String type, byte[] token, boolean isThirdPartyToken, Context ctx) {
        if (callback != null) {
            callback.onTokenReceived(type, token, isThirdPartyToken, ctx);
        }
    }

    // override this method to receiver push message.
    public void onPushMessageReceived(long msgId, byte[] msgBody, String channelType, Context ctx, Map<String,
            String> msgData) {
        if (callback != null) {
            if (isProbe(msgBody)) {
                return;
            }
            callback.onPushMessageReceived(msgId, msgBody, channelType, ctx, msgData);
        }
    }

    // override this method to receiver unreg app res.
    public void onAppBindRes(int resCode, String account, Context ctx) {
        if (callback != null) {
            callback.onAppBindRes(resCode, account, ctx);
        }
    }

    // override this method to receiver unreg app res.
    public void onAppUnbindRes(int resCode, String account, Context ctx) {
        if (callback != null) {
            callback.onAppUnbindRes(resCode, account, ctx);
        }
    }

    public void onNotificationArrived(long msgID, byte[] payload, String channelType, Context ctx) {
        if (callback != null) {
            callback.onNotificationArrived(msgID, payload, channelType, ctx);
        }
    }

    public void onNotificationClicked(long msgID, byte[] payload, String channelType, Context ctx) {
        if (callback != null) {
            callback.onNotificationClicked(msgID, payload, channelType, ctx);
        }
    }

    public void onSetTagRes(int resCode, Context ctx) {
        if (callback != null) {
            callback.onSetTagRes(resCode, ctx);
        }
    }

    public void onDelTagRes(int resCode, Context ctx) {
        if (callback != null) {
            callback.onDelTagRes(resCode, ctx);
        }
    }

    public void onPushUnreadMsgReceived(Context context, String channelType, JSONArray msgJsonArray) {
        if (callback != null) {
            callback.onPushUnreadMsgReceived(context, channelType, msgJsonArray);
        }
    }

    // override this method to receiver be intercepted  message.
    public void onPushMsgIntercept(long msgId, byte[] msgBody, String channelType,
                                   int pushType, Context ctx) {
        if (callback != null) {
            callback.onPushSDKNotificationArrived(msgId, msgBody, channelType,ctx);
        }
    }

    public void onPushSDKNotificationShow(long msgId, byte[] msgBody, String channelType,
                                   int type ,Context ctx) {
        if (callback != null) {
            callback.onPushSDKNotificationShow(msgId, msgBody, channelType,type, ctx);
        }
    }

    public void onPushSDKNotificationReShow(long msgID, byte[] payload, String channelType,
                                            Context ctx) {
        if (callback != null) {
            callback.onPushSDKNotificationReShow(msgID, payload, channelType, ctx);
        }
    }

    private YYPushMsgDispacher() {
        PushThreadPool.getPool().execute(new Runnable() {
            @Override
            public void run() {
                synchronized (lock){
                    list.add(new UnreadIntercept());
                    list.add(new TransferIntercept());
                    list.add(new TokenIntercept());
                    list.add(new BindAccountIntercept());
                    list.add(new UnBindAccountIntercept());
                    list.add(new AddTagIntercept());
                    list.add(new DelTagIntercept());
                    list.add(new NotificationClickIntercept());
                    list.add(new NotificationArrivedIntercept());
                }
            }
        });
    }

    /**
     * payload是否是探针
     */
    private boolean isProbe(byte[] payload) {
        try {
            if (payload != null) {
                String strPayload = new String(payload);
                if (TextUtils.isEmpty(strPayload) || "{}".equals(strPayload)) {
                    return true;
                }
            } else {
                return true;
            }
        } catch (Exception e) {
            KLogW.i(TAG, "isProbe() exception=" + e);
            return true;
        }
        return false;
    }
}
