package com.yy.pushsvc.receiver;

import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.util.PushLog;

import java.util.ArrayList;

/**
 * Created by GuanYuFeng
 * on 2020/9/3
 */
public class ScreenChangeReceiver {
    private static final String TAG = "ScreenChangeReceiver";
    private static ScreenChangeReceiver instance;
    private Context context;
    private BroadcastReceiver screenReceiver = new ScreenBroadcastReceiver();
    private boolean unLock;
    private ArrayList<OnScreenChangeListener> listeners = new ArrayList();

    public interface OnScreenChangeListener {
        void onScreenOff();

        void onScreenOn();

        void onUnlockScreen();
    }

    public static ScreenChangeReceiver getInstance(Context context) {
        synchronized (ScreenChangeReceiver.class) {
            if (instance == null) {
                instance = new ScreenChangeReceiver(context);
            }
        }
        return instance;
    }

    private ScreenChangeReceiver(Context context) {
        try {
            if (context == null) {
                context = YYPush.getInstace().getContext();
            }
            if (!(context instanceof Application)) {
                context = context.getApplicationContext();
            }
            this.context = context;
            registerResceiver();
            KeyguardManager mKeyguardManager =
                    (KeyguardManager) context.getSystemService(Context.KEYGUARD_SERVICE);
            boolean flag = mKeyguardManager.inKeyguardRestrictedInputMode();
            unLock = !flag;
        } catch (Throwable t) {
            PushLog.inst().log(TAG + "ScreenManager,erro = " + t);
        }
    }

    public boolean isUnLock() {
        return unLock;
    }

    private void registerResceiver() {
        try {
            IntentFilter filter = new IntentFilter();
            filter.addAction(Intent.ACTION_SCREEN_OFF);
            filter.addAction(Intent.ACTION_USER_PRESENT);
            filter.addAction(Intent.ACTION_SCREEN_ON);
            context.registerReceiver(screenReceiver, filter);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + "registerResceiver,erro = " + t);
        }
    }

    public void registerListener(OnScreenChangeListener ls) {
        if (!listeners.contains(ls)) {
            listeners.add(ls);
        }
    }

    public void unRegisterListener(OnScreenChangeListener ls) {
        listeners.remove(ls);
    }

    private void onScreenOff() {
        unLock = false;
        PushLog.inst().log(TAG + ",onScreenOff");
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); i++) {
                OnScreenChangeListener listener = listeners.get(i);
                listener.onScreenOff();
            }
        }
    }

    private void onUnlockScreen() {
        unLock = true;
        PushLog.inst().log(TAG + ",onUnlockScreen ");
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); i++) {
                OnScreenChangeListener listener = listeners.get(i);
                listener.onUnlockScreen();
            }
        }
    }

    private void onScreenOn() {
        PushLog.inst().log(TAG + ",onScreenOn ");
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); i++) {
                OnScreenChangeListener listener = listeners.get(i);
                listener.onScreenOn();
            }
        }
    }

    /**
     * screen状态广播接收者
     */
    private class ScreenBroadcastReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                String action = intent.getAction();
                if (Intent.ACTION_SCREEN_OFF.equals(action)) { // 黑屏
                    onScreenOff();
                } else if (Intent.ACTION_USER_PRESENT.equals(action)) { //解锁
                    onUnlockScreen();
                } else if (Intent.ACTION_SCREEN_ON.equals(action)) { //亮屏
                    onScreenOn();
                }

            } catch (Throwable t) {
                PushLog.inst().log(TAG + ",onReceive(),erro=" + t.toString());
            }
        }
    }
}
