package com.yy.pushsvc.receiver;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;

import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.YYPushConsts;

import java.util.List;

import cn.jpush.android.service.WakedResultReceiver;

/**
 * Created by maxiaodong on 2019/4/1.
 * Description
 */

public class OverseasWakedResultReceiver extends WakedResultReceiver {
    @Override
    public void onWake(Context context, int i) {
        try {
            if (context != null) {
                ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    List<ActivityManager.AppTask> tasks = activityManager.getAppTasks();
                    if (tasks.size() == 0) {
                        PushLog.inst()
                                .log("OverseasWakedResultReceiver.onWake app is awaked by jiguang push, api level:" +
                                        Build.VERSION.SDK_INT + ", wake type:" + i);
                        PushReporter.getInstance()
                                .reportJiGuangWakeSucEvtToHiido(TokenStore.getInstance().getBindAccount(), i);
                    } else {
                        PushLog.inst().log("OverseasWakedResultReceiver.onWake app is alive, api level:" +
                                Build.VERSION.SDK_INT + ", wake type:" + i);
                    }
                } else {
                    List<ActivityManager.RunningTaskInfo> runningTaskInfoList = activityManager.getRunningTasks(1);
                    if (runningTaskInfoList.size() == 0) {
                        PushLog.inst()
                                .log("OverseasWakedResultReceiver.onWake app is awaked by jiguang push, api level:" +
                                        Build.VERSION.SDK_INT + ", wake type:" + i);
                        PushReporter.getInstance()
                                .reportJiGuangWakeSucEvtToHiido(TokenStore.getInstance().getBindAccount(), i);
                    } else {
                        PushLog.inst().log("OverseasWakedResultReceiver.onWake app is alive, api level:" +
                                Build.VERSION.SDK_INT + ", wake type:" + i);
                    }
                }
            }
        } catch (Exception e) {
            PushLog.inst().log("OverseasWakedResultReceiver.onWake exception:" + e + ", wake type:" + i);
            PushReporter.getInstance().newReportFailEvtToHiido(YYPushConsts.HIIDO_JIGUANG_EFFECTIVE_AWAKE_EVENT, "",
                    e.getMessage());
        }
    }
}
