package com.yy.pushsvc.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.yy.pushsvc.report.PushGetUnreadMsgHttp;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.report.YYPushDeviceInfoHttp;
import com.yy.pushsvc.report.YYTokenLoginHttp;
import com.yy.pushsvc.simplify.AppPushInfo;
import com.yy.pushsvc.simplify.TokenStore;
import com.yy.pushsvc.thirdparty.ThirdPartyPushType;
import com.yy.pushsvc.util.NetUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.SystemUtil;
import com.yy.pushsvc.util.YYPushConsts;
import com.yy.pushsvc.util.YYPushStatisticEvent;
import com.yy.pushsvc.yunlog.KLogW;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import androidx.annotation.NonNull;

/**
 * Created by DW on 2017/12/11.
 * Description
 */

public class NetworkChangeReceiver extends BroadcastReceiver {
    private static final String TAG = "NetworkChangeReceiver";
    ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public void onReceive(final Context context, Intent intent) {
        executorService.execute(new Runnable() {
            @Override
            public void run() {

                try {
                    if (NetUtil.isNetworkAvailable(context)) {
                        PushLog.inst()
                                .log(TAG + ".onReceive, network changed, network is avaiable");
                        if (TokenStore.getInstance().getFcmToken().equals("") &&
                                (GoogleApiAvailability.getInstance()
                                        .isGooglePlayServicesAvailable(context) ==
                                        ConnectionResult.SUCCESS || GoogleApiAvailability
                                        .getInstance().isGooglePlayServicesAvailable(context) ==
                                        ConnectionResult.SERVICE_VERSION_UPDATE_REQUIRED)) {
                            FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener(
                                    new OnCompleteListener<InstanceIdResult>() {
                                        @Override
                                        public void onComplete(
                                                @NonNull Task<InstanceIdResult> task) {
                                            executorService.execute(new Runnable() {
                                                @Override
                                                public void run() {
                                                    if (!task.isSuccessful()) {
                                                        PushLog.inst().log(TAG +
                                                                ".onReceive getInstanceId failed:" +
                                                                task.getException());
                                                        Log.e(TAG,
                                                                "onComplete task is not successful exception:" +
                                                                        task.getException());
                                                        PushReporter.getInstance()
                                                                .reportEvent(YYPushStatisticEvent
                                                                                .REGISTER_FCM_TOKEN_FAILURE,
                                                                        task.getException().getMessage());
                                                        KLogW.i(YYPushStatisticEvent.REGISTER_FCM_TOKEN_FAILURE,
                                                                task.getException().getMessage());
                                                        return;
                                                    }
                                                    // Get new Instance ID token
                                                    String refreshedToken = "";
                                                    if (task.getResult() != null) {
                                                        refreshedToken = task.getResult().getToken();
                                                    }
                                                    if (!TextUtils.isEmpty(refreshedToken)) {
                                                        if (isJsonObject(refreshedToken)) {
                                                            PushReporter.getInstance()
                                                                    .newReportSucEvtToHiido(
                                                                            YYPushConsts.HIIDO_FCM_TOKEN_CALLBACK_ISJSONOBJECT);
                                                            JSONObject jsonObject;
                                                            try {
                                                                jsonObject = new JSONObject(refreshedToken);
                                                                refreshedToken =
                                                                        jsonObject.getString("token");
                                                            } catch (JSONException e) {
                                                                e.printStackTrace();
                                                            }
                                                        }
                                                        PushLog.inst().log(TAG + ".onReceive  Fcm Token:" +
                                                                refreshedToken);
                                                        TokenStore.getInstance()
                                                                .dispatchToken(context,
                                                                        ThirdPartyPushType.PUSH_TYPE_FCM,
                                                                        refreshedToken);
                                                        YYPushDeviceInfoHttp.getInstance()
                                                                .addThirdpartyToken(
                                                                        ThirdPartyPushType.PUSH_TYPE_FCM,
                                                                        refreshedToken);
                                                        PushReporter.getInstance()
                                                                .newReportSucEvtToHiido(
                                                                        YYPushConsts.HIIDO_FCM_TOKEN_RES_EVENT_ID);
                                                        PushReporter.getInstance()
                                                                .reportEvent(
                                                                        YYPushStatisticEvent.REGISTER_FCM_TOKEN_SUCCESS);
                                                        String newFcmToken = "fcm:" + refreshedToken;
                                                        if (YYPushCallBackManager.getInstance()
                                                                .getPushTokenCallBack() != null) {
                                                            YYPushCallBackManager.getInstance()
                                                                    .getPushTokenCallBack()
                                                                    .onSuccess(newFcmToken);
                                                            PushLog.inst().log(TAG + ".onReceive, " +
                                                                    "call IYYPushTokenCallback.onSuccess, "
                                                                    + "token = " + newFcmToken);
                                                        }
                                                    } else {
                                                        PushReporter.getInstance()
                                                                .newReportFailEvtToHiido(
                                                                        YYPushConsts.HIIDO_FCM_TOKEN_RES_EVENT_ID,
                                                                        YYPushConsts.RES_FAIL,
                                                                        "task.getResult().getToken() is empty");
                                                    }
                                                }
                                            });

                                        }
                                    }).addOnFailureListener(new OnFailureListener() {
                                @Override
                                public void onFailure(@NonNull Exception e) {
                                    executorService.execute(new Runnable() {
                                        @Override
                                        public void run() {
                                            Log.e(TAG, "onFailure: " + e);
                                            PushLog.inst()
                                                    .log(TAG + ".onReceive onFailure exception:" +
                                                            e);
                                            PushReporter.getInstance()
                                                    .newReportFailEvtToHiido(
                                                            YYPushConsts.HIIDO_FCM_TOKEN_RES_EVENT_ID,
                                                            YYPushConsts.RES_FAIL, e.getMessage());
                                            PushReporter.getInstance().reportEvent(
                                                    YYPushStatisticEvent.REGISTER_FCM_TOKEN_FAILURE,
                                                    e
                                                            .getMessage());
                                            KLogW.i(YYPushStatisticEvent.REGISTER_FCM_TOKEN_FAILURE,
                                                    e
                                                            .getMessage());
                                        }
                                    });
                                }
                            });
                        }

                        if (YYPushDeviceInfoHttp.getInstance().isNeedTryUploadTokenToPushServer()) {
                            PushLog.inst().log(TAG +
                                    ".onReceive network is available try upload DeviceInfo again");
                            YYPushDeviceInfoHttp.getInstance()
                                    .tryUploadDeviceInfoToPushServerByHttp();
                        }
                        if (AppPushInfo.getIsNeedGetUnreadMsg() &&
                                !PushGetUnreadMsgHttp.getInstance().isRunningGetUnreadMsg() &&
                                !AppPushInfo.getUnreadMsgFlag()) {
                            PushLog.inst().log(TAG +
                                    ".onReceive network is available try getUnreadMsgFromPushServer");
                            PushGetUnreadMsgHttp.getInstance()
                                    .getUnreadMsgFromPushServer(context.getApplicationContext());
                        }

                        if (!TextUtils.isEmpty(AppPushInfo.getXiaomiID()) &&
                                !TextUtils.isEmpty(AppPushInfo.getXiaomiKey())) {
                            if (SystemUtil.isXiaoMi() && SystemUtil.isMiUi()
                                    && TokenStore.getInstance().getSysToken().equals("")) {
                                PushLog.inst().log(TAG +
                                        ".onReceive, current xiaomitoken is null, " +
                                        "net is connected, call the RegisterXiaomiSdk again");
                                MiPushClient.registerPush(context, AppPushInfo.getXiaomiID(),
                                        AppPushInfo.getXiaomiKey());
                            }
                        }
                        if (TokenStore.getInstance().getTokenID().equals("")) {
                            YYTokenLoginHttp.getinstance().registerYYPush(context);
                        }

                    } else {
                        PushLog.inst().log(TAG + ".onReceive, network changed, network is disable");
                    }

                } catch (Exception e) {
                    PushLog.inst().log(TAG + ".onReceive, exception:" + e.toString());
                }
            }
        });
    }

    private boolean isJsonObject(String content) {
        try {
            JSONObject jsonObject = new JSONObject(content);
            if (jsonObject.has("token")) {
                PushLog.inst().log(TAG + ".isJsonObject getToken from fcm , token:" + jsonObject.getString("token"));
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            PushLog.inst().log(TAG + ".isJsonObject exception:" + e);
            return false;
        }
    }
}
