package com.yy.pushsvc.log;

import android.util.Log;

import com.yy.pushsvc.BuildConfig;
import com.yy.pushsvc.util.AppInfo;
import com.yy.pushsvc.util.PushFileHelper;
import com.yy.pushsvc.util.StringUtil;

import java.io.File;
import java.io.FileWriter;

public class LogcatHandler implements ILogHandler {
    private static final String PUSH_FILE_NAME = "pushsvc_log.txt";
    private static int MAX_LOG_COUNT = 15000;
    private boolean bLog = false;
    private volatile FileWriter writer = null;
    private int logCount = 0;
    private boolean mLogFailed = false;
    private boolean mLogCreated = false;
    private File mLogFile = null;
    private LogConfig logConfig;

    public LogcatHandler(LogConfig logConfig) {
        this.logConfig = logConfig;
        init();
    }

    @Override
    public void i(String msg) {
        if (BuildConfig.VERSION_NAME.toUpperCase().contains("SNAPSHOT")) {
            Log.i("PushLog", msg);
        }
        logInner(msg);
    }

    private void logInner(String msg) {
        if (!this.bLog) {
            return;
        }
        try {
            writer = new FileWriter(mLogFile, true);
            checkLogCount(false);
            writer.write(msg);
            writer.flush();
            writer.close();
            this.logCount++;
        } catch (Exception e) {
            if (!mLogFailed) {
                mLogFailed = true;
                if (e.getMessage() != null) {
                    Log.e("PushLog", "logInner exception:" + e.getMessage());
                } else {
                    Log.e("PushLog", "PushLog.log error");
                }
            }
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void init() {
        if (mLogCreated) {
            return;
        }

        if (StringUtil.isNullOrEmpty(logConfig.getLogDir())) {
            logConfig.setLogDir(PushFileHelper.instance().getPushLogDir());
        }
        try {
            String logFilePath = logConfig.getLogDir() + File.separator
                    + PUSH_FILE_NAME;
            PushFileHelper.instance().createFile(logFilePath);
            File logFile = new File(logFilePath);
            if (logFile.length() > 1024 * 1024 * 1.5) {
                checkLogCount(true);
            }
            if (logFile.exists()) {
                mLogCreated = true;
                this.bLog = true;
                mLogFile = logFile;
            }
        } catch (Exception e) {
            Log.e("PushLog", "init exception:" + e.getMessage());
        }
    }

    private void checkLogCount(boolean force) {
        if (this.logCount >= MAX_LOG_COUNT || force) {
            try {
                final String logFilePath = logConfig.getLogDir() + File.separator
                        + PUSH_FILE_NAME;
                final String bakFilePath =logConfig.getLogDir() + File.separator
                        + AppInfo.instance().getLogNameBak();

                File logFile = new File(logFilePath);
                File bakFile = new File(bakFilePath);
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                logFile.renameTo(bakFile);

                logFile.createNewFile();
                mLogFile = logFile;
            } catch (Exception e) {
                Log.e("PushLog", "checkLogCount exception:" + e);
            } finally {
                this.logCount = 0;
            }
        }
    }

}
