package com.yy.pushsvc.locknotification;

import android.util.Log;
import android.view.View;

import androidx.viewpager.widget.ViewPager;

public class ZoomOutPagerTransformer implements ViewPager.PageTransformer {
    private float minScale = 0.70f;

    //    private float MIN_ALPHA = 0.5f;
    public ZoomOutPagerTransformer() {
    }

    public ZoomOutPagerTransformer(float minScale) {
        this.minScale = minScale;
    }

    @Override
    public void transformPage(View page, float position) {
        if (position < -1 || position > 1) {
//            page.setAlpha(MIN_ALPHA);
            page.setScaleX(minScale);
            page.setScaleY(minScale);
        } else if (position <= 1) { // [-1,1]
            if (position < 0) {
                float scaleX = 1 + (1 - minScale) * position;
                Log.d("google_lenve_fb", "transformPage: scaleX:" + scaleX);
                page.setScaleX(scaleX);
                page.setScaleY(scaleX);
            } else {
                float scaleX = 1 - (1 - minScale)  * position;
                page.setScaleX(scaleX);
                page.setScaleY(scaleX);
            }
//            page.setAlpha(MIN_ALPHA + (scaleFactor - MIN_SCALE) / (1 - MIN_SCALE) * (1 - MIN_ALPHA));
        }
    }

}
