package com.yy.pushsvc.locknotification;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.yy.hiidostatis.defs.obj.Property;
import com.yy.pushsvc.R;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.template.ClickIntentUtil;
import com.yy.pushsvc.template.NoficationBar;
import com.yy.pushsvc.template.OnViewClickListener;
import com.yy.pushsvc.template.PushNotModleUtil;
import com.yy.pushsvc.template.TemplateManager;
import com.yy.pushsvc.template.ViewEntity;
import com.yy.pushsvc.template.YYPushCustomViewUtil;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.RomUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by GuanYuFeng
 * on 2020/1/9
 */
public class ViewBuilder {
    private static final String TAG = "LockViewBuilder";
    private static final String DEFAULT_TITLE = "Hi ~";
    private static final String DEFAULT_DESC  = "You got one message";
    private FackClickManager fackClickManager = new FackClickManager();

    public  List<View> getNotificationView(Activity context, ArrayList<LockInfo> listInfos,
                                                 boolean isDark) {

        List<View> result = new ArrayList<>();
        try {
            int size = listInfos.size();
            if (listInfos != null && size > 0) {
                int times = 1;
                if (listInfos.size() >= 3 && listInfos.size() < 6) {
                    times = 2;
                }
                for(int j=0;j<times;j++){
                    for (int i = 0; i < size; i++) {
                        YYPushCustomViewUtil yyPushCustomViewUtil = new YYPushCustomViewUtil();
                        LockInfo entity = listInfos.get(i);
                        ClipLinearview notificationView = new ClipLinearview(context);
                        notificationView.setBackgroundColor(isDark ? Color.BLACK : Color.WHITE);
                        JSONObject payload = new JSONObject(entity.payload);
                        if (payload == null) {
                            return result;
                        }
                        String title = payload.optString("title", DEFAULT_TITLE
                        );
                        String content = payload.optString("desc",DEFAULT_DESC);
                        final int largeModelId = payload.getInt("yycustompushlargetype");
                        final PushNotModleUtil pm = PushNotModleUtil.getInstance(context);
                        String largeModleJson = pm.getFromData(largeModelId + "");
                        if (!TextUtils.isEmpty(largeModleJson)) {
                            yyPushCustomViewUtil.init(entity.pushId + "",
                                    entity.msgId,
                                    entity.channelType,
                                    payload,
                                    context,
                                    true,
                                    largeModleJson,
                                    TemplateManager.getInstance().getConfig().getImgFailCallback());
                            ViewEntity viewEntity = yyPushCustomViewUtil
                                    .parsePushCustomContent(false, notificationView,
                                            new MyViewClickListener(context));
                            if (viewEntity != null && viewEntity.mView != null) {
                                notificationView.addView(viewEntity.mView);
                                result.add(getPageView(context, notificationView, title, entity,
                                        content));
                            }
                        }
                        yyPushCustomViewUtil.handlePushImages();
                    }
                }
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ",showNotification(),erro=" + e.toString());
        }
        return result;
    }

    private View getPageView(Activity context ,View templateView,String title,LockInfo info ,
                             String content) {
        View pageView = View.inflate(context, R.layout.item_viewpage, null);
        LinearLayout llTemplate = pageView.findViewById(R.id.llTemplate);
        llTemplate.addView(templateView);
        TextView tvTitle = pageView.findViewById(R.id.tvTitle);
        TextView tvContent = pageView.findViewById(R.id.tvContent);
        tvTitle.setText(title);
        tvContent.setText(content);
        TextView tvGO = pageView.findViewById(R.id.tvGO);
        pageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    Intent in = null;
                    in = TemplateManager.getInstance()
                            .getClassIntent(new JSONObject(info.payload),
                                    NotificationUtil.createNotificationId(info.msgId), info.msgId,
                                    info.channelType);
                    fackClickManager.onClick(context, in);
                } catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        return pageView;
    }

    class MyViewClickListener implements OnViewClickListener {
        private Activity act;

        public MyViewClickListener(Activity act) {
            this.act = act;
        }

        @Override
        public void onViewClick(Intent in) {
            fackClickManager.onClick(act, in);
        }
    }

}
