package com.yy.pushsvc.locknotification;

import android.content.Context;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.FrameLayout;

import com.yy.pushsvc.R;

public class PushGalleryIndicator extends FrameLayout {

    private static final String TAG = "PushGalleryIndicator";
    private View indicatorView;

    public PushGalleryIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context);
    }

    public PushGalleryIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public PushGalleryIndicator(Context context) {
        super(context);
        init(context);
    }

    private void init(Context context) {
        setBackgroundResource(R.drawable.shape_indicator_bg);
        indicatorView = new View(context);
        indicatorView.setBackgroundResource(R.drawable.shape_indicator_fore);
        addView(indicatorView);
    }

    public void setIndicatorWidth(int width) {
        LayoutParams params = (LayoutParams) indicatorView.getLayoutParams();
        params.gravity = Gravity.START;
        params.width = width;
    }

    public void setIndicatorTranslationX(float transX) {
        indicatorView.setTranslationX(transX);
    }

    public int getIndicatorWidth() {
        return indicatorView.getWidth();
    }
}
