package com.yy.pushsvc.locknotification;

import android.content.Context;

import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.util.PushLog;

import java.util.ArrayList;

public class LockNotificationManager {
    private static final String TAG = "LockNotificationManager";
    private static volatile LockNotificationManager instance;
    private boolean mEnable;

    public static LockNotificationManager getInstance() {
        if (instance == null) {
            synchronized (LockNotificationManager.class) {
                if (instance == null) {
                    instance = new LockNotificationManager();
                }
            }
        }
        return instance;
    }

    private LockNotificationManager(){
        YYPushMsgDispacher.getInstance().addFirst(LockIntercept.getInstance());
    }


    /**
     * 调用init()函数开启锁屏通知功能；
     * payload字段包含isLockNotification：1  时标记该通知为锁屏通知
     * @param context
     * @param enable  功能开关
     */
    public void init(Context context,boolean enable) {
        mEnable = enable;
        LockIntercept.getInstance().setEnable(mEnable);
        ScreenManager.getInstance(context);
    }

    public void showNotification(Context context, ArrayList<LockInfo> entity) {
        PushLog.inst()
                .log(TAG + ",context = " + context + ",entity=" + entity + ",mEnable = " + mEnable);
        if (mEnable) {
            if (entity != null && entity.size() > 0) {
                LockActivity.startMyself(context, entity);
                FackDBHelper.getInstance(context).removeAllLockInfos();
            }
        }

    }

}
