package com.yy.pushsvc.locknotification;

import android.content.Context;
import android.content.Intent;

import com.yy.pushsvc.facknotification.FackManager;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.YYPushConsts;

import org.json.JSONObject;

/**
 * Created by GuanYuFeng
 * on 2020/3/16
 */
public class LockIntercept implements YYPushMsgDispacher.IChainIntercept {

    private static final String TAG = "LockMsgHandler";
    private static final String PUSH_NOTIFICATION_LARGE_TYPE = "yycustompushlargetype";
    private static final String PUSH_NOTIFICATION_LARGE_DATA = "yycustompushlargedata";
    private static volatile LockIntercept instance;
    private boolean mEnable;

    /**
     * payload内字段
     * lock ==1 表示为锁屏通知
     * */
    private static final String isLockNotification = "lock";


    public static LockIntercept getInstance() {
        if (instance == null) {
            synchronized (LockIntercept.class) {
                if (instance == null) {
                    instance = new LockIntercept();
                }
            }
        }
        return instance;
    }

    private LockIntercept() {
    }

    public boolean isEnable() {
        return mEnable;
    }

    public void setEnable(boolean enable) {
        mEnable = enable;
    }

    @Override
    public boolean intercept(Intent intent, Context ctx) {
        return checkLockMsg(intent, ctx);
    }

    /**
     * 锁屏通知
     *
     * @param intent
     * @param ctx
     * @return
     */
    private boolean checkLockMsg(Intent intent, Context ctx) {
        if (!mEnable) {
            return false;
        }
        boolean isLockMsg = false;
        try {
            if (intent != null && ctx != null) {
                if (intent.hasExtra(YYPushConsts.YY_PUSH_KEY_PAYLOAD)) {
                    String payload = new String(intent.getByteArrayExtra(
                            YYPushConsts.YY_PUSH_KEY_PAYLOAD));
                    if (isLockPayload(payload)) {
                       LockInfo lockInfo =
                                new LockInfo(
                                        intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_MSGID, 0),
                                        intent.getLongExtra(YYPushConsts.YY_PUSH_KEY_PUSHID, 0),
                                        new String(
                                                intent.getByteArrayExtra(
                                                        YYPushConsts.YY_PUSH_KEY_PAYLOAD)),
                                        intent.getStringExtra(YYPushConsts.YY_PUSH_KEY_CHANNELTYPE),
                                        "");
                        FackDBHelper.getInstance(ctx).saveLockInfo(lockInfo);
                        isLockMsg = true;
                    }
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",checkLockMsg ,erro=" + t);
        }
        return isLockMsg;
    }

    private boolean isLockPayload(String payloadStr) {
        boolean success = false;
        try {
            JSONObject payload = new JSONObject(payloadStr);
            if (payload.has(PUSH_NOTIFICATION_LARGE_TYPE) &&
                    payload.has(PUSH_NOTIFICATION_LARGE_DATA)) {
                JSONObject pushsdk = payload.optJSONObject(YYPushConsts.PAYLOAD_PUSHSDK_KEY);
                if (pushsdk.optInt(isLockNotification, 0) == 1) {
                    success = true;
                }

            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ",isLockPayload ,erro=" + e);
        }
        PushLog.inst().log(TAG + ",isLockPayload= " + success);
        return success;
    }

}
