package com.yy.pushsvc.locknotification;

import android.content.Context;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;

import com.yy.pushsvc.R;
import com.yy.pushsvc.util.ScreenUtil;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Created by GuanYuFeng
 * on 2020/3/24
 */
public class LockIndicator extends FrameLayout {
    private static final float ITEM_WIDTH = 13f;
    private View indicatorView;
    private  LinearLayout ll;
    public LockIndicator(@NonNull Context context) {
        super(context);
        init(context);
    }

    public LockIndicator(@NonNull Context context,
                         @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public LockIndicator(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        ll = new LinearLayout(getContext());
        indicatorView = new View(context);
        indicatorView.setBackgroundResource(R.drawable.shape_indicator_fore);
        addView(ll);
        addView(indicatorView);
    }


    public void setSize(int dotSize) {
        if (dotSize <= 1) {
            setVisibility(View.GONE);
        } else {
            for (int i = 0; i < dotSize; i++) {
                View dot = View.inflate(getContext(), R.layout.view_dot, null);
                ll.addView(dot);
            }
            setIndicatorWidth(ScreenUtil.dpToPx(ITEM_WIDTH));
        }
        invalidate();
    }

    private void setIndicatorWidth(int width) {
        LayoutParams params = (LayoutParams) indicatorView.getLayoutParams();
        params.gravity = Gravity.START;
        params.width = width;
    }

    public void setIndicatorTranslationX(float transX) {
        indicatorView.setTranslationX(transX);
    }

    public int getIndicatorWidth() {
        return indicatorView.getWidth();
    }
}
