package com.yy.pushsvc.locknotification;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.app.WallpaperManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.yy.hiidostatis.defs.obj.Property;
import com.yy.pushsvc.IMsgArriveCallback;
import com.yy.pushsvc.R;
import com.yy.pushsvc.facknotification.FackConst;
import com.yy.pushsvc.receiver.YYPushMsgDispacher;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.template.NoficationBar;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.RomUtils;
import com.yy.pushsvc.util.TimeUtils;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

public class LockActivity extends Activity {

    private static final String TAG = "LockActivity";
    private static final String INTENT_ENTITY = "INTENT_ENTITY";
    private static final int LOOP_TIME = 5;
    private ArrayList<LockInfo> entity;
    private List<View> views;
    private ViewPager viewpager;
    private ViewPagerAdapter pagerAdapter;
    private LockIndicator mPagerNavigation;
    private SystemTimeChangedReceiver receiver;
    private TextView mTimeTv;
    private TextView mYearTv;
    private LinearLayout llUnlock;
    private TextView tvUnlock;
    private boolean isRoll = false;//小于两张图片就不需要滚动了
    private Runnable autoLoop = new AutoLoopRunnable();
    private int scrollState;
    private View rlSwipeUnlock;

    public static void startMyself(Context context, ArrayList<LockInfo> entity) {
        if (entity == null) {
            return;
        }
        PushLog.inst().log(TAG + ",startActivity()");
        Intent in = new Intent(context, LockActivity.class);
        in.putExtra(INTENT_ENTITY, entity);
        in.addCategory(Intent.CATEGORY_DEFAULT);
        in.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(in);
    }

    @Override
    protected void onCreate( Bundle savedInstanceState) {
        try {
            PushLog.inst().log(TAG + ",onCreate()");
            setImmersiveSticky();
            setStatusBarColor();
            hideNavigation();
            setLockShow();
            setBlurBackground();
            super.onCreate(savedInstanceState);
            setContentView(R.layout.activity_push_lock_pager);
            entity = (ArrayList<LockInfo>) getIntent().getSerializableExtra(INTENT_ENTITY);
            PushLog.inst().log(TAG + ",entitySize=" + entity.size());
            boolean isDark = new NoficationBar().isDarkNotificationBar(this);
            views = new ViewBuilder().getNotificationView(this, entity, isDark);
            if (views == null || views.size() == 0) {
                finish();
            }
            if (views != null && views.size() > 4) {
                isRoll = true;
            } else {
                isRoll = false;
            }
            initView();

            for (LockInfo info : entity) {
                reportShow(info.msgId, info.payload, info.pushId + "", info.channelType);
            }
        } catch (Throwable t) {
            finish();
            PushLog.inst().log(TAG + ",onCreate(),erro=" + t.toString());
        }
    }

    private void setLockShow() {
        try {
            Window win = getWindow();
            win.addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED);
            if (RomUtils.isXiaomi() && Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
                win.addFlags(WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD);
            }
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O_MR1) {
                setShowWhenLocked(true);
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",setLockShow error:" + t);
        }
    }

    public void setImmersiveSticky() {
        try{
            int flag = WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS;
            getWindow().setFlags(flag, flag);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                getWindow().getDecorView().setSystemUiVisibility(
                        View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                                | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                                | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
            }
        }catch (Throwable t){
            PushLog.inst().log(TAG + ",setImmersiveSticky error:" + t);
        }
    }

    private void hideNavigation() {
        try{
            WindowManager.LayoutParams params = getWindow().getAttributes();
            params.systemUiVisibility =
                    View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_IMMERSIVE;
            getWindow().setAttributes(params);
        }catch (Throwable t){
            PushLog.inst().log(TAG + ",hideNavigation error:" + t);
        }
    }

    private void setStatusBarColor() {
        try {
            getWindow().addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            getWindow().clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                getWindow().setStatusBarColor(Color.TRANSPARENT);
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ",setStatusBarColor error:" + e);
        }
    }

    @SuppressLint("CheckResult")
    private void setBlurBackground() {
        try {
            Window win = getWindow();
            if (ContextCompat.checkSelfPermission(this, Manifest.permission.READ_EXTERNAL_STORAGE)
                    == PackageManager.PERMISSION_GRANTED) {
                WallpaperManager wallpaperManager = WallpaperManager.getInstance(this);
                Drawable wallpaper = wallpaperManager.getDrawable();
                if (wallpaper == null) {
                    PushLog.inst().log(TAG + ",wallpaper==null");
                    win.setBackgroundDrawableResource(R.drawable.icon_gallery_bg_default);
                }
            }
        } catch (Exception e) {
            PushLog.inst().log(TAG + ",checkSelfPermission error:" + e);
        }
    }

    private void initView() {
        try {
            viewpager = findViewById(R.id.ll_lock_pager_viewpager);
            mPagerNavigation = findViewById(R.id.tv_lock_pager_navigation);
            mTimeTv = findViewById(R.id.tv_lock_pager_time);
            mYearTv = findViewById(R.id.tv_lock_pager_year);
            llUnlock = findViewById(R.id.llUnlock);
            tvUnlock = findViewById(R.id.tvUnlock);
            rlSwipeUnlock = findViewById(R.id.rlSwipeUnlock);
            rlSwipeUnlock.setOnTouchListener(onTouchListener);
            IntentFilter filter = new IntentFilter();
            filter.addAction(Intent.ACTION_TIME_TICK);
            receiver = new SystemTimeChangedReceiver();
            registerReceiver(receiver, filter);
            setCurTime();
            findViewById(R.id.ll_lock_pager_close).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    keyguardFinish();
                }
            });
            if (isRoll) {
                mPagerNavigation.setSize(views.size() / 2);
            } else {
                mPagerNavigation.setSize(views.size());
            }
            pagerAdapter = new ViewPagerAdapter();
            viewpager.setAdapter(pagerAdapter);
            viewpager.setOffscreenPageLimit(2);
            viewpager.setPageTransformer(true, new ZoomOutPagerTransformer(0.8f));
            viewpager.addOnPageChangeListener(mOnPageChangeListener);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",initView,erro" + t);
        }
    }

    private void reportShow(long msgId,String payload, String pushId, String channelType) {
        try {
            YYPushMsgDispacher.getInstance().onPushSDKNotificationShow(msgId, payload.getBytes(),
                    channelType, IMsgArriveCallback.NOTIFICATION_LOCK_TYPE, this);
            Property property = new Property();
            property.putString("msgid", String.valueOf(msgId));
            property.putString("pushid", String.valueOf(pushId));
            PushReporter.getInstance()
                    .reportNotificationEventToHiido(
                            FackConst.HIIDO_PUSH_LOCK_NOTIFICATION_SHOW,
                            channelType, property);
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",reportShow,erro" + t);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        setCurrentItem();
    }

    private void setCurrentItem(){
        try{
            if(isRoll){
                int pos = Integer.MAX_VALUE / 2 - (Integer.MAX_VALUE / 2 % views.size());
                viewpager.setCurrentItem(pos);
            }else{
                viewpager.setCurrentItem(0);
            }
            startAutoLoop();
        }catch (Throwable t){
            PushLog.inst().log(TAG + ",setCurrentItem,erro" + t);
        }
    }

    private void keyguardFinish() {
        try {
            KeyguardManager mKeyguardManager =
                    (KeyguardManager) getSystemService(Context.KEYGUARD_SERVICE);
            if (mKeyguardManager != null) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && !RomUtils.isOppo()) {
                    if (isKeyguardLocked()) {
                        mKeyguardManager.requestDismissKeyguard(LockActivity.this, null);
                    }
                }
            }
            finish();
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",keyguardFinish,erro" + t);
        }
    }

    private void setCurTime() {
        try {
            int hour = TimeUtils.getHourOf24HClock(System.currentTimeMillis());
            int minute = TimeUtils.getMinute(System.currentTimeMillis());
            if (minute < 10) {
                mTimeTv.setText(hour + ":0" + minute);
            } else {
                mTimeTv.setText(hour + ":" + minute);
            }
            mYearTv.setText(TimeUtils.getFormatTimeString(System.currentTimeMillis(), "year-mon-day"));
        }catch (Throwable t){
            PushLog.inst().log(TAG + ",setCurTime,erro" + t);
        }
    }

    @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
    private boolean isKeyguardLocked() {
        boolean isKeyguardLocked = false;
        try {
            KeyguardManager mKeyguardManager =
                    (KeyguardManager) getSystemService(Context.KEYGUARD_SERVICE);
            if (mKeyguardManager != null) {
                isKeyguardLocked = mKeyguardManager.isKeyguardLocked();
            }
        }catch (Throwable t){
            PushLog.inst().log(TAG + ",isKeyguardLocked,erro" + t);
        }
        return isKeyguardLocked;
    }

    @Override
    protected void onPause() {
        super.onPause();
        PushLog.inst().log(TAG + ",onPause");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            PushLog.inst().log(TAG + ",onDestroy");
            viewpager.removeCallbacks(autoLoop);
            if (receiver != null) {
                unregisterReceiver(receiver);
                receiver = null;
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",onDestroy,erro" + t);
        }
    }

    private ViewPager.OnPageChangeListener mOnPageChangeListener =
            new ViewPager.OnPageChangeListener() {

        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            try {
                Log.i("onPageScrolled", "position = " + position + ",positionOffset=" + positionOffset +
                        ",positionOffsetPixels=" + positionOffsetPixels);
                int realPosition = 0;
                if(isRoll){
                    realPosition = position % (views.size()/2);
                }else{
                    realPosition = position % (views.size());
                }
                float transX = realPosition * mPagerNavigation.getIndicatorWidth() +
                        positionOffset * mPagerNavigation.getIndicatorWidth();
                mPagerNavigation.setIndicatorTranslationX(transX);
            }catch (Throwable t){
                Log.i("onPageScrolled", "erro = " + t);
            }
        }

        @Override
        public void onPageSelected(int position) {
            Log.i("onPageSelected", "position = " + position);
        }

        @Override
        public void onPageScrollStateChanged(int state) {
            scrollState = state;
            Log.i("onPageScrollState", "state = " + state);
        }
    };

    class ViewPagerAdapter extends PagerAdapter {

        @Override
        public int getCount() {
            int count = 0;
            try {
                if (isRoll) {
                    count = Integer.MAX_VALUE;
                } else {
                    count = views.size();
                }
            } catch (Throwable t) {
                PushLog.inst().log(TAG + "，ViewPagerAdapter,erro = " + t);
            }
            return count;
        }

        @Override
        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        @Override
        public Object instantiateItem(ViewGroup container, int position) {
            int dataPosition = 0;
            try {
                if (isRoll) {
                    dataPosition = position % views.size();
                    PushLog.inst()
                            .log(TAG + ",instantiateItem,position= " + position +
                                    ",dataPosition = " +
                                    dataPosition);
                    container.addView(views.get(dataPosition));
                } else {
                    dataPosition = position;
                    container.addView(views.get(position));
                }
            } catch (Throwable e) {
                PushLog.inst()
                        .log(TAG + ",instantiateItem,erro = " + e + ",position=" + position +
                                ",dataPosition = " +
                                dataPosition);
            }
            return views.get(dataPosition);
        }

        @Override
        public void destroyItem(ViewGroup container, int position,
                                Object object) {
            int dataPosition = position;
            try {
                if (isRoll) {
                    dataPosition = position % views.size();
                    PushLog.inst()
                            .log(TAG + ",destroyItem,position= " + position + ",dataPosition = " +
                                    dataPosition);
                    container.removeView(views.get(dataPosition));
                } else {
                    container.removeView(views.get(position));
                }
            } catch (Throwable e) {
                PushLog.inst().log(TAG + ",destroyItem,erro = " + e + ",position=" + position +
                        ",dataPosition = " +
                        dataPosition);
            }
        }
    }

    class SystemTimeChangedReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getAction().equals(Intent.ACTION_TIME_TICK)) {
                    setCurTime();
                }
            } catch (Throwable t) {
                PushLog.inst().log(TAG + "，SystemTimeChangedReceiver,erro = " + t);
            }
        }
    }

    private void startAutoLoop() {
        try {
            if (views != null && views.size() > 1) {
                viewpager.removeCallbacks(autoLoop);
                viewpager.postDelayed(autoLoop, LOOP_TIME);
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + "，startAutoLoop,erro = " + t);
        }
    }

    @Override
    public void finish() {
        super.finish();
        overridePendingTransition(0, R.anim.notification_finish_exit);
    }


    private float downY;
    private static final float FLIP_DISTANCE = 50;
    private View.OnTouchListener onTouchListener = new View.OnTouchListener() {
        @Override
        public boolean onTouch(View v, MotionEvent event) {
            try {
                if (event.getAction() == MotionEvent.ACTION_DOWN) {
                    downY = event.getY();
                }
                if (event.getAction() == MotionEvent.ACTION_UP) {
                    if (downY - event.getY() > FLIP_DISTANCE) {
                        PushLog.inst().log(TAG + ",向上滑...");
                        keyguardFinish();
                        return true;
                    }
                }
            }catch (Throwable t){
                PushLog.inst().log(TAG + "，OnTouchListener,erro = " + t);
            }
            return true;
        }
    };


    class AutoLoopRunnable implements  Runnable {

        @Override
        public void run() {
            try {
                if (!LockActivity.this.isFinishing()) {
                    if (scrollState == ViewPager.SCROLL_STATE_IDLE) {
                        if (isRoll) {
                            viewpager.setCurrentItem(viewpager.getCurrentItem() + 1, true);
                        } else {
                            viewpager.setCurrentItem(viewpager.getCurrentItem() == 0 ? 1 : 0, true);
                        }
                    }
                    viewpager.postDelayed(autoLoop, LOOP_TIME * 1000);
                }
            } catch (Throwable t) {
                PushLog.inst().log(TAG + "，AutoLoopRunnable,erro = " + t);

            }
        }
    }
}
