package com.yy.pushsvc.locknotification;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.yy.pushsvc.util.PushLog;

import java.lang.reflect.Method;
import java.util.ArrayList;

public class FackDBHelper extends SQLiteOpenHelper {
    private volatile static FackDBHelper mInstance;
    private static final String TAG = FackDBHelper.class.getSimpleName();
    private static String mDBName = "com.yy.pushsvc.fackdb";
    private static int mDBVer = 1;

    public static FackDBHelper getInstance(Context context) {
        if (mInstance == null) {
            synchronized (FackDBHelper.class) {
                if (mInstance == null) {
                    mInstance = new FackDBHelper(context);
                }
            }
        }
        return mInstance;
    }


    private FackDBHelper(Context context) {
        super(context, mDBName, null, mDBVer);
    }


    @Override
    public void onCreate(SQLiteDatabase db) {
        PushLog.inst().log(TAG + ".onCreate ver=" + mDBVer);
        try {
            db.execSQL(
                    "create table LockInfo(id integer primary key autoincrement,msgId long,pushId" +
                            " long , payload text, channelType varchar(20),extra text);");
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ".onCreate can not create db error: " + e.toString());
        }
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        PushLog.inst().log(TAG + "onUpgrade oldVer=" + oldVersion + ", newVer=" + newVersion);
        for (int i = oldVersion; i < newVersion; i++) {
            int preVersion = i;
            int curVersion = i + 1;
            String methodName = "onUpgrade" + preVersion + "to" + curVersion;

            boolean result;
            try {
                Method method = getClass().getMethod(methodName,
                        SQLiteDatabase.class);
                result = (Boolean) method.invoke(this, db);
                if (!result) {
                    rebuildDB(db);
                    return;
                }
            } catch (Throwable e) {
                PushLog.inst().log(TAG + ".onUpgrade oldVer=" + oldVersion + ", newVer" +
                        "=" + newVersion + "err=" +
                        e.toString());
                rebuildDB(db);
                return;
            }
        }
    }

    private void rebuildDB(SQLiteDatabase db) {
        try {
            if (isTableExist(db, "LockInfo")) {
                db.execSQL("drop table LockInfo;");
            }
            db.execSQL(
                    "create table LockInfo(id integer primary key autoincrement,msgId long,pushId" +
                            " long , payload text, channelType varchar(20),extra text);");
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ".rebuildDB,erro= " + t);
        }
    }

    private boolean isTableExist(SQLiteDatabase db, String tabName) {
        boolean result = false;
        if (tabName == null) {
            return false;
        }
        Cursor cursor = null;
        try {
            String sql =
                    "select count(*) as c from sqlite_master where type ='table' and name ='" +
                            tabName.trim() + "' ";
            cursor = db.rawQuery(sql, null);
            if (cursor.moveToNext()) {
                int count = cursor.getInt(0);
                if (count > 0) {
                    result = true;
                }
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ".isTableExist... error" + e.getMessage());
        } finally {
            if (null != cursor && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return result;
    }

    public boolean saveLockInfo(LockInfo lockInfo) {
        try {
            SQLiteDatabase db = getWritableDatabase();
            if (db == null) {
                return false;
            }

            ContentValues cv = new ContentValues();
            cv.put("msgId", lockInfo.msgId);
            cv.put("pushId", lockInfo.pushId);
            cv.put("payload", lockInfo.payload);
            cv.put("channelType", lockInfo.channelType);
            cv.put("extra", lockInfo.extra);

            String deleteSame = "delete from LockInfo where msgId =  " + lockInfo.msgId;
            db.execSQL(deleteSame);
            if (db.insert("LockInfo", null, cv) < 0) {
                PushLog.inst().log(TAG + ".saveLockInfo failed on saving msgid to db");
                return false;
            }
            PushLog.inst().log(TAG + ".saveLockInfo successfully save msgid to db, " +
                    "msgid:" + lockInfo.msgId);
            String deleteSqlStr = "delete from LockInfo where " +
                    "(select count(id) from LockInfo) > 5 and id in " +
                    "(select id from LockInfo order by id desc limit (select count(id) from " +
                    "LockInfo) offset 5)";
            db.execSQL(deleteSqlStr);
            return true;
        } catch (Throwable e) {
            PushLog.inst()
                    .log(TAG + ".saveLockInfo can not open db for writeable: " + e.toString());
            return false;
        }
    }

    public ArrayList<LockInfo> getLockInfos() {
        ArrayList list = new ArrayList();
        Cursor tuple = null;
        try {

            SQLiteDatabase db = getReadableDatabase();
            if (db == null) {
                return list;
            }

            tuple = db.query("LockInfo", null, null, null, null, null,
                    null);
            while (tuple.moveToNext()) {
                LockInfo lockInfo = new LockInfo(tuple.getLong(tuple.getColumnIndex("msgId")),
                        tuple.getLong(tuple.getColumnIndex("pushId")),
                        tuple.getString(tuple.getColumnIndex("payload")),
                        tuple.getString(tuple.getColumnIndex("channelType")),
                        tuple.getString(tuple.getColumnIndex("extra")));
                list.add(lockInfo);
            }

        } catch (Throwable e) {
            PushLog.inst()
                    .log(TAG + ".saveRecvMsg can not open db for writeable: " + e.toString());
        } finally {
            if (tuple != null) {
                tuple.close();
            }
        }
        return list;
    }

    public void removeAllLockInfos() {
        try {
            SQLiteDatabase db = getWritableDatabase();
            if (db == null) {
                return;
            }
            String deleteSqlStr = "delete from LockInfo where id in " +
                    "(select id from LockInfo)";
            db.execSQL(deleteSqlStr);
        } catch (Throwable e) {
            PushLog.inst()
                    .log(TAG + ".saveRecvMsg can not open db for writeable: " + e.toString());
        }
    }
}
