package com.yy.pushsvc.locknotification;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;

import com.yy.hiidostatis.defs.obj.Property;
import com.yy.pushsvc.report.PushReporter;
import com.yy.pushsvc.template.ClickIntentUtil;
import com.yy.pushsvc.util.PushLog;
import com.yy.pushsvc.util.RomUtils;

/**
 * Created by GuanYuFeng
 * on 2020/3/24
 */
public class FackClickManager {
    private static final String TAG = "FackClickManager";

    public void onClick(Activity act, Intent in) {
        try {
            if (act != null) {
                KeyguardManager mKeyguardManager =
                        (KeyguardManager) act.getSystemService(Context.KEYGUARD_SERVICE);
                if (mKeyguardManager != null) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && !RomUtils.isOppo()) {
                        KeyguardManager.KeyguardDismissCallback callback =
                                new KeyguardManager.KeyguardDismissCallback() {
                                    @Override
                                    public void onDismissError() {
                                        PushLog.inst()
                                                .log("KeyguardDismissCallback" +
                                                        ",onDismissError");
                                        super.onDismissError();
                                    }

                                    @Override
                                    public void onDismissSucceeded() {
                                        PushLog.inst()
                                                .log("KeyguardDismissCallback" +
                                                        ",onDismissSucceeded");
                                        act.sendBroadcast(in);
                                        reportClick(in);
                                        act.finish();
                                        super.onDismissSucceeded();
                                    }

                                    @Override
                                    public void onDismissCancelled() {
                                        PushLog.inst()
                                                .log("KeyguardDismissCallback" +
                                                        ",onDismissCancelled");
                                        super.onDismissCancelled();
                                    }
                                };
                        mKeyguardManager.requestDismissKeyguard(act, callback);
                    } else {
                        if (isKeyguardLocked(act)) {
                            gotoDisableKeyguard(act);
                            reportClick(in);
                            act.finish();
                        } else {
                            act.sendBroadcast(in);
                            reportClick(in);
                            act.finish();
                        }
                    }
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",onViewClick,erro=" + t);
        }
    }

    private boolean isKeyguardLocked(Activity act) {
        boolean isKeyguardLocked = false;
        KeyguardManager mKeyguardManager =
                (KeyguardManager) act.getSystemService(Context.KEYGUARD_SERVICE);
        if (mKeyguardManager != null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                isKeyguardLocked = mKeyguardManager.isKeyguardLocked();
            }
        }
        return isKeyguardLocked;
    }

    private void reportClick(Intent in) {
        try {
            if (in != null) {
                long msgId = in.getLongExtra(ClickIntentUtil.MSG_ID, 0);
                String pushId = in.getStringExtra(ClickIntentUtil.PUSHI_D);
                String channelType = in.getStringExtra(ClickIntentUtil.CHANNEL_TYPE);
                Property property = new Property();
                property.putString("msgid", String.valueOf(msgId));
                property.putString("pushid", String.valueOf(pushId));
                PushReporter.getInstance()
                        .reportNotificationEventToHiido(
                                LockConst.HIIDO_PUSH_LOCK_NOTIFICATION_CLICKED,
                                channelType, property);
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ",reportClick,erro=" + e);
        }
    }

    private void gotoDisableKeyguard(Activity act) {
        long delay = 500;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && !RomUtils.isOppo()) {
            delay = 0;
        }
        Handler mainHander = new Handler(Looper.getMainLooper());
        mainHander.postDelayed(new Runnable() {
            @Override
            public void run() {
                DisableKeyguardActivity.launch(act.getApplication());
            }
        }, delay);
    }
}
