package com.yy.pushsvc.locknotification;

import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;

import com.yy.pushsvc.R;
import com.yy.pushsvc.util.RomUtils;

import androidx.fragment.app.FragmentActivity;

import static android.content.Intent.FLAG_ACTIVITY_NEW_TASK;

/**
 * Created by GuanYuFeng
 * on 2020/3/3
 */
public class DisableKeyguardActivity extends FragmentActivity {

    public static void launch(Context context) {
        Intent intent = new Intent(context, DisableKeyguardActivity.class);
        intent.addFlags(FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window win = getWindow();
        win.addFlags(WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD
                | WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON
                | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
        // Make us non-modal, so that others can receive touch events.
        win.setFlags(WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL,
                WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL);
        // ...but notify us that it happened.
        win.setFlags(WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH,
                WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH);

        KeyguardManager mKeyguardManager =
                (KeyguardManager) getSystemService(Context.KEYGUARD_SERVICE);
        if (mKeyguardManager != null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                // 对应旧版废弃的 FLAG_DISMISS_KEYGUARD
                mKeyguardManager.requestDismissKeyguard(this, null);
            }
        }

        if (RomUtils.isXiaomi() && Build.VERSION.SDK_INT < Build.VERSION_CODES.O) {
            win.addFlags(WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD);
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O_MR1) {
            setTurnScreenOn(true);
        }

        setContentView(R.layout.activity_disable_keyguard);

        WindowManager.LayoutParams params = win.getAttributes();
        params.alpha = 1.0f;
        win.setAttributes(params);
    }

    @Override
    protected void onResume() {
        super.onResume();
        long delay = 500;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O && !RomUtils.isOppo()) {
            delay = 0;
        }
        findViewById(R.id.fl).postDelayed(new Runnable() {
            @Override
            public void run() {
                finish();
            }
        }, delay);
    }
}
