package com.yy.pushsvc.locknotification;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.LinearLayout;

import com.yy.pushsvc.util.ScreenUtil;


/**
 * pageview画5dp圆角
 * Created by GuanYuFeng
 * on 2020/2/28
 */
public class ClipLinearview extends LinearLayout {
    private static final int RADIUS = 10;
    private int mRadius = RADIUS;

    public ClipLinearview(Context context) {
        super(context);
    }

    public ClipLinearview(Context context,AttributeSet attrs) {
        super(context, attrs);
    }

    public ClipLinearview(Context context,  AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setRadius(int radius) {
        mRadius = radius;
    }

    public void draw(Canvas canvas) {
        Path path = new Path();
        path.addRoundRect(new RectF(0, 0, getWidth(), getHeight()), ScreenUtil.dpToPx(mRadius),
                ScreenUtil.dpToPx(mRadius),
                Path.Direction.CW);
        canvas.clipPath(path);
        super.draw(canvas);
    }
}
