package com.yy.pushsvc.grouping;

import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;

import com.yy.pushsvc.IAcquireAppState;
import com.yy.pushsvc.YYPush;
import com.yy.pushsvc.facknotification.NotificationEntity;
import com.yy.pushsvc.util.NotificationUtil;
import com.yy.pushsvc.util.PushLog;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Created by GuanYuFeng
 * on 2020/9/7
 */
public class GroupingManager {
    private static final String TAG = "GroupingManager";
    private static final String push_source = "push_source";
    private static  List<GroupingEntity> mdata =null;
    private static HashMap<String,ArrayList<NotificationEntity>> groupData=new HashMap<>();

    public static void savePush(String groupKey, String notId) {
        try {
            ArrayList<NotificationEntity> data = groupData.get(groupKey);
            if (data == null) {
                data = new ArrayList<>();
                groupData.put(groupKey, data);
            }
            if (containNotID(data, notId) == null) {
                data.add(new NotificationEntity(groupKey, notId));
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",savePush:erro = " + t);
        }
    }

    public static NotificationEntity containNotID(ArrayList<NotificationEntity> data, String notId) {
        NotificationEntity result = null;
        try {
            if (data != null) {
                for (NotificationEntity entity : data) {
                    if (entity.notId.equals(notId)) {
                        result = entity;
                        return result;
                    }
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",containNotID:erro = " + t);
        }
        return result;
    }

    public static boolean hasGroupNotfication(String groupKey) {
        try {
            ArrayList<NotificationEntity> data = groupData.get(groupKey);
            if (data == null || data.size() == 0) {
                return false;
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",hasGroupNotfication:erro = " + t);
        }
        return true;
    }

    public static void removePush(String notId) {
        try {
            Iterator<Map.Entry<String, ArrayList<NotificationEntity>>> entries =
                    groupData.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, ArrayList<NotificationEntity>> entry = entries.next();
                ArrayList<NotificationEntity> data = entry.getValue();
                NotificationEntity en = containNotID(data, notId);
                if (en != null) {
                    data.remove(en);
                    if (data.size() == 0) {
                        NotificationUtil.cancleNotification(YYPush.getInstace().getContext(),
                                en.groupKey.hashCode());
                    }
                }
            }
        } catch (Throwable t) {
            PushLog.inst().log(TAG + ",removePush:erro = " + t);
        }
    }

    public static GroupingEntity getGroupEntity(JSONObject payload) {

        GroupingEntity entity = null;
        try {
            int pushSource = payload.optInt(push_source);
            IAcquireAppState acquireAppState = YYPush.getInstace().getAcquireAppState();
            if (mdata == null) {
                mdata = acquireAppState.getGroupingEntitys();
            }

            PushLog.inst().log(TAG + ",getGroupEntity,List = " + mdata);
            if (mdata != null) {
                GroupingEntity tempEntity = null;
                for (int i = 0; i < mdata.size(); i++) {
                    tempEntity = mdata.get(i);
                    if (tempEntity.others) {
                        entity = tempEntity;
                    }
                    List<Integer> ids = tempEntity.pushSources;
                    if (ids != null) {
                        for (int j = 0; j < ids.size(); j++) {
                            int id = ids.get(j);
                            if (pushSource == id) {
                                return tempEntity;
                            }
                        }
                    }

                }
            }
        } catch (Throwable e) {
            PushLog.inst().log(TAG + ",getGroupEntity,erro = " + e);
        }
        return entity;
    }

    static class NotificationEntity {
        public String groupKey;
        public String notId;

        public NotificationEntity(String groupKey, String notId) {
            this.groupKey = groupKey;
            this.notId = notId;
        }
    }

}
