package com.yy.pushsvc.grouping;

import java.util.List;

/**
 * Created by GuanYuFeng
 * on 2020/9/7
 */
public class GroupingEntity {
    public String groupName;
    public int priority;
    public boolean others;
    public boolean isOperation;
    public int maxCount;
    public List<Integer> pushSources;

    /**
     * @param groupName  分组名
     * @param priority  优先级，目前没有
     * @param others  其它，默认分组
     * @param isOperation  是否是运营后台推送
     * @param maxCount  运营后台推送字段，最多展示多少条，3条
     * @param pushSources  分组的sourcesId
     */
    public GroupingEntity(String groupName, int priority, boolean others, boolean isOperation,
                          int maxCount,
                          List<Integer> pushSources) {
        this.groupName = groupName;
        this.priority = priority;
        this.others = others;
        this.isOperation = isOperation;
        this.maxCount = maxCount;
        this.pushSources = pushSources;
    }

    @Override
    public String toString() {
        return "GroupingEntity{" +
                "groupName='" + groupName + '\'' +
                ", priority=" + priority +
                ", others=" + others +
                ", isOperation=" + isOperation +
                ", maxCount=" + maxCount +
                ", pushSources=" + pushSources +
                '}';
    }
}
